#include "fabm_driver.h"

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                                                                        !
!                                                                        !
!     ERGOM model CGT version ported to FABM by Hagen Radtke             !
!     (Leibniz Institute for Baltic Sea Research Warnemnde - IOW).      !
!     Code automatically generated by Code Generation Tool Version <cgt_version> !
!     See www.ergom.net                                                  !
!                                                                        !
!                                                                        !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!-----------------------------------------------------------------------
!BOP
!
! !MODULE: fabm\_iow\_ergom --- Biogeochemical model ERGOM
!
! !INTERFACE:
   module fabm_iow_ergom
!
! !DESCRIPTION:
! Model: <name> Version <version> \\
! <description> \\
! Author(s): <author> \\
! Contact: <contact> \\
! Code generated: <now>
!
! !USES:
   use fabm_types

   implicit none

   private
!
! !PUBLIC MEMBER FUNCTIONS:
   public type_iow_ergom
!
! !REVISION HISTORY:
!  Author(s):
!
! !PUBLIC_DERIVED_TYPES:
   type,extends(type_base_model) :: type_iow_ergom
! Variable identifiers
    <tracers vertLoc=WAT>
      type (type_state_variable_id)        :: id_<name>
    </tracers>
      type (type_state_variable_id)        :: id_t_dic
    <tracers vertLoc=SED>
      type (type_bottom_state_variable_id) :: id_<name>
    </tracers>
      type (type_dependency_id)            :: id_par,id_temp,id_salt
      type (type_horizontal_dependency_id) :: id_I_0,id_wind,id_taub
      type (type_horizontal_dependency_id) :: id_depth, id_lat, id_lon
!      type (type_diagnostic_variable_id)   :: id_dPAR,id_GPP,id_NCP,id_PPR,id_NPR
    <auxiliaries vertLoc=WAT; isOutput=1>
      type (type_diagnostic_variable_id)   :: id_<name>
    </auxiliaries>
    <processes vertLoc=WAT; isOutput=1>
      type (type_diagnostic_variable_id)   :: id_<name>
    </processes>

! Model parameters
    <constants>
      real(rk) :: <name>
    </constants>

! model time step may is stored here preliminarily
      real(rk) :: cgt_timestep

      contains

!     Model procedures
      procedure :: initialize
      procedure :: do
      procedure :: do_bottom
      procedure :: get_light_extinction
      procedure :: do_surface

  end type
!EOP
!-----------------------------------------------------------------------

   CONTAINS

!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: Initialise the ergom model
!
! !INTERFACE:
pure function theta(x)
!
! !DESCRIPTION:
!   The heavyside step function
!
   IMPLICIT NONE
!
! !INPUT PARAMETERS:
   real(rk), intent(in) :: x
   real(rk)             :: theta
!
!EOP
!-----------------------------------------------------------------------
!BOC
     if (x .gt. 0.0) then
       theta = 1.0
     else
       theta = 0.0
     end if
   END function theta
!EOC

!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: Initialise the ergom model
!
! !INTERFACE:
subroutine initialize(self,configunit)
!
! !DESCRIPTION:
!   Here, the ergom namelist is read and the variables exported by the model are registered with FABM
!
! !USES
!   List any modules used by this routine.
   IMPLICIT NONE
!
! !INPUT PARAMETERS:
   class (type_iow_ergom), intent(inout), target :: self
   integer,                intent(in)            :: configunit
!
! !LOCAL VARIABLES:
 <constants>
   real(rk)           :: <name>=<value> ! <description>
 </constants>
 <tracers vertLoc=WAT>
   real(rk)           :: <trimName>_initial ! <description>
 </tracers>
 <tracers vertLoc=SED>
   real(rk)           :: <trimName>_initial ! <description>
 </tracers>
   real(rk)           :: cgt_timestep=1.0  ! ecosystem model time step [d]
   real(rk), parameter:: secs_pr_day=86400.0_rk

   character(len=64)  :: dic_variable=''     ! Link variable to carbon model

   namelist /iow_ergom/ &
 <constants>
                        <name>, &
 </constants>
 <tracers vertLoc=WAT>
                        <trimName>_initial, &
 </tracers>
 <tracers vertLoc=SED>
                        <trimName>_initial, &
 </tracers>
                        cgt_timestep,  &
                        dic_variable

!EOP
!-----------------------------------------------------------------------
!BOC
   ! Read the namelist
   if (configunit>0) read(configunit,nml=iow_ergom,err=99,end=100)

!  Store parameter values in our own derived type
 <constants>
 call self%get_parameter(self%<name>,'<name>','<units>','<description>',default=<name>)
 </constants>

   call self%get_parameter(self%cgt_timestep,'cgt_timestep','d','background phytoplankton concentration ',default=cgt_timestep)


!  Register state variables
 <tracers vertLoc=WAT>
   call self%register_state_variable(self%id_<name>,'<trimName>','mol/kg', &
         '<description>', <trimName>_initial &
   <if isPositive=1>
         , minimum=0._rk &
   </if>
   <if vertSpeed/=0>
         , vertical_movement=<vertSpeed>/secs_pr_day &
   </if>
   <if riverDep=1>
         , no_river_dilution=.true. &
   </if>
         )
 </tracers>
 <tracers vertLoc=SED>
   call self%register_state_variable(self%id_<name>,'<trimName>','mol/m**2','<description>', &
         <initValue> &
   <if isPositive=1>
         , minimum=0._rk &
   </if>
         )
 </tracers>

   ! Register the contribution of all state variables to total nitrogen
   call self%add_to_aggregate_variable(standard_variables%total_nitrogen,self%id_t_spp)
   call self%add_to_aggregate_variable(standard_variables%total_nitrogen,self%id_t_lpp)
   call self%add_to_aggregate_variable(standard_variables%total_nitrogen,self%id_t_zoo)
   call self%add_to_aggregate_variable(standard_variables%total_nitrogen,self%id_t_det)
   call self%add_to_aggregate_variable(standard_variables%total_nitrogen,self%id_t_cya)

! Register diagnostic variables
!   call self%register_diagnostic_variable(self%id_dPAR,'PAR','W/m**2','photosynthetically active radiation',   &
!         time_treatment=time_treatment_averaged)
!   call self%register_diagnostic_variable(self%id_GPP,'GPP','mmol/m**3','gross primary production',            &
!         time_treatment=time_treatment_step_integrated)
!   call self%register_diagnostic_variable(self%id_NCP,'NCP','mmol/m**3','net community production',            &
!         time_treatment=time_treatment_step_integrated)
!   call self%register_diagnostic_variable(self%id_PPR,'PPR','mmol/m**3/d','gross primary production rate',     &
!         time_treatment=time_treatment_averaged)
!   call self%register_diagnostic_variable(self%id_NPR,'NPR','mmol/m**3/d','net community production rate',     &
!         time_treatment=time_treatment_averaged)
 <auxiliaries vertLoc=WAT; isOutput=1>
   call self%register_diagnostic_variable(self%id_<name>,'<trimName>','1.0','<description>',     &
         time_treatment=time_treatment_averaged)
 </auxiliaries>
 <processes vertLoc=WAT; isOutput=1>
   call self%register_diagnostic_variable(self%id_<name>,'<trimName>','mol/kg/d','<description>',     &
         time_treatment=time_treatment_averaged)
 </processes>

   ! Register link to external DIC pool, if DIC variable name is provided in namelist.
   call self%register_state_dependency(self%id_t_dic,'dic','mmol/m**3','total dissolved inorganic carbon',required=.false.)
   if (dic_variable/='') call self%request_coupling(self%id_t_dic,dic_variable)

! Register environmental dependencies
   call self%register_dependency(self%id_par,standard_variables%downwelling_photosynthetic_radiative_flux)
   call self%register_dependency(self%id_temp,standard_variables%temperature)
   call self%register_dependency(self%id_salt,standard_variables%practical_salinity)
   call self%register_dependency(self%id_I_0,standard_variables%surface_downwelling_photosynthetic_radiative_flux)
   call self%register_dependency(self%id_wind,standard_variables%wind_speed)
   call self%register_dependency(self%id_depth,standard_variables%bottom_depth)
   call self%register_dependency(self%id_taub,standard_variables%bottom_stress)
   call self%register_dependency(self%id_lat,standard_variables%latitude)
   call self%register_dependency(self%id_lon,standard_variables%longitude)

   return

 99 call self%fatal_error('iow_ergom_init','Error reading namelist iow_ergom.')

100 call self%fatal_error('iow_ergom_init','Namelist iow_ergom was not found.')

   END subroutine initialize
!EOC


!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: Right hand sides of ergom model
!
! !INTERFACE:
   subroutine do(self,_ARGUMENTS_DO_)
!!
! !USES:
   IMPLICIT NONE
!
! !INPUT PARAMETERS:
   class(type_iow_ergom), INTENT(IN) :: self
  _DECLARE_ARGUMENTS_DO_
!
!
! !LOCAL VARIABLES:
  <constants>
    real(rk)        :: <name>
  </constants>
  <tracers vertLoc=WAT>
    real(rk)        :: <name>
  </tracers>
  <auxiliaries vertLoc=WAT>
    real(rk)        :: <name>
  </auxiliaries>
  <tracers vertLoc=WAT>
   <limitations>
    real(rk)        :: <name>
   </limitations>
  </tracers>
  <processes vertLoc=WAT>
    real(rk)        :: <name>
  </processes>
    real(rk)        :: cgt_temp
    real(rk)        :: cgt_sali
    real(rk)        :: cgt_light
    real(rk)        :: cgt_density
    real(rk)        :: cgt_longitude
    real(rk)        :: cgt_latitude
    real(rk)        :: cgt_timestep
    real(rk)        :: secs_pr_day=86400.0_rk
    real(rk)        :: temp1, temp2, temp3, temp4, temp5, &
                       temp6, temp7, temp8, temp9

!EOP
!-----------------------------------------------------------------------
!BOC
!   Store values of constants in local variables
  <constants>
    <name> = self%<name>
  </constants>

!   Enter spatial_loops (if any)
    _LOOP_BEGIN_

!   Retrieve current (local) state variable values
  <tracers vertLoc=WAT>
    _GET_(self%id_<name>,<name>) !<description>
  </tracers>

!   Retrieve current environmental conditions
    _GET_   (self%id_par,cgt_light)    ! local photosynthetically active radiation
    _GET_   (self%id_temp,cgt_temp)    !local water temperature
    _GET_   (self%id_salt,cgt_sali)    !local water temperature
    _GET_   (self%id_lon,cgt_longitude)! Longitude [degE]
    _GET_   (self%id_lat,cgt_latitude) ! Latitude  [degN]
    cgt_density = 1035.0               ! Boussinesq density
    cgt_timestep  = self%cgt_timestep  ! ecosystem model time step [d]

!   Calculation of auxiliary variables
  <auxiliaries vertLoc=WAT; calcAfterProcesses=0>
    temp1 = <temp1>
    temp2 = <temp2>
    temp3 = <temp3>
    temp4 = <temp4>
    temp5 = <temp5>
    temp6 = <temp6>
    temp7 = <temp7>
    temp8 = <temp8>
    temp9 = <temp9>
    <name> = <formula>
  </auxiliaries>

!   Calculation of process limitation factors
  <tracers vertLoc=WAT>
    <limitations>
             <name> = <formula>
    </limitations>
  </tracers>

!   Calculation of process rates
  <processes vertLoc=WAT>
    <name> = <turnover>
  </processes>

!   Calculation of late auxiliary variables
  <auxiliaries vertLoc=WAT; calcAfterProcesses=1>
    temp1 = <temp1>
    temp2 = <temp2>
    temp3 = <temp3>
    temp4 = <temp4>
    temp5 = <temp5>
    temp6 = <temp6>
    temp7 = <temp7>
    temp8 = <temp8>
    temp9 = <temp9>
    <name> = <formula>
  </auxiliaries>

!  Applying time tendencies for tracers
<tracers vertLoc=WAT>
  _SET_ODE_(self%id_<name>,0.0 <noNewLine>
    <timeTendencies vertLoc=WAT>
      <timeTendency>/secs_pr_day <noNewLine>
    </timeTendencies>
  )
</tracers>

    if (_AVAILABLE_(self%id_t_dic)) _SET_ODE_(self%id_t_dic, rfr_c*(r_pp_mort * food_zoo + r_zoo_resp * zoo_eff + r_sed_rec * t_det - r_det_rec * spp_plus_spp0 - r_lpp_assim * lpp_plus_lpp0 - r_cya_assim * cya_plus_cya0)/secs_pr_day)

! Export diagnostic variables
!   _SET_DIAGNOSTIC_(self%id_dPAR,par)
!   _SET_DIAGNOSTIC_(self%id_GPP ,r1/(p1+self%p10)+r2/(p2+self%p20)+r3/(p2+self%p30))
!   _SET_DIAGNOSTIC_(self%id_NCP ,r1/(p1+self%p10)+r2/(p2+self%p20)+r3/(p2+self%p30) - self%lpa*(p1+p2+p3))
!   _SET_DIAGNOSTIC_(self%id_PPR ,(r1/(p1+self%p10)+r2/(p2+self%p20)+r3/(p2+self%p30))*secs_pr_day)
!   _SET_DIAGNOSTIC_(self%id_NPR ,(r1/(p1+self%p10)+r2/(p2+self%p20)+r3/(p2+self%p30) - self%lpa*(p1+p2+p3))*secs_pr_day)
<auxiliaries vertLoc=WAT; isOutput=1>
   _SET_DIAGNOSTIC_(self%id_<name> ,<name>)
</auxiliaries>
<processes vertLoc=WAT; isOutput=1>
   _SET_DIAGNOSTIC_(self%id_<name> ,<name>)
</processes>
!   Leave spatial loops (if any)
   _LOOP_END_

   END subroutine do
!EOC

!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: Get the light extinction coefficient due to biogeochemical
! variables
!
! !DESCRIPTION:

! !INTERFACE:
   subroutine get_light_extinction(self,_ARGUMENTS_GET_EXTINCTION_)
!
! !INPUT PARAMETERS:
   class (type_iow_ergom), intent(in) :: self
   _DECLARE_ARGUMENTS_GET_EXTINCTION_
!
! !REVISION HISTORY:
!  Original author(s): Jorn Bruggeman
!
! !LOCAL VARIABLES:
<constants>
   real(rk)                     :: <name>
</constants>
<tracers vertLoc=WAT; opacity/=0>
   real(rk)                     :: <name>
</tracers>

!EOP
!-----------------------------------------------------------------------
!BOC
   ! Store values of constants in local variables
<constants>
   <name> = self%<name>
</constants>

   ! Enter spatial loops (if any)
   _LOOP_BEGIN_

   ! Retrieve current (local) state variable values.

<tracers vertLoc=WAT; opacity/=0>
   _GET_(self%id_<name>,<name>) ! <description>
</tracers>

   ! Self-shading with explicit contribution from background phytoplankton concentration.
   _SET_EXTINCTION_(0.0 <noNewLine>
<tracers vertLoc=WAT; opacity/=0>
                    + <name> * <opacity> <noNewLine>
</tracers>
                   )

   ! Leave spatial loops (if any)
   _LOOP_END_

   end subroutine get_light_extinction
!EOC

!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE:
!
! !INTERFACE:
   subroutine do_bottom(self,_ARGUMENTS_DO_BOTTOM_)
!
! !DESCRIPTION:
! Calculating the benthic fluxes
!
   implicit none

! !INPUT PARAMETERS:
   class (type_iow_ergom), intent(in) :: self
   _DECLARE_ARGUMENTS_DO_BOTTOM_
!
! !REVISION HISTORY:
!  Original author(s):
!
! !LOCAL VARIABLES:
 <constants>
   real(rk)                   :: <name>
 </constants>
 <tracers vertLoc=WAT>
   real(rk)                   :: <name>
 </tracers>
 <tracers vertLoc=SED>
   real(rk)                   :: <name>
 </tracers>
 <auxiliaries vertLoc=WAT; calcBeforeProcesses=0>
   real(rk)                   :: <name>
 </auxiliaries>
 <auxiliaries vertLoc=SED; calcBeforeProcesses=0>
   real(rk)                   :: <name>
 </auxiliaries>
 <tracers vertLoc=WAT>
  <limitations>
    real(rk)        :: <name>
   </limitations>
 </tracers>
 <tracers vertLoc=SED>
  <limitations>
    real(rk)        :: <name>
   </limitations>
 </tracers>
 <processes vertLoc=SED>
   real(rk)                   :: <name>
 </processes>
   real(rk)                   :: cgt_temp
   real(rk)                   :: cgt_sali
   real(rk)                   :: cgt_light
   real(rk)                   :: cgt_density
   real(rk)                   :: cgt_longitude
   real(rk)                   :: cgt_latitude
   real(rk)                   :: cgt_current_wave_stress
   real(rk)                   :: cgt_bottomdepth
   real(rk)                   :: cgt_timestep
   real(rk)                   :: temp1, temp2, temp3, temp4, temp5, &
                                 temp6, temp7, temp8, temp9
   real(rk), parameter:: secs_pr_day=86400.0_rk


!EOP
!-----------------------------------------------------------------------
!BOC

   ! Store values of constants in local variables
   <constants>
      <name> = self%<name>
   </constants>

   ! Enter spatial loops over the horizontal domain (if any).
   _HORIZONTAL_LOOP_BEGIN_

   ! Retrieve abiotic parameters
      _GET_HORIZONTAL_(self%id_taub,cgt_current_wave_stress)
      _GET_HORIZONTAL_(self%id_depth,cgt_bottomdepth) !local water depth
      _GET_HORIZONTAL_(self%id_lon,cgt_longitude)     ! Longitude [degE]
      _GET_HORIZONTAL_(self%id_lat,cgt_latitude)      ! Latitude  [degN]
      _GET_   (self%id_par,cgt_light)    ! local photosynthetically active radiation
      _GET_   (self%id_temp,cgt_temp)    ! local water temperature
      _GET_   (self%id_salt,cgt_sali)    ! local water salinity
      cgt_density   = 1035.0_rk          ! Boussinesq density
      cgt_timestep  = self%cgt_timestep  ! ecosystem model time step [d]

   ! Retrieve current (local) state variable values.
   <tracers vertLoc=WAT>
      _GET_(self%id_<name>,<name>)
   </tracers>
   <tracers vertLoc=SED>
      _GET_HORIZONTAL_(self%id_<name>,<name>)
   </tracers>

   ! Calculate values of auxiliary variables
   <auxiliaries vertLoc=WAT; calcAfterProcesses=0>
       temp1 = <temp1>
       temp2 = <temp2>
       temp3 = <temp3>
       temp4 = <temp4>
       temp5 = <temp5>
       temp6 = <temp6>
       temp7 = <temp7>
       temp8 = <temp8>
       temp9 = <temp9>
       <name> = <formula>
   </auxiliaries>
   <auxiliaries vertLoc=SED; calcAfterProcesses=0>
       temp1 = <temp1>
       temp2 = <temp2>
       temp3 = <temp3>
       temp4 = <temp4>
       temp5 = <temp5>
       temp6 = <temp6>
       temp7 = <temp7>
       temp8 = <temp8>
       temp9 = <temp9>
       <name> = <formula>
   </auxiliaries>

   ! Calculate process limitation functions
   <tracers vertLoc=WAT>
     <limitations>
       <name> = <formula>
     </limitations>
   </tracers>
   <tracers vertLoc=SED>
     <limitations>
       <name> = <formula>
     </limitations>
   </tracers>

   ! Calculate process rates
   <processes vertLoc=SED>
       <name> = <turnover>
   </processes>

   ! Apply time tendencies to tracers
   <tracers vertLoc=SED>
      _SET_ODE_BEN_(self%id_<name>,0.0 <noNewLine>
      <timeTendencies>
                    <timeTendency>/secs_pr_day <noNewLine>
      </timeTendencies>
                   )
   </tracers>
   <tracers vertLoc=WAT; hasTimeTendenciesVertLoc=SED>
      _SET_BOTTOM_EXCHANGE_(self%id_<name>,0.0 <noNewLine>
      <timeTendencies vertLoc=SED>
                    <timeTendency2d>/(cgt_density*secs_pr_day) <noNewLine>
      </timeTendencies>
                           )
   </tracers>

    if (_AVAILABLE_(self%id_t_dic)) _SET_BOTTOM_EXCHANGE_(self%id_t_dic, rfr_c*lr_sed_rec/(cgt_density*secs_pr_day))


   ! Leave spatial loops over the horizontal domain (if any).
   _HORIZONTAL_LOOP_END_

   end subroutine do_bottom
!EOC

!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: Surface fluxes for the ergom model
!
! !INTERFACE:

   subroutine do_surface(self,_ARGUMENTS_DO_SURFACE_)
   class (type_iow_ergom),intent(in) :: self
   _DECLARE_ARGUMENTS_DO_SURFACE_
!
! !REVISION HISTORY:
!  Original author(s): Hans Burchard, Karsten Bolding
!
! !LOCAL VARIABLES:
! !LOCAL VARIABLES:
 <constants>
   real(rk)                   :: <name>
 </constants>
 <tracers vertLoc=WAT>
   real(rk)                   :: <name>
 </tracers>
 <auxiliaries vertLoc=WAT; calcBeforeProcesses=0>
   real(rk)                   :: <name>
 </auxiliaries>
 <auxiliaries vertLoc=SUR; calcBeforeProcesses=0>
   real(rk)                   :: <name>
 </auxiliaries>
 <tracers vertLoc=WAT>
  <limitations>
   real(rk)                   :: <name>
  </limitations>
 </tracers>
 <processes vertLoc=SUR>
   real(rk)                   :: <name>
 </processes>
   real(rk)                   :: cgt_temp
   real(rk)                   :: cgt_sali
   real(rk)                   :: cgt_light
   real(rk)                   :: cgt_density
   real(rk)                   :: cgt_longitude
   real(rk)                   :: cgt_latitude
   real(rk)                   :: cgt_current_wave_stress
   real(rk)                   :: cgt_timestep
   real(rk)                   :: temp1, temp2, temp3, temp4, temp5, &
                                 temp6, temp7, temp8, temp9
   real(rk), parameter:: secs_pr_day=86400.0_rk

!EOP
!-----------------------------------------------------------------------
!BOC
      ! Store values of constants in local variables
   <constants>
      <name> = self%<name>
   </constants>

   ! Enter spatial loops over the horizontal domain (if any).
   _HORIZONTAL_LOOP_BEGIN_

   ! Retrieve abiotic parameters
      _GET_HORIZONTAL_(self%id_taub,cgt_current_wave_stress)
      _GET_   (self%id_par,cgt_light) ! local photosynthetically active radiation
      _GET_   (self%id_temp,cgt_temp) !local water temperature
      _GET_   (self%id_salt,cgt_sali) !local water temperature
      _GET_HORIZONTAL_(self%id_lon,cgt_longitude)! Longitude [degE]
      _GET_HORIZONTAL_(self%id_lat,cgt_latitude) ! Latitude  [degN]
      cgt_density = 1035.0
      cgt_timestep  = self%cgt_timestep ! ecosystem model time step [d]


   ! Retrieve current (local) state variable values.
   <tracers vertLoc=WAT>
      _GET_(self%id_<name>,<name>)
   </tracers>

   ! Calculate values of auxiliary variables
   <auxiliaries vertLoc=WAT; calcAfterProcesses=0>
       temp1 = <temp1>
       temp2 = <temp2>
       temp3 = <temp3>
       temp4 = <temp4>
       temp5 = <temp5>
       temp6 = <temp6>
       temp7 = <temp7>
       temp8 = <temp8>
       temp9 = <temp9>
       <name> = <formula>
   </auxiliaries>

   <auxiliaries vertLoc=SUR; calcAfterProcesses=0>
       temp1 = <temp1>
       temp2 = <temp2>
       temp3 = <temp3>
       temp4 = <temp4>
       temp5 = <temp5>
       temp6 = <temp6>
       temp7 = <temp7>
       temp8 = <temp8>
       temp9 = <temp9>
       <name> = <formula>
   </auxiliaries>

   ! Calculate process limitation functions
   <tracers vertLoc=WAT>
     <limitations>
       <name> = <formula>
     </limitations>
   </tracers>

   ! Calculate process rates
   <processes vertLoc=SUR>
       <name> = <turnover>
   </processes>

   ! Apply time tendencies to tracers
   <tracers vertLoc=WAT; hasTimeTendenciesVertLoc=SUR>
      _SET_SURFACE_EXCHANGE_(self%id_<name>,0.0 <noNewLine>
      <timeTendencies vertLoc=SUR>
                    <timeTendency2d>/(cgt_density*secs_pr_day) <noNewLine>
      </timeTendencies>
                           )
   </tracers>

   ! Leave spatial loops over the horizontal domain (if any)
   _HORIZONTAL_LOOP_END_

   end subroutine do_surface
!EOC


!-----------------------------------------------------------------------

  END MODULE fabm_iow_ergom

!-----------------------------------------------------------------------
! Copyright by the GOTM-team under the GNU Public License - www.gnu.org
!-----------------------------------------------------------------------
