#!/bin/bash

module unload netcdf

module load cmake/3.16.2
module load intel/19.0.5 impi/2018.5 netcdf/intel/4.7.3

#exit 

rm -fv getm/src/cmake/Modules/FindMPI.cmake
rm -f *~

export GETMDIR=${WORK}/BalticSea1nm/GETM-GOTM-FABM/getm
export GOTMDIR=${WORK}/BalticSea1nm/GETM-GOTM-FABM/gotm
export FABMDIR=${WORK}/BalticSea1nm/GETM-GOTM-FABM/fabm
export MPI=MPICH

export GETM_PREFIX=${WORK}/BalticSea1nm/GETM-GOTM-FABM/build

rm -rf $GETM_PREFIX

mkdir -p $GETM_PREFIX && cd $GETM_PREFIX
cmake $GETMDIR/src -DCMAKE_INSTALL_PREFIX=$GETM_PREFIX -DGETM_EMBED_VERSION=ON \
   -DGETM_USE_FABM=ON -DGETM_USE_PARALLEL=ON -DGOTM_BASE=$GOTMDIR \
   -DFABM_BASE=$FABMDIR -DCMAKE_Fortran_COMPILER=mpiifort \
   -DCMAKE_Fortran_FLAGS='-O2 -Wl,-rpath=$LD_RUN_PATH' \
   -DGETM_FLAGS='-D_SLR_V26_ -D_NEW_DAF_' -DGETM_USE_STATIC=ON 

#   -DCMAKE_Fortran_FLAGS='-Ofast -align -pad -static-intel -init=zero -fp-model fast=1 -ipo -xCORE-AVX512 -qopt-zmm-usage=high -Wl,-rpath=$LD_RUN_PATH' \
   
#cmake $GETMDIR/src -DCMAKE_INSTALL_PREFIX=$GETM_PREFIX -DGETM_EMBED_VERSION=ON -DGETM_USE_FABM=ON -DGETM_USE_PARALLEL=ON -DGOTM_BASE=$GOTMDIR -DFABM_BASE=$FABMDIR -DCMAKE_Fortran_COMPILER=ftn -DCMAKE_Fortran_FLAGS='-O3 -static -unroll-aggressive -align array64byte -static-intel -fp-model fast -no-prec-div -no-prec-sqrt -ipo -pad -prof-use -prof-dir=/gfs2/work/mvkgrawe/BalticSea1nm/GETM-GOTM-FABM/profile' -DGETM_FLAGS='-D_SLR_V26_ -D_NEW_DAF_' -DGETM_USE_STATIC=ON 
#cmake $GETMDIR/src -DCMAKE_INSTALL_PREFIX=$GETM_PREFIX -DGETM_EMBED_VERSION=ON -DGETM_USE_FABM=ON -DGETM_USE_PARALLEL=ON -DGOTM_BASE=$GOTMDIR -DFABM_BASE=$FABMDIR -DCMAKE_Fortran_COMPILER=ftn -DCMAKE_Fortran_FLAGS='-Ofast -static -unroll-aggressive -align array64byte -static-intel -fp-model fast -no-prec-div -no-prec-sqrt -ipo -pad' -DGETM_FLAGS='-D_SLR_V26_ -D_NEW_DAF_' -DGETM_USE_STATIC=ON 

#cmake $GETMDIR/src -DCMAKE_INSTALL_PREFIX=$GETM_PREFIX -DGETM_EMBED_VERSION=ON -DGETM_USE_FABM=ON -DGETM_USE_PARALLEL=ON -DGOTM_BASE=$GOTMDIR -DFABM_BASE=$FABMDIR -DCMAKE_Fortran_COMPILER=ftn -DCMAKE_Fortran_FLAGS='-O3 -static-intel -unroll-aggressive -align array64byte -fno-alias -fp-model precise -prof-use -prof-dir=/gfs2/work/mvkgrawe/BalticSea1nm/GETM-GOTM-FABM/profile/' -DGETM_FLAGS='-DNEW_SLR -D_NEW_DAF_' -DGETM_USE_STATIC=ON 

cd $GETM_PREFIX
make -j 8 install

#'-Ofast -unroll-aggressive -fp-model fast=2 -align -fno-alias -fno-falias'
