# Copyright @ R. Badeke (2021)


from pandas import DataFrame
from sklearn import linear_model
import pandas as pd
import numpy as np


print("multilinear regression calculator for exponential modified Gaussian fit\n")

"INPUT"
# The user can enter parameters for wind speed, exhaust temperature, wind angle 
# (0 = frontal wind, 90 = lateral wind) and stability to calculate individual 
# shape parameters for the Gaussian distribution of vertical ship emissions

Input_Wind_Speed = 15     # m/s
Input_Temperature = 300   # exhaust temperature in deg C
Input_angle = 0           # flow angle towards the ship (0 = frontal, 90 = lateral)
Input_Stability = -0.65   # K/100m

# path of the regression_data_expgauss.csv
df = pd.read_csv(".../regression_data_expgauss.csv", sep=";")

"end of user input"

sp = ['l1', 'l2', 'l3']

i = 0


Case = df["#"].to_list()
vwind = df["Wind speed"].to_list()
cos_angle = df["cos_Angle"].to_list()
temperature = df["Temperature"].to_list()
stability = df["dT/dz"].to_list()
l1 = df["l1_fit"].to_list()
l2 =df["l2_fit"].to_list()
l3 =df["l3_fit"].to_list()
    
while i < 3:
    if sp[i] == 'l2':
        vwind = np.log10(vwind)

    
    Model_Data = {'Case': Case,
                    'Wind Speed': vwind,
                    'Angle': cos_angle,
                    'Temperature': temperature,
                    'Stability' : stability,
                    'l1': l1,
                    'l2': l2,
                    'l3': l3
                    }
    
    df = DataFrame(Model_Data,columns=['Case','Wind Speed', 'Angle', 'Temperature', 'Stability', 'l1', 'l2', 'l3']) 
    
    if sp[i] == 'l1':
        X = df[['Wind Speed', 
                'Stability']]
        Y = df['l1']
    
    elif sp[i] == 'l2':
        X = df[['Wind Speed', 
                'Angle', 
                'Temperature', 
                'Stability']]
        Y = df['l2']
    
    elif sp[i] == 'l3':
        X = df[['Angle', 
                'Temperature', 
                'Stability']]
        Y = df['l3']
    
    regr = linear_model.LinearRegression()
    regr.fit(X, Y)
    
    # these coefficients are used in Eq. (6)-(8)
    print('Intersect '+sp[i]+': \n', regr.intercept_)
    print('Coefficients '+sp[i]+': \n', regr.coef_)
    
    
    if sp[i] == 'l2':
        Input_Wind_Speed = np.log10(Input_Wind_Speed)
    Input_angle = np.cos(np.deg2rad(Input_angle))
    
    
    if sp[i] == 'l1':
        l1_out = regr.predict([[Input_Wind_Speed, Input_Stability]])

    
    if sp[i] == 'l2':
        l2_out = regr.predict([[Input_Wind_Speed, Input_angle, Input_Temperature, Input_Stability]])
    
    if sp[i] == 'l3':
        l3_out = regr.predict([[Input_angle, Input_Temperature, Input_Stability]])
    i += 1

# these values can be used in Eq. (4) to calculate individual Expgauss profiles based on the user input
print ('\nPredicted l1, l2 and l3 for user input values: \n', l1_out, l2_out, l3_out)