# Copyright @ R. Badeke (2021)


from pandas import DataFrame
from sklearn import linear_model
import pandas as pd
import numpy as np

print("multilinear regression calculator for upper plume boundary height Hup\n")

"INPUT"
# The user can enter parameters for wind speed, exhaust temperature and 
# stability to calculate individual upper plume boundary heights used in the
# for the Expgauss distribution of vertical ship emissions. The selected
# input values must be the same as for the program 
# multilinear_Regression_expgauss.py

Input_Wind_Speed = 5    # m/s
Input_Temperature = 300 # exhaust temperature in deg C
Input_Stability = -1.2  # K/100m

# path of the regression_data_expgauss.csv
df = pd.read_csv(".../regression_data_Hup.csv", sep=";")

"end of user input"

vwind = df["Wind speed"].to_list()
vwind = np.log10(vwind)
stability = df["dT/dz"].to_list()
stability = [(x * x) if x >= 0 else -(x * x) for x in stability]
temperature = df["Temperature"].to_list()
Hup = df["Hup_fit"].to_list()

Model_Data = {'Wind Speed': vwind,
                'Stability' : stability,
                'Temperature' : temperature,
                'Hup' : Hup
                }

df = DataFrame(Model_Data,columns=['Wind Speed', 'Temperature','Stability', 'Hup']) 

X = df[['Wind Speed','Temperature', 'Stability']]
Y = df['Hup']

regr_Hup = linear_model.LinearRegression()
regr_Hup.fit(X, Y)

# these coefficients are used in Eq. (9)
print('Intersect: \n', regr_Hup.intercept_)
print('Coefficients: \n', regr_Hup.coef_)


Input_Wind_Speed = np.log10(Input_Wind_Speed)
if Input_Stability < 0:
    Input_Stability = -(Input_Stability * Input_Stability)
else:
    Input_Stability = Input_Stability * Input_Stability


# these values can be used in Eq. (4) to calculate individual Expgauss profiles based on the user input
print ('\nPredicted Hup based on user input: \n', regr_Hup.predict([[Input_Wind_Speed, Input_Temperature, Input_Stability]]))

