program ssmis_operator
  use common_miroc,only: nlon,nlat,nlev,calc_pfull
  use solar,only: zensun
  implicit none
  integer :: i,j,nbv,slot,ios,satellite_id,f_n,nobs,mem,rec
  integer,parameter :: single=kind(0.),double=kind(0.d0),maxvbc=6,obs_limit=3000
  real(single),parameter :: gross_error=20.,obs_error(6)=(/2.4,2.4,1.8,1.,.6,.7/),meanT=273.15
  real(double),parameter :: r60=1./60.d0,q2ppmv=1.60771704d6,pi=acos(-1.d0),deg2rad=pi/180.d0
  real(double),allocatable,dimension(:,:,:) :: tran,input
  real(double),allocatable,dimension(:,:) :: p_full,bt,itp_p,itp_t,itp_q
  real(double),allocatable,dimension(:) :: itp_t2m,itp_q2m,itp_p2m,itp_u2m,itp_v2m,soze,soaz,itp_elev,ri,rj
  real(single),allocatable,dimension(:,:) :: t_b,obslev,ur4,t_b_tmp
  real(single),allocatable,dimension(:) :: land,saze,saaz,obslat,obslon,foot
  real(double) :: sun_zenith
  real(single) :: id,year,month,day,hh,mm,ss,flag,predictor(maxvbc),beta(maxvbc,19:24,0:1,17:18),lapse(2:nlev-1),qc(19:24)
  character(11) :: guesfile='anal_me.grd'!save will cause a problem in parallel
  character(11) :: diagfile='diag_me.grd'
  character(16) :: head(64),outfile='SS1701000001.dat'!save will cause a problem in parallel
  character(100) :: obsfile
  integer,parameter :: days(1:12,2016:2018)=reshape((/0,31,60,91,121,152,182,213,244,274,305,335,&
                                                     &0,31,59,90,120,151,181,212,243,273,304,334,&
                                                     &0,31,59,90,120,151,181,212,243,273,304,334/),(/12,3/))
  namelist/obs_parameter/nbv,slot,obsfile
  read(5,nml=obs_parameter,iostat=ios)
  print*,'H(x) start',ios,obsfile
  write(outfile(5:6),'(i2.2)') slot

  open(100,file='varbc_coefficients.dat',status='old',action='read',iostat=ios)
  if(0==ios) then
    do f_n=17,18
      do j=0,1
        do i=19,24
          read(100,*,iostat=ios) beta(:,i,j,f_n),id
          if(0/=ios) exit
        end do
      end do
    end do
    close(100)
  end if
  if(0/=ios) beta=0

  allocate(input(nlon,nlat,nlev),ur4(nlon,nlat))
  allocate(t_b(19:24,obs_limit))
  allocate(land,foot,source=t_b(19,:))
  allocate(soze(obs_limit),soaz(obs_limit))
  allocate(obslat(obs_limit),obslon(obs_limit))
  open(201,file='varbc_predictors.dat',status='replace',form='unformatted',access='direct',recl=4*maxvbc,iostat=ios)
  rec=1
  do f_n=17,18
    if(17==f_n) then
      satellite_id=285
    else if(18==f_n) then
      satellite_id=286
    else
      stop 'unknown satellite'
    end if
    write(outfile(3:4),'(i2.2)') f_n

    !variables from observations
    open(100,file=trim(obsfile),action='read',status='old',form='unformatted',access='direct',recl=4*17)
    nobs=1
    do i=1,obs_limit
      read(100,rec=i,iostat=ios) id,year,month,day,hh,mm,ss,obslat(nobs),obslon(nobs),foot(nobs),flag,t_b(:,nobs)
      if(ios/=0) exit
      if(satellite_id/=nint(id).or.obslat(nobs)>87.8638.or.obslat(nobs)<-87.8638) cycle

      if(5==INT(flag)) then
        land(nobs)=1.!sea
!      else if(3==INT(flag)) then
!        land(nobs)=2.!seaice
      else if(0==INT(flag)) then
        land(nobs)=0.!land
      else
        cycle
      end if
        
      call zensun(days(nint(month),nint(year))+nint(day),hh+(mm+ss*r60)*r60,real(obslat(nobs),double),real(obslon(nobs),double),sun_zenith,soaz(nobs))
      soze(nobs)=90-sun_zenith
      if(obslon(nobs)<0) obslon(nobs)=obslon(nobs)+360.

      nobs=nobs+1
      if(nobs>obs_limit) stop 'nobs overflow'
    end do
    if(nobs==obs_limit) stop 'nobs overflow'
    close(100)
    nobs=nobs-1
    print*,'nobs:',nobs
    !no obs process
    if(0==nobs.or.f_n==18) then
      do i=1,nbv
        write(outfile(10:12),'(i3.3)') i
        if(1==nbv) outfile(9:12)='mean'
        open(200,file=outfile,form='unformatted',status='replace')
        close(200)
      end do
      cycle
    end if
    
    allocate(ri(nobs))
    allocate(rj,itp_elev,source=ri)
    allocate(saze(nobs),saaz(nobs))
    !grid position
    do i=1,nobs
      call lonlat2ij(obslon(i),obslat(i),ri(i),rj(i))
    end do

    !height
    open(100,file='/home/G10204/koshin/JAGUAR16l124/data/t42/grz',action='read',form='unformatted',access='sequential',convert='big_endian',iostat=ios)
    read(100) head
    read(100) ur4
    do j=1,nobs
      call itpl_2d(ur4,ri(j),rj(j),itp_elev(j))
    end do
    close(100)
    itp_elev=itp_elev*0.001 !km->m

    saze=53.9!radarIncidenceAngle or RAIA varies from 53.7 to 54.1
    saaz=0.!bearingOrAzimuth or BEARAZ is always 0

    !variables from model
    allocate(itp_p(nlev,nobs))
    allocate(itp_t,itp_q,source=itp_p)
    allocate(itp_p2m,itp_t2m,itp_q2m,itp_u2m,itp_v2m,source=itp_p(1,:))
    allocate(p_full,source=transpose(itp_p))
    allocate(tran(nlev,19:24,nobs))
    allocate(t_b_tmp(19:24,nobs),bt(19:24,nobs),obslev(19:24,nobs))
!!!$omp parallel do
    do mem=1,nbv
      write(outfile(9:12),'(i4.4)') mem
      if(1==nbv) outfile(9:12)='mean'
      if(nbv>1) write(guesfile,'("gs",i2.2,i3.3,".grd")') slot,mem
      open(100,file=guesfile,action='read',form='unformatted',access='sequential',convert='big_endian',iostat=ios)
      do i=1,3!GAU,GAV,GAT
        read(100) head
        read(100) input
      end do
      read(100) head !GAPS
      read(100) input(:,:,1)
      do i=1,2!GAQ,GAQL
        read(100) head
        read(100) input
      end do
      
      do i=1,3!GBU,GBV,GBT
        read(100) head
        read(100) input
      end do
      do j=1,nobs
        call itpl_3d(input,ri(j),rj(j),itp_t(nlev:1:-1,j))
      end do
      !GBPS
      read(100) head
      read(100) input(:,:,1)
      do j=1,nobs
        call itpl_2d(real(input(:,:,1),single),ri(j),rj(j),itp_p2m(j))
      end do
      call calc_pfull(1,nobs,itp_p2m*100,p_full)!full level pressure [Pa]
      itp_p=transpose(p_full(:,nlev:1:-1))*.01!Pa->hPa
      !GBQ
      read(100) head
      read(100) input
      do j=1,nobs
        call itpl_3d(input,ri(j),rj(j),itp_q(nlev:1:-1,j))
      end do
      itp_q=itp_q*q2ppmv
      close(100)

      if(nbv>1) diagfile='dg'//guesfile(3:)
      open(100,file=diagfile,action='read',form='unformatted',access='sequential',convert='big_endian',iostat=ios)
      read(100) head !T2m
      read(100) ur4
      do j=1,nobs
        call itpl_2d(ur4,ri(j),rj(j),itp_t2m(j))
      end do
      read(100) head !Q2m
      read(100) ur4
      do j=1,nobs
        call itpl_2d(ur4,ri(j),rj(j),itp_q2m(j))
      end do
      read(100) head !U2m
      read(100) ur4
      do j=1,nobs
        call itpl_2d(ur4,ri(j),rj(j),itp_u2m(j))
      end do
      read(100) head !V2m
      read(100) ur4
      do j=1,nobs
        call itpl_2d(ur4,ri(j),rj(j),itp_v2m(j))
      end do
      close(100)
      
      !RTM forward
      call SSMIS_fwd(nlev,nobs,'/home/G10204/koshin/rttov11/rtcoef_rttov11/rttov7pred54L/rtcoef_dmsp_'//outfile(3:4)//'_ssmis.dat',&
           & itp_p,itp_t,itp_q,itp_t2m,itp_q2m,itp_p2m,itp_u2m,itp_v2m,soze(:nobs),soaz(:nobs),real(saze,double),real(saaz,double),&
           & itp_elev,real(obslon(:nobs),double),real(obslat(:nobs),double),real(land(:nobs),double),bt,tran)
      
      !weighting function
      call weightmax(tran,itp_p,obslev,nobs)
      !DEBUG: this paragraph will be removed in the future
      if(index(obsfile,'500/')>0) then
        open(200,file=outfile(:6)//'b'//outfile(8:),form='unformatted',access='sequential',convert='big_endian',status='replace')
        do j=1,nobs
          qc=1.
          write(200) 1011.,land(j),obslon(j),obslat(j),saze(j),real(itp_t2m(j),single),1.e-9,&
             & foot(j),obslev(19:24,j),t_b(:,j),obs_error,real(bt(19:24,j),single),qc
        end do
        close(200)
      end if

      !air mass bias
      do j=1,nobs
        predictor(5)=itp_t2m(j)-meanT
        predictor(6)=1.
        !lapse rate
        lapse=itp_t(1:nlev-2,j)-itp_t(3:nlev,j)
        do i=19,24
          predictor(1)=sum(lapse*(tran(1:nlev-2,i,j)-tran(3:nlev,i,j)),mask=(itp_p(2:nlev-1,j)<1000.and.itp_p(2:nlev-1,j)>200))
          predictor(2)=sum(lapse*(tran(1:nlev-2,i,j)-tran(3:nlev,i,j)),mask=(itp_p(2:nlev-1,j)<200.and.itp_p(2:nlev-1,j)>50))
          predictor(3)=sum(lapse*(tran(1:nlev-2,i,j)-tran(3:nlev,i,j)),mask=(itp_p(2:nlev-1,j)<50.and.itp_p(2:nlev-1,j)>5))
          predictor(4)=sum(lapse*(tran(1:nlev-2,i,j)-tran(3:nlev,i,j)),mask=(itp_p(2:nlev-1,j)<10.and.itp_p(2:nlev-1,j)>1))
          t_b_tmp(i,j)=t_b(i,j)-sum(predictor*beta(:,i,nint(land(j)),f_n))
          write(201,rec=rec) predictor
          rec=rec+1
        end do
      end do
      
      open(200,file=outfile,form='unformatted',access='sequential',convert='big_endian',status='replace')
      do j=1,nobs!1+8+5*6+1=40:160byte/record
        qc=1.
        where(abs(t_b(:,j)-bt(:,j))>obs_error*gross_error) qc=0.
        write(200) 1011.,land(j),obslon(j),obslat(j),saze(j),real(itp_t2m(j),single),1.e-9,&
             & foot(j),obslev(19:24,j),t_b_tmp(:,j),obs_error,real(bt(19:24,j),single),qc
      end do
      close(200)
    end do
!!!$ omp end parallel do 

    deallocate(itp_p,itp_t,itp_q,itp_p2m,itp_t2m,itp_q2m,itp_u2m,itp_v2m,p_full,bt,tran,obslev)
    deallocate(ri,rj,itp_elev,saze,saaz)
  end do
  close(201)
  deallocate(input,soze,soaz,obslat,obslon,land,foot,t_b)
contains
  subroutine weightmax(transmit,p_profile,lev,nobs)
    implicit none
    integer :: i,j,k
    integer,intent(in) :: nobs
    real(8),intent(in) :: transmit(nlev,19:24,nobs),p_profile(:,:)
    real(4),intent(out) :: lev(19:24,nobs)
    do j=1,nobs
      do i=19,24
        k=sum(maxloc( transmit(1:nlev-1,i,j)-transmit(2:nlev,i,j) ))
        lev(i,j)=sqrt(p_profile(k,j)*p_profile(k+1,j))
    end do;end do
  end subroutine weightmax
 SUBROUTINE itpl_2d(var,ri,rj,var5)
    IMPLICIT NONE
    integer,parameter :: r_size=8
    REAL(r_size/2),INTENT(IN) :: var(nlon,nlat)
    REAL(r_size),INTENT(IN) :: ri
    REAL(r_size),INTENT(IN) :: rj
    REAL(r_size),INTENT(OUT) :: var5
    REAL(r_size) :: ai,aj
    INTEGER :: i,j

    i = CEILING(ri)
    ai = ri - REAL(i-1,r_size)
    j = CEILING(rj)
    aj = rj - REAL(j-1,r_size)

    IF(i <= nlon) THEN
      var5 =   var(i-1,j-1) * (1-ai) * (1-aj) &
           & + var(i  ,j-1) *    ai  * (1-aj) &
           & + var(i-1,j  ) * (1-ai) *    aj  &
           & + var(i  ,j  ) *    ai  *    aj
    ELSE
      var5 =   var(i-1,j-1) * (1-ai) * (1-aj) &
           & + var(1  ,j-1) *    ai  * (1-aj) &
           & + var(i-1,j  ) * (1-ai) *    aj  &
           & + var(1  ,j  ) *    ai  *    aj
    END IF

    RETURN
  END SUBROUTINE itpl_2d
  subroutine itpl_3d(var,ri,rj,var5)
    implicit none
    integer,parameter :: r_size=8
    REAL(r_size),INTENT(IN) :: var(nlon,nlat,nlev)
    REAL(r_size),INTENT(IN) :: ri
    REAL(r_size),INTENT(IN) :: rj
    REAL(r_size),INTENT(OUT) :: var5(nlev)
    REAL(r_size) :: ai,aj
    INTEGER :: i,j

    i = CEILING(ri)
    ai = ri - REAL(i-1,r_size)
    j = CEILING(rj)
    aj = rj - REAL(j-1,r_size)

    IF(i <= nlon) THEN
      var5 =   var(i-1,j-1,:) * (1-ai) * (1-aj) &
           & + var(i  ,j-1,:) *    ai  * (1-aj) &
           & + var(i-1,j  ,:) * (1-ai) *    aj  &
           & + var(i  ,j  ,:) *    ai  *    aj
    ELSE
      var5 =   var(i-1,j-1,:) * (1-ai) * (1-aj) &
           & + var(1  ,j-1,:) *    ai  * (1-aj) &
           & + var(i-1,j  ,:) * (1-ai) *    aj  &
           & + var(1  ,j  ,:) *    ai  *    aj
    END IF

    RETURN
  end subroutine itpl_3d
  subroutine lonlat2ij(rlon,rlat,ri,rj)
    use common_miroc,only: nlon,nlat
    implicit none
    integer,parameter :: r_size=8
    real(4),intent(in) :: rlon,rlat
    real(r_size),intent(out) :: ri,rj
    real(r_size) :: aj
    integer :: j
    real(r_size),parameter :: lat(64)=(/&
       &-87.8638  ,-85.096527,-82.312912,-79.525604,-76.7369  ,&
       &-73.947517,-71.157753, -68.36776,-65.577606,-62.787354,&
       &-59.997021,-57.206631,-54.416199,-51.625732,-48.835239,&
       &-46.044727,-43.254196, -40.46365,-37.673088,-34.882523,&
       &-32.091946,-29.301359,-26.510769,-23.720175,-20.929575,&
       &-18.138971,-15.348365,-12.557756,-9.7671452,-6.9765334,&
       &-4.1859207,-1.3953069, 1.3953069, 4.1859207, 6.9765334,&
       & 9.7671452, 12.557756, 15.348365, 18.138971, 20.929575,&
       & 23.720175, 26.510769, 29.301359, 32.091946, 34.882523,&
       & 37.673088,  40.46365, 43.254196, 46.044727, 48.835239,&

       & 51.625732, 54.416199, 57.206631, 59.997021, 62.787354,&
       & 65.577606,  68.36776, 71.157753, 73.947517,   76.7369,&
       & 79.525604, 82.312912, 85.096527, 87.8638/)

    !
    ! rlon -> ri
    !
    IF(rlon == 0.0 .OR. rlon == 360.0) THEN
      ri = REAL(nlon+1,r_size)
    ELSE
      ri = rlon / 360.0d0 * REAL(nlon,r_size) + 1.0d0
    END IF
    IF(CEILING(ri) < 2 .OR. nlon+1 < CEILING(ri)) RETURN

    !
    ! rlat -> rj
    !
    DO j=1,nlat
      IF(rlat < lat(j)) EXIT
    END DO
    IF(j == 1) THEN
      rj = (rlat + 90.0d0) / (lat(1) + 90.0d0)
    ELSE IF(j == nlat+1) THEN
      aj = (rlat - lat(nlat)) / (90.0d0 - lat(nlat))
      rj = REAL(nlat,r_size) + aj
    ELSE
      aj = (rlat - lat(j-1)) / (lat(j) - lat(j-1))
      rj = REAL(j-1,r_size) + aj
    END IF
    rj=nlat+1.-rj !SN to NS  
    IF(CEILING(rj) < 2 .OR. nlat < CEILING(rj)) RETURN
  end subroutine lonlat2ij
end program
