program myvbc
  use common_tvs_miroc,only: maxtvsprof,maxvbc,maxtvsch,ntvsprof,ntvschan,ninstrument,tvsname,tvsinst,tvsch,ntvsch,nfootp,set_instrument,get_ntvs_mpi,read_tvs_mpi
!                                 undef,     6,       6,   undef,     out,          2   undef,  undef,undef, undef, undef,subroutine
  use mod_vbc,only: das_vbc
  implicit none
  integer,parameter :: r_size=kind(0.0d0)
  REAL(r_size),ALLOCATABLE,SAVE :: tvselm     (:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvslon     (:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvslat     (:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvslev     (:,:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvszenith  (:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvsskin    (:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvsstmp    (:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvsclw     (:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvsdat     (:,:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvserr     (:,:,:)
  REAL(r_size),ALLOCATABLE,SAVE :: tvshdxf    (:,:,:)
  INTEGER,ALLOCATABLE,SAVE :: tvsqc(:,:,:)
  INTEGER,ALLOCATABLE,SAVE :: tvsfoot(:,:)

  real,allocatable :: pred(:,:,:)
  real(4) :: vbcf(maxvbc,maxtvsch,0:1,ninstrument),vbca(maxvbc,maxtvsch),b_err(maxtvsch)
  integer :: i,j,k,ios,rec=1
  character(16) :: cfile="inst0400mean.dat"
  call set_instrument
  call get_ntvs_mpi(cfile) !get ntvsprof
  maxtvsprof=maxval(ntvsprof)
  allocate(tvshdxf(maxtvsch,maxtvsprof,ninstrument))
  allocate(tvselm,tvslon,tvslat,tvszenith,tvsskin,tvsstmp,tvsclw,source=tvshdxf(1,:,:))
  allocate(tvsdat,tvserr,tvslev,source=tvshdxf)
  allocate(tvsqc(maxtvsch,maxtvsprof,ninstrument))
  allocate(tvsfoot(maxtvsprof,ninstrument))
  allocate(pred(maxvbc,maxtvsch,maxtvsprof))

  open(10,file='varbc_coefficients.dat',status='old',action='read',iostat=ios)
  if(0/=ios) then
    vbcf=0
  else
    do i=1,ninstrument
      do k=0,1
        do j=1,ntvsch(ninstrument)
          read(10,'(7f)',iostat=ios) vbcf(:,j,k,i),b_err(1)
        end do
      end do
    end do
    close(10)
  end if
  if(0/=ios) vbcf=0

  call read_tvs_mpi(cfile,tvselm,tvslon,tvslat,tvszenith,tvsskin,tvsstmp,tvsclw,tvslev,tvsdat,tvserr,tvshdxf,tvsqc,tvsfoot)
  open(20,file='varbc_coefficients.dat',status='replace',iostat=ios)
  open(11,file='varbc_predictors.dat',action='read',iostat=ios,form='unformatted',access='direct',recl=4*maxvbc)
  do i=1,ninstrument!each instruments
    do j=1,ntvsprof(i)
      do k=1,ntvsch(i)
        read(11,rec=rec) pred(:,k,j)
        rec=rec+1
      end do
    end do
    
    do k=0,1
      print *,'land parameter:',k
      call das_vbc(maxtvsprof,maxvbc,maxtvsch,tvsname(i),tvsch(:,i),ntvsch(i),transpose(real(tvsdat(:,:,i))),transpose(real(tvshdxf(:,:,i))),pred(:,:ntvsch(i),:ntvsprof(i)),vbcf(:,:,k,i),vbca,abs(transfer( transpose(tvsqc(:,:,i)==1).and.spread(tvsskin(:,i)==k,dim=2,ncopies=maxtvsch),transpose(tvsqc(:,:,i)) )),transpose(real(tvserr(:,:,i))),ntvschan(:,i),b_err(:ntvsch(i)))
      do j=1,ntvsch(i)
        write(20,'(7f)') vbca(:,j),sqrt(1/b_err(j))
      end do
    end do
  end do
  close(11)
  close(20)
  deallocate(tvselm,tvslon,tvslat,tvszenith,tvsskin,tvsstmp,tvsclw,tvslev,tvsdat,tvserr,tvshdxf,tvsqc,tvsfoot,pred)
end program myvbc
