MODULE common_miroc
!=======================================================================
!
! [PURPOSE:] Common Information for SPEEDY
!
! [HISTORY:]
!   10/15/2004 Takemasa Miyoshi  created
!   01/23/2009 Takemasa Miyoshi  modified
!
!=======================================================================
!$USE OMP_LIB
  USE common
  IMPLICIT NONE
  PUBLIC
!-----------------------------------------------------------------------
! General parameters
!-----------------------------------------------------------------------
  INTEGER,PARAMETER :: nlon=128
  INTEGER,PARAMETER :: nlat=64
  INTEGER,PARAMETER :: nlev=124
  INTEGER,PARAMETER :: nv3d=5 ! u,v,t,q,cw
  INTEGER,PARAMETER :: nv2d=5 ! ps,t2m,q2m,u10m,v10m
  INTEGER,PARAMETER :: iv3d_u=1
  INTEGER,PARAMETER :: iv3d_v=2
  INTEGER,PARAMETER :: iv3d_t=3
  INTEGER,PARAMETER :: iv3d_q=4
  INTEGER,PARAMETER :: iv3d_cw=5
  INTEGER,PARAMETER :: iv2d_ps=1
  integer,parameter :: iv2d_t2m=2
  integer,parameter :: iv2d_q2m=3
  integer,parameter :: iv2d_u10m=4
  integer,parameter :: iv2d_v10m=5
  INTEGER,PARAMETER :: nij0=nlon*nlat
  INTEGER,PARAMETER :: nlevall=nlev*nv3d+nv2d
  INTEGER,PARAMETER :: ngpv=nij0*nlevall
  REAL(r_size),SAVE :: lon(nlon)
  REAL(r_size),SAVE :: lat(nlat)
  REAL(r_size),SAVE :: sig(nlev)
  REAL(r_size),SAVE :: dx(nlat)
  REAL(r_size),SAVE :: dy(nlat)
  REAL(r_size),SAVE :: dy2(nlat)
  REAL(r_size),SAVE :: fcori(nlat)
  REAL(r_size),SAVE :: phi0(nlon,nlat)
  CHARACTER(4),SAVE :: element(nv3d+nv2d)

CONTAINS
!-----------------------------------------------------------------------
! Set the parameters
!-----------------------------------------------------------------------
SUBROUTINE set_common_miroc
  IMPLICIT NONE
  INTEGER :: i,j


!miyazaki
      integer :: itime,idate(6)
      character :: hunit*16
      real :: alt(nlon,nlat)

  PRINT *,'Hello from set_common_miroc'
  !
  ! Elements
  !
 ! Elements
  !
  element(iv3d_u) = 'U   '
  element(iv3d_v) = 'V   '
  element(iv3d_t) = 'T   '
  element(iv3d_q) = 'Q   '
  element(iv3d_cw)= 'CW  '
  element(nv3d+iv2d_ps) = 'PS  '
  element(nv3d+iv2d_t2m) = 'T2m '
  element(nv3d+iv2d_q2m) = 'Q2m '
  element(nv3d+iv2d_u10m) = 'U10m'
  element(nv3d+iv2d_v10m) = 'V10m'
  !
  ! Lon, Lat, Sigma
  !
!!!!$OMP PARALLEL DO PRIVATE(i)
  lon(1) = 0.0d0
  DO i=2,nlon
    lon(i) = lon(i-1) + 2.8125d0
  END DO
!!!!$OMP END PARALLEL DO

 lat(1)=-87.864
 lat(2)=-85.097
 lat(3)=-82.313
 lat(4)=-79.526
 lat(5)=-76.737 
 lat(6)=-73.948
 lat(7)=-71.158
 lat(8)=-68.368
 lat(9)=-65.578
 lat(10)=-62.787 
 lat(11)=-59.997
 lat(12)=-57.207
 lat(13)=-54.416
 lat(14)=-51.626
 lat(15)=-48.835 
 lat(16)=-46.045
 lat(17)=-43.254
 lat(18)=-40.464
 lat(19)=-37.673
 lat(20)=-34.883 
 lat(21)=-32.092
 lat(22)=-29.301
 lat(23)=-26.511
 lat(24)=-23.720
 lat(25)=-20.930 
 lat(26)=-18.139
 lat(27)=-15.348
 lat(28)=-12.558
 lat(29)=-9.767
 lat(30)=-6.977 
 lat(31)=-4.186
 lat(32)=-1.395
 lat(33)=1.395
 lat(34)=4.186
 lat(35)=6.977
 lat(36)=9.767
 lat(37)=12.558
 lat(38)=15.348
 lat(39)=18.139
 lat(40)=20.930
 lat(41)=23.720
 lat(42)=26.511
 lat(43)=29.301
 lat(44)=32.092
 lat(45)=34.883 
 lat(46)=37.673
 lat(47)=40.464
 lat(48)=43.254
 lat(49)=46.045
 lat(50)=48.835
 lat(51)=51.626
 lat(52)=54.416
 lat(53)=57.207
 lat(54)=59.997
 lat(55)=62.787 
 lat(56)=65.578
 lat(57)=68.368
 lat(58)=71.158
 lat(59)=73.948
 lat(60)=76.737 
 lat(61)=79.526
 lat(62)=82.313
 lat(63)=85.097
 lat(64)=87.864 

  !
  ! dx and dy
  !
!$OMP PARALLEL
!$OMP WORKSHARE
  dx(:) = 2.0d0 * pi * re * cos(lat(:) * pi / 180.0d0) / REAL(nlon,r_size)
!$OMP END WORKSHARE

!$OMP DO
  DO i=1,nlat-1
    dy(i) = 2.0d0 * pi * re * (lat(i+1) - lat(i)) / 360.0d0
  END DO
!$OMP END DO
!$OMP END PARALLEL
  dy(nlat) = 2.0d0 * pi * re * (90.0d0 - lat(nlat)) / 180.0d0

!$OMP PARALLEL DO
  DO i=2,nlat
    dy2(i) = (dy(i-1) + dy(i)) * 0.5d0
  END DO
!$OMP END PARALLEL DO
  dy2(1) = (dy(nlat) + dy(1)) * 0.5d0
  !
  ! Corioris parameter
  !
!$OMP PARALLEL WORKSHARE
  fcori(:) = 2.0d0 * r_omega * sin(lat(:)*pi/180.0d0)
!$OMP END PARALLEL WORKSHARE
  !
  ! Surface geoptential (Read Orography file)
  !
!  READ(21) phi0 !miyazaki
      open(97,file='alt', &
     &     form='unformatted',status='old') 
      call gt3read(97,alt,nlon,nlat,1,idate,itime,hunit)
      phi0(:,:)=alt(:,:) !miyazaki
      close(97)

  RETURN
END SUBROUTINE set_common_miroc
!-----------------------------------------------------------------------
! File I/O
!-----------------------------------------------------------------------

!-- Read a grid file ---------------------------------------------------
SUBROUTINE read_grd(filename,v3d,v2d)
  IMPLICIT NONE
  CHARACTER(*),INTENT(IN) :: filename
  CHARACTER(11) :: filename2
  REAL(r_size),INTENT(OUT) :: v3d(nlon,nlat,nlev,nv3d)
  REAL(r_size),INTENT(OUT) :: v2d(nlon,nlat,nv2d)

  REAL(r_sngl) :: buf4(nlon,nlat)
  INTEGER :: iunit,iolen

!miyazaki

 INTEGER :: i,j,k,n,irec
! [argument]
      character iname  *16
      character oname  *16
      character oname2 *16
      data iname   / 'gtool.in' /
      data oname   / 'member' /
! [internal param]
      real*4  rmiss             !! missing value
      data    rmiss / -999.0 /
      integer iargc             !! number of argument
      character head (64)*16    !! header
!      integer irec              !! counter of time series
!      data irec /1/

      integer ierr              !! flag for error 
      integer ieod              !! flag for file state

      integer ifile, ofile 
      integer l

      integer :: itime,idate(6)
      character :: hunit*16


!miyazaki
  REAL :: v3dtmp(nlon,nlat,nlev,nv3d)
  REAL :: v2dtmp(nlon,nlat,nv2d)
  REAL :: iu(nlon,nlat,nlev)
  REAL :: iu_zm(nlon,nlat,nlev+1)
  real ium  ( nlon, nlat, nlev+1   ) !miyaza

! open input/output data files
      call gfopen  &!! open Restart file
  &     ( ifile    , ierr, &  !I
  &       filename    , 10  , 'READ' , 'UNFORMATTED' ) !O

      call gtsign ( 'miyazaki' )

  PRINT '(A,A15)',  '   guess-file1a2        :',filename

  write(6,*)'readgrd-miyazaki1',filename

! loop for GA/GB
      do l = 1, 2

! modify GAU/GBU

! ---- modify GAU

         call gfread           &
 &        ( head  , iu, ieod, & !O
 &          ifile , 1 ) !I

               if(ieod/=0) stop 'file read error (koshin)'
               v3d(:,:,:,1)=iu(:,:,:)


! ---- modify GAV
         call gfread &          
 &         ( head  , iu, ieod, & !O
 &           ifile , 1 ) !I

               v3d(:,:,:,2)=iu(:,:,:)


! ---- modify GAT
         call gfread  &
 &           ( head  , iu, ieod, & !O
 &            ifile , 1 ) !I

               v3d(:,:,:,3)=iu(:,:,:)

! modify Ps
         call gfread &           !! read GAPS
    &         ( head  , iu, ieod, & !O
    &          ifile , 1 ) !I

               v2d(:,:,1)=iu(:,:,1) *100

! ---- modify GAQ
         call gfread  &
 &           ( head  , iu, ieod, & !O
 &            ifile , 1 ) !I

               v3d(:,:,:,4)=iu(:,:,:)

! skip GAQ(5)-GAQL(6)
         do i = 6, 6
            call gfread &        !! read GAQ
     &           ( head  , ium, ieod, & !O
     &             ifile , 1 ) !I
         end do !! end of GAQ loop

! ---- modify chemical species GAQOX(7)-GAQSO4(41)

!         do i = 7, 91
!
!         call gfread &          
!  &           ( head  , iu, ieod, & !O 
!  &             ifile , 1 ) !I
!
!
!     end do !! end of GAQ loop
   end do !! end of GA/GB loop


! skip GLG(83) - COALB(95)
      do i = 13, 31
         call gfread  &          !! read GDTS
 &            ( head  , ium, ieod, & !O
 &              ifile , 1 )  !I
      end do                    !! end of GDTS loop

      close( ifile  )
!read diagnostic values 
      call gfopen  &!! open Restart file
  &     ( ifile    , ierr, &  !I
  &       'dg'//filename(3:)    , 10  , 'READ' , 'UNFORMATTED' ) !O

! modify T2m
         call gfread &           !! read T2m
    &         ( head  , iu, ieod, & !O
    &          ifile , 1 ) !I
               v2d(:,:,2)=iu(:,:,1)

! modify Q2m                                                   
         call gfread &           !! read Q2m                   
    &         ( head  , iu, ieod, & !O                         
    &          ifile , 1 ) !I                                  
               v2d(:,:,3)=iu(:,:,1)

! modify U10m                                                   
         call gfread &           !! read U10m                   
    &         ( head  , iu, ieod, & !O                         
    &          ifile , 1 ) !I                                  
               v2d(:,:,4)=iu(:,:,1)

! modify V10m                                                   
         call gfread &           !! read V10m                   
    &         ( head  , iu, ieod, & !O                         
    &          ifile , 1 ) !I                                  
               v2d(:,:,5)=iu(:,:,1)

      close( ifile  )
  RETURN
END SUBROUTINE read_grd


!-- Read a grid file ---------------------------------------------------
SUBROUTINE read_grd4(filename,v3d,v2d)
  IMPLICIT NONE
  CHARACTER(*),INTENT(IN) :: filename
  REAL(r_sngl),INTENT(OUT) :: v3d(nlon,nlat,nlev,nv3d)
  REAL(r_sngl),INTENT(OUT) :: v2d(nlon,nlat,nv2d)
  CHARACTER(11) :: filename2

  REAL(r_sngl) :: buf4(nlon,nlat)
  INTEGER :: iunit,iolen

!miyazaki

 INTEGER :: i,j,k,n,irec
! [argument]
      character iname  *16
      character oname  *16
      character oname2 *16
      data iname   / 'gtool.in' /
      data oname   / 'member' /
! [internal param]
      real*4  rmiss             !! missing value
      data    rmiss / -999.0 /
      integer iargc             !! number of argument
      character head (64)*16    !! header
!      integer irec              !! counter of time series
!      data irec /1/

      integer ierr              !! flag for error 
      integer ieod              !! flag for file state

      integer ifile, ofile 
      integer l

      integer :: itime,idate(6)
      character :: hunit*16


!miyazaki
  REAL :: v3dtmp(nlon,nlat,nlev,nv3d)
  REAL :: v2dtmp(nlon,nlat,nv2d)
  REAL :: iu(nlon,nlat,nlev)
  REAL :: iu_zm(nlon,nlat,nlev+1)
  real ium  ( nlon, nlat, nlev+1   ) !miyaza

! open input/output data files
      call gfopen  &!! open Restart file
  &     ( ifile    , ierr, &  !I
  &       filename    , 10  , 'READ' , 'UNFORMATTED' ) !O

      call gtsign ( 'miyazaki' )

  PRINT '(A,A15)',  '   guess-file1a2        :',filename

  write(6,*)'readgrd4-miyazaki1',filename

! loop for GA/GB
      do l = 1, 2

! modify GAU/GBU

! ---- modify GAU

         call gfread           &
 &        ( head  , iu, ieod, & !O
 &          ifile , 1 ) !I

               v3d(:,:,:,1)=iu(:,:,:)

! ---- modify GAV
         call gfread &          
 &         ( head  , iu, ieod, & !O
 &           ifile , 1 ) !I

               v3d(:,:,:,2)=iu(:,:,:)

! ---- modify GAT
         call gfread  &
 &           ( head  , iu, ieod, & !O
 &            ifile , 1 ) !I

               v3d(:,:,:,3)=iu(:,:,:)

! modify Ps
         call gfread &           !! read GAPS
    &         ( head  , iu, ieod, & !O
    &          ifile , 1 ) !I

               v2d(:,:,1)=iu(:,:,1)*100

! ---- modify GAQ
         call gfread  &
 &           ( head  , iu, ieod, & !O
 &            ifile , 1 ) !I

               v3d(:,:,:,4)=iu(:,:,:)

! skip GAQ(5)-GAQL(6)
         do i = 6, 6
            call gfread &        !! read GAQ
     &           ( head  , ium, ieod, & !O
     &             ifile , 1 ) !I
         end do !! end of GAQ loop

! ---- modify chemical species GAQOX(7)-GAQSO4(41)

!         do i = 7, 91
!
!         call gfread &          
!  &           ( head  , iu, ieod, & !O 
!  &             ifile , 1 ) !I
!
!
!      end do !! end of GAQ loop
   end do !! end of GA/GB loop


! skip GLG(83) - COALB(95)
      do i = 13, 31
         call gfread  &          !! read GDTS
 &            ( head  , ium, ieod, & !O
 &              ifile , 1 )  !I
      end do                    !! end of GDTS loop

               write(6,*)'miyazaki-read_grd4',v3d(10,10,10,1),v3d(10,10,10,2)

      close( ifile  )
!read diagnostic values                                             
      call gfopen  &!! open Restart file                            
  &     ( ifile    , ierr, &  !I                                    
  &       'dg'//filename(3:)    , 10  , 'READ' , 'UNFORMATTED' ) !O

! modify T2m                                                        
         call gfread &           !! read T2m                        
    &         ( head  , iu, ieod, & !O                              
    &          ifile , 1 ) !I                                       
               v2d(:,:,2)=iu(:,:,1)

! modify Q2m                                                        
         call gfread &           !! read Q2m                        
    &         ( head  , iu, ieod, & !O                              
    &          ifile , 1 ) !I                                       
               v2d(:,:,3)=iu(:,:,1)

! modify U10m                                                       
         call gfread &           !! read U10m                       
    &         ( head  , iu, ieod, & !O                              
    &          ifile , 1 ) !I                                       
               v2d(:,:,4)=iu(:,:,1)

! modify V10m                                                       
         call gfread &           !! read V10m                       
    &         ( head  , iu, ieod, & !O                              
    &          ifile , 1 ) !I                                       
               v2d(:,:,5)=iu(:,:,1)

      close( ifile  )
  RETURN
END SUBROUTINE read_grd4

!-- Write a grid file -------------------------------------------------
SUBROUTINE write_grd(filename,v3d,v2d)
  IMPLICIT NONE
  CHARACTER(*),INTENT(IN) :: filename
  REAL(r_size),INTENT(IN) :: v3d(nlon,nlat,nlev,nv3d)
  REAL(r_size),INTENT(IN) :: v2d(nlon,nlat,nv2d)
  REAL(r_sngl) :: buf4(nlon,nlat)
  INTEGER :: iunit,iolen
  INTEGER :: k,n,irec

  iunit=55
  INQUIRE(IOLENGTH=iolen) iolen
  OPEN(iunit,FILE=filename,FORM='unformatted',ACCESS='direct',RECL=nij0*iolen)

  irec=1
  DO n=1,nv3d
    DO k=1,nlev
      buf4 = REAL(v3d(:,:,k,n),r_sngl)
      WRITE(iunit,REC=irec) buf4
      irec = irec + 1
    END DO
  END DO

  DO n=1,nv2d
    buf4 = REAL(v2d(:,:,n),r_sngl)
    WRITE(iunit,REC=irec) buf4
    irec = irec + 1
  END DO

  CLOSE(iunit)

  RETURN
END SUBROUTINE write_grd

SUBROUTINE write_grd4(filename,gsfilename,v3d,v2d) !miyazaki
  IMPLICIT NONE
  CHARACTER(*),INTENT(IN) :: filename
  CHARACTER(*),INTENT(IN) :: gsfilename
  REAL(r_sngl),INTENT(IN) :: v3d(nlon,nlat,nlev,nv3d)
  REAL(r_sngl),INTENT(IN) :: v2d(nlon,nlat,nv2d)
  REAL(r_sngl) :: nox(nlon,nlat)
  INTEGER :: iunit,iolen
  INTEGER :: i,j,k,l,n,irec
  CHARACTER(11) :: filename2


!miyazaki

! [argument]
      character iname  *16
      character oname  *16
      character oname2 *16
      data iname   / 'gtool.in' /
      data oname   / 'member' /
! [internal param]
      real*4  rmiss             !! missing value
      data    rmiss / -999.0 /
      integer iargc             !! number of argument
      character head (64)*16    !! header
!      integer irec              !! counter of time series
!      data irec /1/

      integer ierr              !! flag for error 
      integer ieod              !! flag for file state

      integer ifile, ofile1,ifile1

!miyazaki
  REAL :: v3dtmp(nlon,nlat,nlev,nv3d)
  REAL :: v2dtmp(nlon,nlat,nv2d)
  REAL :: iu(nlon,nlat,nlev)
  REAL :: iu2(nlon,nlat,nlev)
  real ium  ( nlon, nlat, nlev+1   ) !miyaza

  integer :: out_opt

  write(6,*)'WWW,out,in',filename,gsfilename

         call gfopen &           !! open output Restart file
   &        ( ofile1 , ierr,& !O
   &          filename, 19  , 'WRITE', 'UNFORMATTED' ) !I


         call gfopen  &!! open input Restart file
  &     ( ifile    , ierr, &  !I
  &       gsfilename    , 2  , 'READ' , 'UNFORMATTED' ) !O

! loop for GA/GB
      do l = 1, 2

! i=1 U

         call gfread &        !! read GAQ
     &           ( head  , iu, ieod, & !O
     &             ifile , 1 ) !I

               iu(:,:,:)=v3d(:,:,:,1)

            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I

! i=2 V

         call gfread &        !! read GAQ
     &           ( head  , iu, ieod, & !O
     &             ifile , 1 ) !I

               iu(:,:,:)=v3d(:,:,:,2)

            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I
! i=3 T

         call gfread &        !! read GAQ
     &           ( head  , iu, ieod, & !O
     &             ifile , 1 ) !I

               iu(:,:,:)=v3d(:,:,:,3)

            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I
! i=4 PS

         call gfread &        !! read GAQ
     &           ( head  , iu, ieod, & !O
     &             ifile , 1 ) !I

               iu(:,:,1)=v2d(:,:,1)/100

            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I
! i=5 Q

         call gfread &        !! read GAQ
     &           ( head  , iu, ieod, & !O
     &             ifile , 1 ) !I

               iu(:,:,:)=max(v3d(:,:,:,4),1.d-10)

            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I

! skip

         do i = 6, 6
            call gfread &        !! read GAQ
     &           ( head  , iu, ieod, & !O
     &             ifile , 1 ) !I

            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 )  !I
         end do 

   end do !! end of GA/GB loop

! skip 83-95
      do i = 13, 31
         call gfread  &          !! read GDTS
 &            ( head  , iu, ieod, & !O
 &              ifile , 1 )  !I
         call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I


      end do                    !! end of GDTS loop

      close(ifile)
      close(ofile1)
!write diagnostic values
         call gfopen &           !! open output Diagnos file
   &        ( ofile1 , ierr,& !O
   &          'diag'//filename(5:), 19  , 'WRITE', 'UNFORMATTED' ) !I


         call gfopen  &!! open input Diagnos file
  &     ( ifile    , ierr, &  !I
  &       'dg'//gsfilename(3:)    , 2  , 'READ' , 'UNFORMATTED' ) !O
! i=2 T2m

         call gfread &        !! read
     &           ( head  , iu, ieod, & !O
     &             ifile , 1 ) !I

               iu(:,:,1)=v2d(:,:,2)

            call gfwrit &        !! write
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I
! i=3 Q2m                                                      

         call gfread &        !! read                          
     &           ( head  , iu, ieod, & !O                      
     &             ifile , 1 ) !I                              

               iu(:,:,1)=max(v2d(:,:,3),1.d-10)

            call gfwrit &        !! write                      
  &           ( head    , iu(1,1,1), & !O                      
  &              ofile1, 1          , 0 ) !I 
! i=4 U10m                                                      

         call gfread &        !! read                          
     &           ( head  , iu, ieod, & !O                      
     &             ifile , 1 ) !I                              

               iu(:,:,1)=v2d(:,:,4)

            call gfwrit &        !! write                      
  &           ( head    , iu(1,1,1), & !O                      
  &              ofile1, 1          , 0 ) !I 
! i=5 V10m                                                      

         call gfread &        !! read                          
     &           ( head  , iu, ieod, & !O                      
     &             ifile , 1 ) !I                              

               iu(:,:,1)=v2d(:,:,5)

            call gfwrit &        !! write                      
  &           ( head    , iu(1,1,1), & !O                      
  &              ofile1, 1          , 0 ) !I 

      close(ifile)
      close(ofile1)
!end diagnostic values


      out_opt=0

      if(out_opt.eq.1)then

 ! write u

    WRITE(filename2(1:11),'(A4,A7)') 'uaa',filename(5:11)  !miyazaki

         call gfopen &           !! open output ox.gt3 file
   &        ( ofile1 , ierr,& !O
   &          filename2, 19  , 'WRITE', 'UNFORMATTED' ) !I

         call gfopen  &!! open input Restart file
  &     ( ifile    , ierr, &  !I
  &       'ctl.grd'    , 2  , 'READ' , 'UNFORMATTED' ) !O

         call gfread  &          !! read GDTS
 &            ( head  , iu, ieod, & !O
 &              ifile , 1 )  !I

               iu(:,:,:)=v3d(:,:,:,1)
         
            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I

      close(ifile)
      close(ofile1)

 ! write v

    WRITE(filename2(1:11),'(A4,A7)') 'vaa',filename(5:11)  !miyazaki

         call gfopen &           !! open output ox.gt3 file
   &        ( ofile1 , ierr,& !O
   &          filename2, 19  , 'WRITE', 'UNFORMATTED' ) !I

         call gfopen  &!! open input Restart file
  &     ( ifile    , ierr, &  !I
  &       'ctl.grd'    , 2  , 'READ' , 'UNFORMATTED' ) !O

         call gfread  &          !! read GDTS
 &            ( head  , iu, ieod, & !O
 &              ifile , 1 )  !I

               iu(:,:,:)=v3d(:,:,:,2)
         
            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I

      close(ifile)
      close(ofile1)

 ! write t

    WRITE(filename2(1:11),'(A4,A7)') 'taa',filename(5:11)  !miyazaki

         call gfopen &           !! open output ox.gt3 file
   &        ( ofile1 , ierr,& !O
   &          filename2, 19  , 'WRITE', 'UNFORMATTED' ) !I

         call gfopen  &!! open input Restart file
  &     ( ifile    , ierr, &  !I
  &       'ctl.grd'    , 2  , 'READ' , 'UNFORMATTED' ) !O

         call gfread  &          !! read GDTS
 &            ( head  , iu, ieod, & !O
 &              ifile , 1 )  !I

               iu(:,:,:)=v3d(:,:,:,3)
         
            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I

      close(ifile)
      close(ofile1)

 ! write q

    WRITE(filename2(1:11),'(A4,A7)') 'qaa',filename(5:11)  !miyazaki

         call gfopen &           !! open output ox.gt3 file
   &        ( ofile1 , ierr,& !O
   &          filename2, 19  , 'WRITE', 'UNFORMATTED' ) !I

         call gfopen  &!! open input Restart file
  &     ( ifile    , ierr, &  !I
  &       'ctl.grd'    , 2  , 'READ' , 'UNFORMATTED' ) !O

         call gfread  &          !! read GDTS
 &            ( head  , iu, ieod, & !O
 &              ifile , 1 )  !I

               iu(:,:,:)=v3d(:,:,:,4)
         
            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I

      close(ifile)
      close(ofile1)

 ! write ps

    WRITE(filename2(1:11),'(A4,A7)') 'psa',filename(5:11)  !miyazaki

         call gfopen &           !! open output ox.gt3 file
   &        ( ofile1 , ierr,& !O
   &          filename2, 19  , 'WRITE', 'UNFORMATTED' ) !I

         call gfopen  &!! open input Restart file
  &     ( ifile    , ierr, &  !I
  &       'ctl.grd'    , 2  , 'READ' , 'UNFORMATTED' ) !O

         call gfread  &          !! read GDTS
 &            ( head  , iu, ieod, & !O
 &              ifile , 1 )  !I

               iu(:,:,1)=v2d(:,:,1)/100
         
            call gfwrit &        !! write GAU
  &           ( head    , iu(1,1,1), & !O
  &              ofile1, 1          , 0 ) !I

      close(ifile)
      close(ofile1)

   end if

  RETURN
END SUBROUTINE write_grd4


!-----------------------------------------------------------------------
SUBROUTINE calc_pfull_half(ix,jy,ps,p_full,p_half)
  IMPLICIT NONE
  INTEGER,INTENT(IN) :: ix,jy
  REAL(r_size),INTENT(IN) :: ps(ix,jy)
  REAL(r_size),INTENT(OUT) :: p_full(ix,jy,nlev)
  REAL(r_size),INTENT(OUT) :: p_half(ix,jy,nlev)
  REAL(r_size) :: sigml(nlev),pa(nlev),pb(nlev),pam(nlev),pbm(nlev)
  INTEGER :: i,j,k,k2

!    data sigml /                                        & !from top to surface
! &     0.007, 0.0145262, 0.0229266, 0.0303840, 0.0369174,        &
! &     0.0434621, 0.0504747, 0.0581451, 0.0668086, 0.0767628,    &
! &     0.0882002, 0.1013420, 0.116441, 0.1337910, 0.153725,      &
! &     0.176629, 0.2029460, 0.2331840, 0.2679290, 0.307849,      &
! &     0.353718, 0.40642, 0.466975, 0.536552, 0.615275,          &
! &     0.7, 0.79, 0.87, 0.93, 0.97,     &
! &     0.99, 1.0/

data pam / &
&       0.,2.4515624,5.8837676,10.786892,16.670631,24.025347,32.850956,43.147541, 54.42474, 67.17289,&
&80.901649,95.611023, 113.2623,134.83604,160.33235,189.75113,220.15051,251.04024,278.00745,298.11029,&
&314.78091,     329.,281.64999,   241.12,   206.42,176.70999,151.28   ,129.50999,110.87   ,94.915001,&
&81.254997,69.562004,59.551003,50.980003,43.644001,37.362999,31.985998, 27.382  ,23.441999,20.067999,&
&17.18    ,14.708   ,12.591   ,10.779   ,9.2276993,7.8996997,6.7627997,5.7895999,4.9563999,4.2431002,&
&3.6324   ,3.1097   ,2.6622   ,2.2789998,1.951    ,1.6703   ,1.4298999,1.2241   ,1.0479   ,0.89713001,&
&0.76801997,0.65749002,0.56287003,0.48186001,0.41251999,0.35315001,0.30233002,0.25882,0.22157,0.18968,&
&0.16238001,0.13902001,0.11901,0.10188001,0.087220006,0.074666999,0.063922003,0.054722,0.046847001,0.040105,&
&0.034332998,0.029392,0.025162,0.021540999,0.018441001,0.015787,0.013515,0.01157,0.0099051008,0.0084795998,&
&0.0072592003,0.0062144999,0.0053202002,0.0045544999,0.0038991002,0.0033378999,0.0028576001,0.0024462999,0.0020943,0.0017929,&
&0.0015348,0.001314,0.0011249,0.00096298003,0.00082438998,0.00070574996,0.00060417998,0.00051722996,0.0004428,0.00037907,&
&0.00032451999,0.00027781,0.00023783,0.00020361,0.00016897,0.00013509,0.00010328,7.4832999e-05,5.0835999e-05,3.1965003e-05,&
&1.8318e-05,9.3908993e-06,4.2122001e-06,1.6094e-06/

data pbm / &
& 1.00000000 , 0.99254847 , 0.98211622 , 0.96721309 , 0.94932938 ,&
& 0.92697465 , 0.90014905 , 0.86885244 , 0.83457524 , 0.79582709 ,&
& 0.75409836 , 0.70938897 , 0.6557377  , 0.59016395 , 0.51266766 ,&
& 0.42324886 , 0.33084947 , 0.23695977 , 0.15499255 , 0.093889706,&
& 0.043219097,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    ,&
&  0.0000    ,  0.0000    ,  0.0000    ,  0.0000    /

data pa / &
&1.226694,4.1694746,8.3390846,13.734285,20.356855,28.451359,38.017979,48.809715,60.830666,74.076668,&
&88.304985,104.51319,124.17757,147.79349,175.38445,205.42998,236.2968,265.35715,288.84094,307.49915,&
&325.49335,305.1062,261.19775,223.60966,191.4277,163.8775,140.29442,120.10387,102.81879,88.021881,&
&75.354477,64.510246,55.225895,47.278111,40.47448,34.649654,29.662722,25.393799,21.739408,18.610655,&
&15.93258,13.639717,11.676627,9.9961815,8.5575638,7.3259969,6.2717037,5.3691502,4.5964541,3.9349279,&
&3.3686352,2.8838825,2.4688289,2.1134844,1.8093534,1.5489892,1.326049,1.1351857,0.97181851,0.83197844,&
&0.71224427,0.60974282,0.52199066,0.44686964,0.38256067,0.3275052,0.28037396,0.24002287,0.20547763,0.17590386,&
&0.15059212,0.12892254,0.11036584,0.09448228,0.080885492,0.069244854,0.05927949,0.050748114,0.043444846,0.037192326,&
&0.031839669,0.027257456,0.02333477,0.019976677,0.017101737,0.014640503,0.012533514,0.010729859,0.009185764,0.0078637609,&
&0.0067320229,0.0057632183,0.0049338117,0.0042237719,0.0036159067,0.0030955311,0.0026500493,0.0022686739,0.0019422075,0.0016626571,&
&0.0014233802,0.0012185762,0.0010431918,0.00089304463,0.00076452183,0.00065449567,0.00056030322,0.00047967111,0.00041064052,0.00035154296,&
&0.00030094912,0.00025763526,0.00022056192,0.00018609798,0.00015180476,0.00011893146,8.8784742e-05,6.2559826e-05,4.1141917e-05,2.4917852e-05,&
&1.3679726e-05,6.6807565e-06,2.8386589e-06,1.0222096e-06/

data pb / &
& 0.99627256, 0.98732907, 0.97465789, 0.95826131, 0.93813616, 0.9135384, 0.88446778, 0.85167283, 0.81514633, 0.77489585,&
& 0.73166233, 0.68243778, 0.62274528, 0.55109137, 0.46744883, 0.37637332, 0.28297567, 0.19494721, 0.12353771, 0.067409076,&
& 0.017933778, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000/

!$OMP PARALLEL DO PRIVATE(i,j,k)
  DO k=1,nlev
    DO j=1,jy
      DO i=1,ix
        p_full(i,j,k) = ps(i,j) * pb(k) + pa(k)*100
        p_half(i,j,k) = ps(i,j) * pbm(k) + pam(k)*100
      END DO
    END DO
  END DO
!$OMP END PARALLEL DO

  RETURN
END SUBROUTINE calc_pfull_half
!-----------------------------------------------------------------------
! p_full
!-----------------------------------------------------------------------
SUBROUTINE calc_pfull(ix,jy,ps,p_full)
  IMPLICIT NONE
  INTEGER,INTENT(IN) :: ix,jy
  REAL(r_size),INTENT(IN) :: ps(ix,jy)
  REAL(r_size),INTENT(OUT) :: p_full(ix,jy,nlev)
  REAL(r_size) :: sigml(nlev)
  INTEGER :: i,j,k,k2
  REAL(r_size) :: pa(nlev),pb(nlev)

data pa / &
&1.226694,4.1694746,8.3390846,13.734285,20.356855,28.451359,38.017979,48.809715,60.830666,74.076668,&
&88.304985,104.51319,124.17757,147.79349,175.38445,205.42998,236.2968,265.35715,288.84094,307.49915,&
&325.49335,305.1062,261.19775,223.60966,191.4277,163.8775,140.29442,120.10387,102.81879,88.021881,&
&75.354477,64.510246,55.225895,47.278111,40.47448,34.649654,29.662722,25.393799,21.739408,18.610655,&
&15.93258,13.639717,11.676627,9.9961815,8.5575638,7.3259969,6.2717037,5.3691502,4.5964541,3.9349279,&
&3.3686352,2.8838825,2.4688289,2.1134844,1.8093534,1.5489892,1.326049,1.1351857,0.97181851,0.83197844,&
&0.71224427,0.60974282,0.52199066,0.44686964,0.38256067,0.3275052,0.28037396,0.24002287,0.20547763,0.17590386,&
&0.15059212,0.12892254,0.11036584,0.09448228,0.080885492,0.069244854,0.05927949,0.050748114,0.043444846,0.037192326,&
&0.031839669,0.027257456,0.02333477,0.019976677,0.017101737,0.014640503,0.012533514,0.010729859,0.009185764,0.0078637609,&
&0.0067320229,0.0057632183,0.0049338117,0.0042237719,0.0036159067,0.0030955311,0.0026500493,0.0022686739,0.0019422075,0.0016626571,&
&0.0014233802,0.0012185762,0.0010431918,0.00089304463,0.00076452183,0.00065449567,0.00056030322,0.00047967111,0.00041064052,0.00035154296,&
&0.00030094912,0.00025763526,0.00022056192,0.00018609798,0.00015180476,0.00011893146,8.8784742e-05,6.2559826e-05,4.1141917e-05,2.4917852e-05,&
&1.3679726e-05,6.6807565e-06,2.8386589e-06,1.0222096e-06/

data pb / &
& 0.99627256, 0.98732907, 0.97465789, 0.95826131, 0.93813616, 0.9135384, 0.88446778, 0.85167283, 0.81514633, 0.77489585,&
& 0.73166233, 0.68243778, 0.62274528, 0.55109137, 0.46744883, 0.37637332, 0.28297567, 0.19494721, 0.12353771, 0.067409076,&
& 0.017933778, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,&
& 0.0000, 0.0000, 0.0000, 0.0000/


!$OMP PARALLEL DO PRIVATE(i,j,k)                                                                                                         
  DO k=1,nlev
    DO j=1,jy
      DO i=1,ix
        p_full(i,j,k) = ps(i,j) * pb(k) + pa(k)*100
      END DO
    END DO
  END DO
!$OMP END PARALLEL DO   

  RETURN
END SUBROUTINE calc_pfull
!-----------------------------------------------------------------------
! Monitor
!-----------------------------------------------------------------------
SUBROUTINE monit_grd(v3d,v2d)
  IMPLICIT NONE
  REAL(r_size),INTENT(IN) :: v3d(nlon,nlat,nlev,nv3d)
  REAL(r_size),INTENT(IN) :: v2d(nlon,nlat,nv2d)
  INTEGER :: k,n

  DO k=1,nlev
    PRINT '(I2,A)',k,'th level'
    DO n=1,nv3d
      PRINT '(A,2ES10.2)',element(n),MAXVAL(v3d(:,:,k,n)),MINVAL(v3d(:,:,k,n))
    END DO
  END DO

  DO n=1,nv2d
    PRINT '(A,2ES10.2)',element(nv3d+n),MAXVAL(v2d(:,:,n)),MINVAL(v2d(:,:,n))
  END DO

  RETURN
END SUBROUTINE monit_grd
!-----------------------------------------------------------------------
! Ensemble manipulations
!-----------------------------------------------------------------------
SUBROUTINE ensmean_grd(member,nij,v3d,v2d,v3dm,v2dm)
  IMPLICIT NONE
  INTEGER,INTENT(IN) :: member
  INTEGER,INTENT(IN) :: nij
  REAL(r_size),INTENT(IN) :: v3d(nij,nlev,member,nv3d)
  REAL(r_size),INTENT(IN) :: v2d(nij,member,nv2d)
  REAL(r_size),INTENT(OUT) :: v3dm(nij,nlev,nv3d)
  REAL(r_size),INTENT(OUT) :: v2dm(nij,nv2d)
  INTEGER :: i,k,m,n

  DO n=1,nv3d
!$OMP PARALLEL DO PRIVATE(i,k,m)
    DO k=1,nlev
      DO i=1,nij
        v3dm(i,k,n) = v3d(i,k,1,n)
        DO m=2,member
          v3dm(i,k,n) = v3dm(i,k,n) + v3d(i,k,m,n)
        END DO
        v3dm(i,k,n) = v3dm(i,k,n) / REAL(member,r_size)
      END DO
    END DO
!$OMP END PARALLEL DO
  END DO

  DO n=1,nv2d
    DO i=1,nij
      v2dm(i,n) = v2d(i,1,n)
      DO m=2,member
        v2dm(i,n) = v2dm(i,n) + v2d(i,m,n)
      END DO
      v2dm(i,n) = v2dm(i,n) / REAL(member,r_size)
    END DO
  END DO

  RETURN
END SUBROUTINE ensmean_grd

!-----------------------------------------------------------------------
! Ensemble manipulations
!-----------------------------------------------------------------------
SUBROUTINE ensmean_grd_ps(member,nij,v2d,v2dm)
  IMPLICIT NONE
  INTEGER,INTENT(IN) :: member
  INTEGER,INTENT(IN) :: nij
  REAL(r_size),INTENT(IN) :: v2d(nij,member)
  REAL(r_size),INTENT(OUT) :: v2dm(nij)
  INTEGER :: i,k,m,n

    DO i=1,nij
      v2dm(i) = v2d(i,1)
      DO m=2,member
        v2dm(i) = v2dm(i) + v2d(i,m)
      END DO
      v2dm(i) = v2dm(i) / REAL(member,r_size)
    END DO

  RETURN
END SUBROUTINE ensmean_grd_ps

!*****************************************************************
! for reading to gt3 formatted files
!
      subroutine gt3read( ounit, oval, nlon, nlat, km, idate, itime, hunit )

! [input]
        integer i,j
        integer nlon,nlat
        integer :: ounit       !! unit number
        real*4 ::  oval(nlon,nlat)     !! history data
        integer :: km        !! history levels
        integer :: idate(6)    !! date (year, month, day, hour, min., sec.)
        integer :: itime       !! forecast time
        character*(*) :: hunit       !! history unit

! [internal]
        character*16 :: head(64)    !! GTOOL3 header

! [work]
!      integer       i

!
      read ( ounit ) head !; print *, ' header written, oval next'
!     print *, head(16),  head(25), head(27) !, imax, jmax, kmax
      read ( head(25), '(I16)' ) itime
      read ( head(27), 900 ) (idate(i),i=1,6)
      hunit = head(16)
      read ( ounit ) (( oval(i,j), i = 1, nlon), j = 1, nlat)
!
  900 format( I4.4,I2.2,i2.2,' ',I2.2,I2.2,I2.2 )
!
      return
    end subroutine gt3read
      

END MODULE common_miroc
