
;gsn_1.ncl
;----------------------------------------------------------------------
; Concepts illustrated:
;   - Using wrf_xxxx scripts to plot WRF-ARW data
;----------------------------------------------------------------------
; This script is meant to show the difference between plotting WRF
; data using wrf_xxx scripts, and using gsn_csm_xxx scripts.
;----------------------------------------------------------------------; 
; These files are loaded by default in NCL V6.2.0 and newer
 load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
 load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
 load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"

begin
;---PBL model
  pblmodel="ACM2_MM5_0.5"
  chem     = 0

;---Open WRF output file
  dir      = "./"
  filename = "wrfout_d03_"
  year = 2014
  month = 10
  sday = 23
  eday = 24
  time = "_00:00:00"
  
  do day = sday,eday ;--------cycle day
   month1 = tostring(month)
   day1   = tostring(day)
  if month .lt. 10 then
  	month1 = "0" + month     
  end if
  if day .lt. 10 then
        day1 = "0" + day
  end if
  a = addfile(dir + filename + year +"-"+ month1 + "-" + day1 + time + ".nc","r")
  chem     = 0
  dim2     = 1
  profile  = 1
 ;do it=3,4,1   ;-----cycle structure 
		 ;n=start,end,stride
;---Read terrain height and lat/lon off file.
  it        = 0    ; first time step
  z	    = 0    ; z axis
  ;---find ij near lat/lon
  opt = True
  opt@MAP_PROJ  = a@MAP_PROJ
  opt@TRUELAT1  = a@TRUELAT1
  opt@TRUELAT2  = a@TRUELAT2
  opt@STAND_LON = a@STAND_LON
  opt@DX        = a@DX
  opt@DY        = a@DY

  XLAT  = a->XLAT(0,:,:)
  XLONG = a->XLONG(0,:,:)

  opt@REF_LAT = XLAT(0,0)
  opt@REF_LON = XLONG(0,0)
  opt@KNOWNI  = 1.0
  opt@KNOWNJ  = 1.0  

  loc   = wrf_ll_to_ij(116.37,39.97,opt)     ;---lonlat转换为格点
  locir  = floattointeger(loc)                ;---格点取整
  locll = wrf_ij_to_ll(locir(0),locir(1),opt) ;---查看所取格点lonlat位置
  print(locll)
 
  loci = new( (/2/),integer) 
  loci = (/locir(1),locir(0)/)
 

  nn = dimsizes(a->Times)
  te = nn(0)-1

  TE        = wrf_user_getvar(a,"HGT",0)    ; Terrain elevation
  print(TE(loci(0),loci(1)))
  if dim2 .eq. 1 then ;--------------------------------------------------
  times     = wrf_user_getvar(a,"Times",-1)
  hgt       = wrf_user_getvar(a,"PBLH",-1)   ; PBL HEIGHT
  Q2        = wrf_user_getvar(a,"Q2",-1)   ; QV at 2 M   ;units : kg kg-1
  T2        = wrf_user_getvar(a,"T2",-1)   ; TEMP at 2 M ;units : k
  U10       = wrf_user_getvar(a,"U10",-1)   ;           ;units : m s-1
  V10       = wrf_user_getvar(a,"V10",-1)   ;
 ; PBLH       = wrf_user_getvar(a,"PBLH",-1)   ; PBL HEIGHT
  HFX       = wrf_user_getvar(a,"HFX",-1)   ; UPWARD HEAT FLUX AT THE SURFACE;W m-2
  QFX       = wrf_user_getvar(a,"QFX",-1)   ; UPWARD MOISTURE FLUX AT THE SURFACE;kg m-2 s-1
  PSFC      = wrf_user_getvar(a,"PSFC",-1)  ; SFC PRESSURE ;units : Pa
  RAINC     = wrf_user_getvar(a,"RAINC",-1)
  RAINNC    = wrf_user_getvar(a,"RAINNC",-1)
  RAINSH    = wrf_user_getvar(a,"RAINSH",-1)
  end if ;----------------------------------------------------------------
 if chem .eq. 1 then
  so2      = wrf_user_getvar(a,"so2",-1);ppmv
  no       = wrf_user_getvar(a,"no",-1)
  no2      = wrf_user_getvar(a,"no2",-1)
  o3       = wrf_user_getvar(a,"o3",-1)
  ald      = wrf_user_getvar(a,"ald",-1)
  hcho     = wrf_user_getvar(a,"hcho",-1)
  nh3      = wrf_user_getvar(a,"nh3",-1)
  eth      = wrf_user_getvar(a,"eth",-1)
  co       = wrf_user_getvar(a,"co",-1)
  tol      = wrf_user_getvar(a,"tol",-1)
  xyl      = wrf_user_getvar(a,"xyl",-1)
  iso      = wrf_user_getvar(a,"iso",-1)
  pm25dry  = wrf_user_getvar(a,"PM2_5_DRY",-1) ;ug/kg-dryair
  p25i     = wrf_user_getvar(a,"p25i",-1)
  p25j     = wrf_user_getvar(a,"p25j",-1)
  pm10     = wrf_user_getvar(a,"PM10",-1)
 end if ;---------------------------------------------------------------
  PH       = wrf_user_getvar(a,"PH",-1)
  PHB      = wrf_user_getvar(a,"PHB",-1)
  LH       = wrf_user_getvar(a,"LH",-1)         ;LATENT HEAT FLUX AT THE SURFACE
  SWDOWN   = wrf_user_getvar(a,"SWDOWN",-1)     ;DOWNWARD SHORT WAVE FLUX AT GROUND SURFACE
  QVAPOR   = wrf_user_getvar(a,"QVAPOR",-1)
  T00      = wrf_user_getvar(a,"T00",-1)
  T        = wrf_user_getvar(a,"T",-1)      ; perturbation potential temperature
  TSK      = wrf_user_getvar(a,"TSK",-1)      ;         SURFACE SKIN TEMPERATURE
  EXCH_H   = wrf_user_getvar(a,"EXCH_H",-1)      ;      exch coff of heat
  Z        = wrf_user_getvar(a,"z",-1)
  TSLB     = wrf_user_getvar(a,"TSLB",-1)       ;soil temp
  GLW      = wrf_user_getvar(a,"GLW",-1)        ;DOWNWARD LONG WAVE FLUX AT GROUND SURFACE
  OLR      = wrf_user_getvar(a,"OLR",-1)        ;TOA OUTGOING LONG WAVE
  GRDFLX        = wrf_user_getvar(a,"GRDFLX",-1)        ;GROUND HEAT FLUX
  U     = wrf_user_getvar(a,"U",-1)
  V     = wrf_user_getvar(a,"V",-1)

;---read last 24 hours data 
  realtime  = wrf_user_getvar(a,"Times",0)  ; Time
  if dim2 .eq. 1 then
  nn = dimsizes(realtime)
  jj = 16+23     ;nn(0)-1 ;---end
  ii = 16  ;jj-23   ;---start
 ; print(ii)
 ; print(jj)
  print(times(ii:jj,:))
  var1 = hgt(ii:jj,loci(0),loci(1))
  var2 = Q2(ii:jj,loci(0),loci(1))
  var3 = T2(ii:jj,loci(0),loci(1))
  var4 = U10(ii:jj,loci(0),loci(1))
  var5 = V10(ii:jj,loci(0),loci(1))
  var6 = HFX(ii:jj,loci(0),loci(1))
  var7 = QFX(ii:jj,loci(0),loci(1))
  var8 = PSFC(ii:jj,loci(0),loci(1))
  var9 = RAINC(ii:jj,loci(0),loci(1))
  var10 = RAINNC(ii:jj,loci(0),loci(1))
  var11 = RAINSH(ii:jj,loci(0),loci(1))
  if chem .eq. 1 then
  var12 = so2(:,z,loci(0),loci(1))
  var13 = no(:,z,loci(0),loci(1))
  var14 = no2(:,z,loci(0),loci(1))
  var15 = o3(:,z,loci(0),loci(1))
  var16 = ald(:,z,loci(0),loci(1))
  var17 = hcho(:,z,loci(0),loci(1))
  var18 = nh3(:,z,loci(0),loci(1))
  var19 = eth(:,z,loci(0),loci(1))
  var20 = co(:,z,loci(0),loci(1))
  var21 = tol(:,z,loci(0),loci(1))
  var22 = xyl(:,z,loci(0),loci(1))
  var23 = iso(:,z,loci(0),loci(1))
  var24 = pm25dry(:,z,loci(0),loci(1))
  var25 = p25i(:,z,loci(0),loci(1))
  var26 = p25j(:,z,loci(0),loci(1))
  var29 = pm10(:,z,loci(0),loci(1))
  end if
  var27 = PH(ii:jj,z,loci(0),loci(1))
  var28 = PHB(ii:jj,z,loci(0),loci(1))
  var30 = LH(ii:jj,loci(0),loci(1))
  var31 = SWDOWN(ii:jj,loci(0),loci(1))  
  var32 = T00(ii:jj)
  var33 = TSK(ii:jj,loci(0),loci(1))
  var41 = GLW(ii:jj,loci(0),loci(1))
  var42 = OLR(ii:jj,loci(0),loci(1))
  var43 = GRDFLX(ii:jj,loci(0),loci(1))

  end if

if profile .eq. 1 then
        var34 = QVAPOR(ii:jj,:,loci(0),loci(1))
        var35 = T(ii:jj,:,loci(0),loci(1))  ; theta-t0
        var36 = EXCH_H(ii:jj,:,loci(0),loci(1))
        var37 = PH(ii:jj,:,loci(0),loci(1))
        var38 = PHB(ii:jj,:,loci(0),loci(1))
        var39 = Z(ii:jj,:,loci(0),loci(1))
        var40 = TSLB(ii:jj,:,loci(0),loci(1))
        var44 = U(ii:jj,:,loci(0),loci(1))
        var45 = V(ii:jj,:,loci(0),loci(1))
end if
 delete([/QVAPOR,T,Z,TSLB,U,V,EXCH_H/]);EXCH_H
 delete([/times,hgt,Q2,T2,U10,V10,HFX,QFX,PSFC,RAINC,RAINNC,RAINSH,PH,PHB,LH,SWDOWN,T00,TSK,GLW,OLR,GRDFLX/])
  ;end do   ;-----cycle structure

 ;-------------------write_csv-------------------

 ;system("rm -f " + filename1)


if dim2 .eq. 1 then
 filename1 = pblmodel+"_"+ year +"-"+ month1 + "-" + day1 +"_datachem.csv"


  if chem .eq. 1 then
  write_table(filename1,"w",[/var1,var2,var3,var4,var5,var6,var7,var8,var9,var10,var11,var12,var13,var14,var15,var16,var17,var18,var19,var20,var21,var22,var23,var24,var25,var26,var27,var28,var29/],"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f")
  end if

  if chem .eq. 0 then
  write_table(filename1,"w",[/var1,var2,var3,var4,var5,var6,var7,var8,var9,var10,var11,var27,var28,var30,var31,var32,var33,var41,var42,var43/],"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f")
  end if
end if

if profile .eq. 1 then
  opt_Q = True
  opt_Q@fout = pblmodel+"-Q-porfile"+"-"+month1+"-"+day1
  write_matrix(var34,"48f18.9",opt_Q)

  opt_T = True
  opt_T@fout = pblmodel+"-T-porfile"+"-"+month1+"-"+day1
  write_matrix(var35,"48f18.9",opt_T)

  opt_EXCH_H = True
  opt_EXCH_H@fout = pblmodel+"-EXCH_H-porfile"+"-"+month1+"-"+day1
  write_matrix(var36,"48f18.9",opt_EXCH_H)

  opt_PH = True
  opt_PH@fout = pblmodel+"-PH-porfile"+"-"+month1+"-"+day1
  write_matrix(var37,"48f18.9",opt_PH)

  opt_PHB = True
  opt_PHB@fout = pblmodel+"-PHB-porfile"+"-"+month1+"-"+day1
  write_matrix(var38,"48f18.9",opt_PHB)

  opt_Z = True
  opt_Z@fout = pblmodel+"-Z-porfile"+"-"+month1+"-"+day1
  write_matrix(var39,"48f18.9",opt_Z)

  opt_TSLB = True
  opt_TSLB@fout = pblmodel+"-TSLB-porfile"+"-"+month1+"-"+day1
  write_matrix(var40,"48f18.9",opt_TSLB)


  opt_U = True
  opt_U@fout = pblmodel+"-U-porfile"+"-"+month1+"-"+day1
  write_matrix(var44,"48f18.9",opt_U)

  opt_V = True
  opt_V@fout = pblmodel+"-V-porfile"+"-"+month1+"-"+day1
  write_matrix(var45,"48f18.9",opt_V)
end if

end do ;----cycle day end
end
