import xlrd
import numpy as np
import math
import pandas as pd

labeldate = ['jan08', '09', '10', '11', '12', '13', '14', '15', '16', '20', '21', '22', '23', '24']
ch = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
      'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z']
ddate1 = ['01-07', '01-08', '01-09', '01-10', '01-11', '01-12', '01-13', '01-14',
          '01-15', '01-19', '01-20', '01-21', '01-22', '01-23']  # data date
tieta = ['0108', '0109', '0110', '0111', '0112', '0113', '0114',
         '0115', '0120', '0121', '0122', '0123', '0124',]
tietaheight = [8, 15, 32, 47, 65, 80, 100, 120, 140, 160, 180, 200, 240, 280, 320]
twheight = np.array(tietaheight)


def esat(t):
    if t >= 0:
        a=7.5
        b=237.3
    else:
        a=9.5
        b=265.5

    e = 6.1078*100*10**(a*t/(b+t))    
    return e


def tver(t,rh,es,p):
    tv = (1+0.378*rh*es/p)*t
    return tv


def z_p(z0,z1,tv0,t,rh,p,es):
    print(z0,z1,tv0,t,rh,p,es)
    Rd = 287.05
    dz = z1-z0

    p1 = (p*(tv0+t-9.8*dz/Rd)+10*dz/(p-10*dz)*0.378*rh*es*t)/(tv0+t+9.8*dz/Rd)
    return p1
   


# read tower temp
tem_tower = []
rh_tower = []
for i in range(len(tieta)):
    tem_towerzs = np.loadtxt(open(r'D:\Dhy\chem\BJ-wrf\guance\beijingshuju\dhy10\24h_temp'+tieta[i]+'-10.txt', 'rb'))
    rh_towerzs = np.loadtxt(open(r'D:\Dhy\chem\BJ-wrf\guance\beijingshuju\dhy10\24h_rh'+tieta[i]+'-10.txt', 'rb'))
    if i < 1:
        tem_tower = tem_towerzs
        rh_tower = rh_towerzs
    else:
        tem_tower = np.concatenate((tem_tower, tem_towerzs), axis=0)
        rh_tower = np.concatenate((rh_tower, rh_towerzs), axis=0)
rh_tower = rh_tower/100

# read realdata1
wb = xlrd.open_workbook(filename='realdata1.xlsx')  # 读取Excel观测数据
realdata = wb.sheet_by_index(0)  # 通过索引获取表格

p0_obs_01_20_24 = TSK_obsx = realdata.col_values(127)[52:291:2]  # 第128列p0
p0_obs_01_08_15 = TSK_obsx = realdata.col_values(127)[17793:18176:2]
p0_list = p0_obs_01_08_15 + p0_obs_01_20_24  # '+' = list append
p0 = np.array(p0_list)

t0_obs_01_20_24 = TSK_obsx = realdata.col_values(7)[52:291:2]  # 第128列p0
t0_obs_01_08_15 = TSK_obsx = realdata.col_values(7)[17793:18176:2]
t0_list = t0_obs_01_08_15 + t0_obs_01_20_24  # '+' = list append
t0 = np.array(t0_list)

rh0_obs_01_20_24 = TSK_obsx = realdata.col_values(8)[52:291:2]  # 第128列p0
rh0_obs_01_08_15 = TSK_obsx = realdata.col_values(8)[17793:18176:2]
rh0_list = rh0_obs_01_08_15 + rh0_obs_01_20_24  # '+' = list append
rh0 = np.array(rh0_list)/100


print(len(tem_tower))
print(len(t0))
px = np.zeros([312,15])
for z in range(15):
    for i in range(312):
        if z == 0:
            px[i,z] = z_p(0.0,twheight[z],tv0=tver(t0[i]+273.15,rh0[i],es=esat(t0[i]),p=p0[i]*100),
                          t=tem_tower[i,z],rh=rh_tower[i,z],p=p0[i]*100,es=esat(tem_tower[i,z]-273.15))
        else:
            px[i, z] = z_p(twheight[z-1], twheight[z],
                           tv0=tver(tem_tower[i, z-1], rh_tower[i,z-1], es=esat(tem_tower[i, z-1]-273.15), p=px[i, z-1]),
                           t=tem_tower[i, z], rh=rh_tower[i, z], p=px[i, z-1], es=esat(tem_tower[i, z]-273.15))
px = px/100
np.savetxt('p_tower.spa', px, delimiter=' ', fmt='%.2f')