!
!    Copyright 2014, 2015, 2017, 2018, 2020 Guy Munhoven
!
!    This file is part of µXML.
!
!    µXML is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    µXML is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with µXML.  If not, see <https://www.gnu.org/licenses/>.
!


PROGRAM CONFIGURE_MODMXM

INTEGER, PARAMETER :: p_unit = 1

INTEGER :: i_iostat

CHARACTER(LEN=*), PARAMETER :: cfn_testfile = 'PleaseDeleteMe.txt'
CHARACTER(LEN=*), PARAMETER :: cfn_hfile    = 'modmxm_general.h'

CHARACTER(LEN=5)   :: c_write = 'Dummy'
CHARACTER(LEN=3)   :: c_read
CHARACTER(LEN=32)  :: c_tmp
CHARACTER(LEN=3)   :: c_fmt


!INTEGER, PARAMETER :: p_iostat_ok  =  0        ! All OK
!INTEGER, PARAMETER :: p_iostat_eor = -2        ! End Of Record encountered
!INTEGER, PARAMETER :: p_iostat_eof = -1        ! End of File encountered
!INTEGER, PARAMETER :: p_iostat_out = 5800      ! Trying even after EOF was

INTEGER :: i_iostat_ok
INTEGER :: i_iostat_eor
INTEGER :: i_iostat_eof
INTEGER :: i_iostat_out

OPEN(p_unit, FILE=cfn_testfile)
WRITE(p_unit, '(A)') c_write
CLOSE(p_unit)


OPEN(p_unit, FILE=cfn_testfile)

READ(p_unit, '(A)', IOSTAT=i_iostat_ok,  ADVANCE='NO', SIZE=i_size) c_read
!WRITE(*, '("Operation 1: read isize = ", I0)') i_size
READ(p_unit, '(A)', IOSTAT=i_iostat_eor, ADVANCE='NO', SIZE=i_size) c_read
!WRITE(*, '("Operation 2: read isize = ", I0)') i_size
READ(p_unit, '(A)', IOSTAT=i_iostat_eof, ADVANCE='NO', SIZE=i_size) c_read
!WRITE(*, '("Operation 3: read isize = ", I0)') i_size
READ(p_unit, '(A)', IOSTAT=i_iostat_out, ADVANCE='NO', SIZE=i_size) c_read
!WRITE(*, '("Operation 4: read isize = ", I0)') i_size

CLOSE(p_unit, STATUS="DELETE")

n_lenmax = 0
WRITE(c_tmp, '(I0)') i_iostat_ok
n_lenmax = MAX(n_lenmax, LEN_TRIM(c_tmp))
WRITE(c_tmp, '(I0)') i_iostat_eor
n_lenmax = MAX(n_lenmax, LEN_TRIM(c_tmp))
WRITE(c_tmp, '(I0)') i_iostat_eof
n_lenmax = MAX(n_lenmax, LEN_TRIM(c_tmp))
WRITE(c_tmp, '(I0)') i_iostat_out
n_lenmax = MAX(n_lenmax, LEN_TRIM(c_tmp))

WRITE(c_fmt, '("I", I0)') n_lenmax


WRITE(*, '("Detected IOSTAT values for the&
     & FORTRAN_COMPILER_NAME &
     &compiler")')
WRITE(*, '()')
WRITE(*, '("p_iostat_ok  = ", ' // c_fmt // ')') i_iostat_ok
WRITE(*, '("p_iostat_eor = ", ' // c_fmt // ')') i_iostat_eor
WRITE(*, '("p_iostat_eof = ", ' // c_fmt // ')') i_iostat_eof
WRITE(*, '("p_iostat_out = ", ' // c_fmt // ')') i_iostat_out
WRITE(*, '()')


WRITE(*, '("Writing these to """, A, """")') cfn_hfile


OPEN(p_unit, FILE=cfn_hfile)
WRITE(p_unit, '("! Detected IOSTAT values for the&
     & FORTRAN_COMPILER_NAME &
     &compiler")')
WRITE(p_unit, '()')
WRITE(p_unit, '("INTEGER, PARAMETER :: p_iostat_ok  = ", '// c_fmt // ', "  ! All OK")')                      i_iostat_ok
WRITE(p_unit, '("INTEGER, PARAMETER :: p_iostat_eor = ", '// c_fmt // ', "  ! End Of Record encountered")')  i_iostat_eor
WRITE(p_unit, '("INTEGER, PARAMETER :: p_iostat_eof = ", '// c_fmt // ', "  ! End Of File encountered")')    i_iostat_eof
WRITE(p_unit, '("INTEGER, PARAMETER :: p_iostat_out = ", '// c_fmt // ', "  ! Tried to read beyond EOF")')          i_iostat_out
WRITE(p_unit, '()')

CLOSE(p_unit)

WRITE(*, '("Done!")')

END
