;
;    Copyright 2007-2020 Guy Munhoven
;
;    This file is part of Medusa.
;
;    Medusa is free software: you can redistribute it and/or modify
;    it under the terms of the GNU Affero General Public License as
;    published by the Free Software Foundation, either version 3 of
;    the License, or (at your option) any later version.
;
;    Medusa is distributed in the hope that it will be useful, but
;    WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;    See the GNU Affero General Public License for more details.
;
;    You should have received a copy of the Affero GNU General Public
;    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
;


PRO WRITE_JEASIM_CSV, cfn_csvout_jeasim, $
  c_site, c_headerline1, c_headerline2, $
  wlon, wlat, wbdry_dbsl, wbdry_omega_calc, wbdry_tmpc, wbdry_sali, $
  pc_calc, bbdry_wtot, db_0, phi_0, phi_infty, phi_alpha, $
  wconc_o2, wconc_no3, wconc_hco3, wconc_co3, wconc_co2, wbdry_ph, wconc_ca, $
  wconc_nh4, wconc_so4, wconc_mn, wconc_fe, wconc_h2s, wconc_hs, wconc_boh3, wconc_boh4, $
  wflux_mno2, wflux_feoh3, wflux_orgc, $
  wbdry_frac_orgcf, ak_orgmf, wflux_calc, $
  an_calcdiss, ak_calcdiss, wflux_clay

debug = 1

OPENW, iunit, cfn_csvout_jeasim, /GET_LUN

PRINTF, iunit, c_site              ; WRITE ID of site to process

PRINTF, iunit, c_headerline1
PRINTF, iunit, c_headerline2

PRINTF, iunit, FORMAT='(A,2(",",F6.2),",",I4,",",F4.2,2(",",F5.2),",",F4.1,",",F5.3,",",F3.1,3(",",F6.3),24(",",F16.9))', $
  c_site, wlon, wlat,   $
  wbdry_dbsl, wbdry_omega_calc, wbdry_tmpc, $
  wbdry_sali, pc_calc, bbdry_wtot,     $
  db_0, phi_0, phi_infty, phi_alpha, $
  wconc_o2, wconc_no3, $
  wconc_hco3, wconc_co3, wconc_co2, wbdry_ph, $
  wconc_ca, wconc_nh4, wconc_so4, $
  wconc_mn, wconc_fe, wconc_h2s, wconc_hs, $
  wconc_boh3, wconc_boh4, $
  wflux_mno2, wflux_feoh3, wflux_orgc, $
  wbdry_frac_orgcf, ak_orgmf, wflux_calc, $
  an_calcdiss, ak_calcdiss, wflux_clay

CLOSE, iunit
FREE_LUN, iunit

RETURN

END
