;
;    Copyright 2007-2020 Guy Munhoven
;
;    This file is part of Medusa.
;
;    Medusa is free software: you can redistribute it and/or modify
;    it under the terms of the GNU Affero General Public License as
;    published by the Free Software Foundation, either version 3 of
;    the License, or (at your option) any later version.
;
;    Medusa is distributed in the hope that it will be useful, but
;    WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;    See the GNU Affero General Public License for more details.
;
;    You should have received a copy of the Affero GNU General Public
;    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
;


PRO READ_JSDATA, dn_data, station_id, d_o2, c_o2, e_o2, d_ph, c_ph, e_ph

known_stations = ['ID2',  'ID19', 'ID20', 'ID39', 'ID40', 'ID41', $
                  'ID48', 'ID49', 'ID50', 'ID57', 'ID58', 'ID59', 'ID120']

idx = WHERE(known_stations EQ station_id, count)

IF (count EQ 0) THEN BEGIN

  d_o2 = [-1D36]
  c_o2 = [-1D36]
  u_o2 = [-1D36]
  d_ph = [-1D36]
  c_ph = [-1D36]
  u_ph = [-1D36]

  RETURN

ENDIF

IF NOT KEYWORD_SET(dn_data) THEN dn_data='./'

fn_o2 = 'O2-' + station_id + '.csv'
fn_ph = 'pH-' + station_id + '.csv'

oneline = DBLARR(3)

OPENR, iunit, dn_data + fn_o2, /GET_LUN

READF, iunit, nvar

d_o2 = DBLARR(nvar)
c_o2 = DBLARR(nvar)
e_o2 = DBLARR(nvar)

FOR i = 0, nvar - 1 DO BEGIN

  READF, iunit, oneline

  d_o2[i] = oneline[0]
  c_o2[i] = oneline[1]

  IF (oneline[2] EQ 0D0) THEN $
    e_o2[i] = MAX([c_o2[i]*0.01D0, 1.0D0]) $
  ELSE e_o2[i] = oneline[2]

ENDFOR

CLOSE, iunit
FREE_LUN, iunit


OPENR, iunit, dn_data + fn_ph, /GET_LUN

READF, iunit, nvar

d_ph = DBLARR(nvar)
c_ph = DBLARR(nvar)
e_ph = DBLARR(nvar)

FOR i = 0, nvar - 1 DO BEGIN

  READF, iunit, oneline

  d_ph[i] = oneline[0]
  c_ph[i] = oneline[1]

  IF (oneline[2] EQ 0D0) THEN $
    e_ph[i] = 0.01D0 $
  ELSE e_ph[i] = oneline[2]

ENDFOR

CLOSE, iunit
FREE_LUN, iunit

END
