;
;    Copyright 2007-2020 Guy Munhoven
;
;    This file is part of Medusa.
;
;    Medusa is free software: you can redistribute it and/or modify
;    it under the terms of the GNU Affero General Public License as
;    published by the Free Software Foundation, either version 3 of
;    the License, or (at your option) any later version.
;
;    Medusa is distributed in the hope that it will be useful, but
;    WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;    See the GNU Affero General Public License for more details.
;
;    You should have received a copy of the Affero GNU General Public
;    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
;


PRO READ_JEASIM_CSV, cfn_csvin_jeasim, $
  c_site, c_headerline1, c_headerline2, $
  wlon, wlat, wbdry_dbsl, wbdry_omega_calc, wbdry_tmpc, wbdry_sali, $
  pc_calc, bbdry_wtot, db_0, phi_0, phi_infty, phi_alpha, $
  wconc_o2, wconc_no3, wconc_hco3, wconc_co3, wconc_co2, wbdry_ph, wconc_ca, $
  wconc_nh4, wconc_so4, wconc_mn, wconc_fe, wconc_h2s, wconc_hs, wconc_boh3, wconc_boh4, $
  wflux_mno2, wflux_feoh3, wflux_orgc, $
  wbdry_frac_orgcf, ak_orgmf, wflux_calc, $
  an_calcdiss, ak_calcdiss, wflux_clay

ON_ERROR, 2

debug = 1

OPENR, iunit, cfn_csvin_jeasim, /GET_LUN

c_fullline = ''
READF, iunit, FORMAT='(A)', c_fullline            ; Read ID of site to process

n = STRLEN(c_fullline)
idx0 = STRPOS(c_fullline, '"')
idx1 = STRPOS(STRMID(c_fullline, idx0+1, n-idx0-1), '"') + idx0 + 1
c_site = STRMID(c_fullline, idx0, idx1-idx0+1)

c_headerline1 = ''
c_headerline2 = ''
READF, iunit, FORMAT='(A)', c_headerline1
READF, iunit, FORMAT='(A)', c_headerline2

                                    ; Search for the line with the
                                    ; data for the selected site
IF debug EQ 1 THEN $
  PRINT, 'Searching for site ' + STRTRIM(c_site)

eof_reached = 1
WHILE NOT EOF(iunit) DO BEGIN

  READF, iunit, FORMAT='(A)', c_fullline

  n = STRLEN(c_fullline)
  idx0 = STRPOS(c_fullline, '"')
  idx1 = STRPOS(STRMID(c_fullline, idx0+1, n-idx0-1), '"') + idx0 + 1
  c_line_site = STRMID(c_fullline, idx0, idx1-idx0+1)

  IF STRCOMPRESS(c_line_site, /REM) EQ STRCOMPRESS(c_site, /REM) THEN BEGIN

    IF (debug EQ 1) THEN $
      PRINT, ' found line for site ' + STRCOMPRESS(c_site, /REM)
      eof_reached = 0
    BREAK

  ENDIF

ENDWHILE


IF eof_reached EQ 1 THEN BEGIN
  MESSAGE, 'Site ' + STRCOMPRESS(c_site, /REM) + ' not found - aborting.'
ENDIF


wlon = 0D0
wlat = 0D0

wbdry_dbsl = 0D0
wbdry_omega_calc = 0D0
wbdry_tmpc = 0D0
wbdry_sali = 0D0
pc_calc = 0D0

bbdry_wtot = 0D0

db_0 = 0D0
phi_0 = 0D0
phi_infty = 0D0
phi_alpha = 0D0

wconc_o2 = 0D0
wconc_no3 = 0D0
wconc_hco3 = 0D0
wconc_co3 = 0D0
wconc_co2 = 0D0
wbdry_ph = 0D0
wconc_ca = 0D0
wconc_nh4 = 0D0
wconc_so4 = 0D0
wconc_mn = 0D0
wconc_fe = 0D0
wconc_h2s = 0D0
wconc_hs = 0D0
wconc_boh3 = 0D0
wconc_boh4 = 0D0
wflux_mno2 = 0D0
wflux_feoh3 = 0D0
wflux_orgc = 0D0
wbdry_frac_orgcf = 0D0
ak_orgmf = 0D0
wflux_calc = 0D0
an_calcdiss = 0D0
ak_calcdiss = 0D0
wflux_clay = 0D0


READS, STRMID(c_fullline, idx1+2, n-idx1-2), wlon, wlat,   $
                          wbdry_dbsl, wbdry_omega_calc, wbdry_tmpc, $
                          wbdry_sali, pc_calc, bbdry_wtot,     $
                          db_0, phi_0, phi_infty, phi_alpha, $
                          wconc_o2, wconc_no3, $
                          wconc_hco3, wconc_co3, wconc_co2, wbdry_ph, $
                          wconc_ca, wconc_nh4, wconc_so4, $
                          wconc_mn, wconc_fe, wconc_h2s, wconc_hs, $
                          wconc_boh3, wconc_boh4, $
                          wflux_mno2, wflux_feoh3, wflux_orgc, $
                          wbdry_frac_orgcf, ak_orgmf, wflux_calc, $
                          an_calcdiss, ak_calcdiss, wflux_clay

IF debug EQ 1 THEN BEGIN
  PRINT,  'bbdry_wtot = ', bbdry_wtot*1D-2 ; 1D-2 : cm/yr -> m/yr
  PRINT,  'db_0 = ', db_0 * 1D-4  ; 1D-4 : cm2/yr -> m2/yr
  PRINT,  'phi_0 = ', phi_0
  PRINT,  'phi_infty = ', phi_infty
  PRINT,  'phi_scale = ', 1D-2/ABS(phi_alpha) ; 1D-2 : cm -> m
  PRINT,  'wflux_orgc = ', wflux_orgc
  PRINT,  'ak_orgmf = ', ak_orgmf
  PRINT,  'wbdry_frac_orgcf = ', wbdry_frac_orgcf
  PRINT,  'an_calc = ', an_calcdiss
  PRINT,  'ak_calc = ', ak_calcdiss
  PRINT,  'wflux_clay = ', wflux_clay
ENDIF

CLOSE, iunit
FREE_LUN, iunit

RETURN

END
