;
;    Copyright 2007-2020 Guy Munhoven
;
;    This file is part of Medusa.
;
;    Medusa is free software: you can redistribute it and/or modify
;    it under the terms of the GNU Affero General Public License as
;    published by the Free Software Foundation, either version 3 of
;    the License, or (at your option) any later version.
;
;    Medusa is distributed in the hope that it will be useful, but
;    WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;    See the GNU Affero General Public License for more details.
;
;    You should have received a copy of the Affero GNU General Public
;    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
;


FUNCTION MEDUSA_OXYGEN_FITFUN, x, p

; Jeasim parameter and forcing values that are not under MPFIT control
; ====================================================================

COMMON JEASIM_OTHER, i_vl, c_site, c_headerline1, c_headerline2, $
  wlon, wlat, wbdry_dbsl, wbdry_omega_calc, wbdry_tmpc, wbdry_sali, $
  pc_calc, bbdry_wtot, db_0, phi_0, phi_infty, phi_alpha, $
  wconc_o2, wconc_no3, wconc_hco3, wconc_co3, wconc_co2, wbdry_ph, wconc_ca, $
  wconc_nh4, wconc_so4, wconc_mn, wconc_fe, wconc_h2s, wconc_hs, wconc_boh3, wconc_boh4, $
  wflux_mno2, wflux_feoh3, $
  wflux_calc, $
  an_calcdiss, ak_calcdiss

; Please adapt the names of executables below if necessary:
IF i_vl EQ 1 THEN BEGIN
  ; here the "volumeless solids" executable (compiled with -DSOLIDS_VOLUMELESS)
  cmd_medusa_exe = './medusa_jeasim_vl.0_321_0'
ENDIF ELSE BEGIN
  ; here the "normal solids" executable (compiled without that option)
  cmd_medusa_exe = './medusa_jeasim.0_321_0'
ENDELSE


; plug P values into the relevant extra variables
; ===============================================

wflux_orgc       = p(0)
wbdry_frac_orgcf = p(1)
ak_orgmf         = p(2)
wflux_clay       = p(3)


; Use WRITE_JEASIM_CSV to create new jeasim_adj.csv
; =================================================
WRITE_JEASIM_CSV, 'jeasim_adj.csv', $
  c_site, c_headerline1, c_headerline2, $
  wlon, wlat, wbdry_dbsl, wbdry_omega_calc, wbdry_tmpc, wbdry_sali, $
  pc_calc, bbdry_wtot, db_0, phi_0, phi_infty, phi_alpha, $
  wconc_o2, wconc_no3, wconc_hco3, wconc_co3, wconc_co2, wbdry_ph, wconc_ca, $
  wconc_nh4, wconc_so4, wconc_mn, wconc_fe, wconc_h2s, wconc_hs, wconc_boh3, wconc_boh4, $
  wflux_mno2, wflux_feoh3, wflux_orgc, $
  wbdry_frac_orgcf, ak_orgmf, wflux_calc, $
  an_calcdiss, ak_calcdiss, wflux_clay


; run Medusa
; ==========
; Make sure beforehand that cfn_csvin_jeasim is set
; to 'jeasim_adj.csv' in medusa_jeasim_files.nml

SPAWN, cmd_medusa_exe


;; Interrupt the program to allow for inspection of the results
;; ============================================================
;PRINT, FORMAT = '(A, $)', 'Continue ? '
;c = ''
;READ, c


; Load results
; ============

fn_reaclay = 'medusa_reaclay.nc'
fn_flx     = 'medusa_flx.nc'

; xgeom_dbswi, xconc_o2 from medusa_reaclay.nc
; ---------------------

id = NCDF_OPEN(fn_reaclay, /NOWRITE)

NCDF_VARGET, id, NCDF_VARID(id, 'xgeom_dbswi'),   dbswi
NCDF_VARGET, id, NCDF_VARID(id, 'xconc_o2'),      o2

NCDF_CLOSE, id

; xw from medusa_flx.nc
; --

id = NCDF_OPEN(fn_flx, /NOWRITE)

NCDF_VARGET, id, NCDF_VARID(id, 'xgeom_dbswi'),   dbswi_vtx
NCDF_VARGET, id, NCDF_VARID(id, 'xw_tot'),        xw_tot

NCDF_CLOSE, id


; interpolate results onto X values
; ---------------------------------

n = N_ELEMENTS(x)

o2_res = INTERPOL(o2, dbswi, x(0:n-2))


; take deepest available xw_tot value for xw
; ------------------------------------------

w_res = xw_tot(N_ELEMENTS(xw_tot)-1)


; Done
; ====

RETURN, [o2_res, w_res]

END
