;
;    Copyright 2007-2020 Guy Munhoven
;
;    This file is part of Medusa.
;
;    Medusa is free software: you can redistribute it and/or modify
;    it under the terms of the GNU Affero General Public License as
;    published by the Free Software Foundation, either version 3 of
;    the License, or (at your option) any later version.
;
;    Medusa is distributed in the hope that it will be useful, but
;    WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;    See the GNU Affero General Public License for more details.
;
;    You should have received a copy of the Affero GNU General Public
;    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
;


; Jeasim par values not under MPFIT control
; =========================================

COMMON JEASIM_OTHER, i_vl, c_site, c_headerline1, c_headerline2, $
  wlon, wlat, wbdry_dbsl, wbdry_omega_calc, wbdry_tmpc, wbdry_sali, $
  pc_calc, bbdry_wtot, db_0, phi_0, phi_infty, phi_alpha, $
  wconc_o2, wconc_no3, wconc_hco3, wconc_co3, wconc_co2, wbdry_ph, wconc_ca, $
  wconc_nh4, wconc_so4, wconc_mn, wconc_fe, wconc_h2s, wconc_hs, wconc_boh3, wconc_boh4, $
  wflux_mno2, wflux_feoh3, $
  wflux_calc, $
  an_calcdiss, ak_calcdiss


; Jeasim other basic parameters
; =============================


cfn_csvin_jeasim = 'jeasim_ini0.csv'

i_vl = 1 ; 1: volume_less; other: normal



; Load jeasim parameter data
; ==========================

READ_JEASIM_CSV, cfn_csvin_jeasim, $
  c_site, c_headerline1, c_headerline2, $
  wlon, wlat, wbdry_dbsl, wbdry_omega_calc, wbdry_tmpc, wbdry_sali, $
  pc_calc, bbdry_wtot, db_0, phi_0, phi_infty, phi_alpha, $
  wconc_o2, wconc_no3, wconc_hco3, wconc_co3, wconc_co2, wbdry_ph, wconc_ca, $
  wconc_nh4, wconc_so4, wconc_mn, wconc_fe, wconc_h2s, wconc_hs, wconc_boh3, wconc_boh4, $
  wflux_mno2, wflux_feoh3, wflux_orgc, $
  wbdry_frac_orgcf, ak_orgmf, wflux_calc, $
  an_calcdiss, ak_calcdiss, wflux_clay

; Set calcite flux to zero for this fit
; -------------------------------------
wflux_calc = 0D0
ak_calcdiss = 0D0


; Set initial parameters
; ======================

start_p = DBLARR(4)

; wflux_orgc
; ----------
start_p(0) = wflux_orgc

; wbdry_frac_orgcf
; ----------------
start_p(1) = wbdry_frac_orgcf

; ak_orgmf
; --------
start_p(2) = ak_orgmf

; wflux_clay
; ----------
start_p(3) = wflux_clay


; load data
; =========

dn_data = '../../data/Jourabchi-etal.2008/'
n = STRLEN(c_site)
station_id = ''
READS, STRMID(c_site, 1, n-2), station_id

READ_JSDATA, dn_data, station_id, d_o2, c_o2, e_o2, d_ph, c_ph, e_ph


; append [bbdry_wtot], with 1/(1 permil) weight, pro forma located at the bottom

t    = [d_o2*1D-2, 82.0D-2]                 ; [m]
r    = [c_o2*1D-3, bbdry_wtot*1D-2]         ; [mol/m3, m/yr]
rerr = [e_o2*1D-3, bbdry_wtot*1D-2*.001D0]  ; [mol/m3, m/yr]


pi = replicate({fixed:0, limited:[0,0], limits:[0.D,0.D]},4)

; wflux_orgc
pi(0).fixed = 0
pi(0).limited(0) = 1
pi(0).limits(0) = 0D0
;pi(0).limited(1) = 1
;pi(0).limits(1) = 20D0

; wbdry_frac_orgcf
pi(1).fixed = 0
pi(1).limited(0) = 1
pi(1).limits(0) = 0D0
pi(1).limited(1) = 1
pi(1).limits(1) = 1D0

; ak_orgmf
pi(2).fixed = 0
pi(2).limited(0) = 1
pi(2).limits(0)  = 0D0
pi(2).limited(1) = 0
pi(2).limits(1)  = 10D0

; wflux_clay
;pi(3).fixed = 1
pi(3).limited(0) = 1
pi(3).limits(0) = 1D0


result_p = MPFITFUN('MEDUSA_OXYGEN_FITFUN', t, r, rerr, start_p, $
                    PARINFO=pi, STATUS = istatus, ERRMSG = c_err, $
                    COVAR = covar, PERROR = perror)

PRINT, 'STATUS = ', istatus
PRINT, 'ERRMSG = ', c_err
PRINT
PRINT, 'wflux_orgc:       from ', wflux_orgc,       ' to ', result_p(0)
PRINT, 'wbdry_frac_orgcf: from ', wbdry_frac_orgcf, ' to ', result_p(1)
PRINT, 'ak_orgmf:         from ', ak_orgmf,         ' to ', result_p(2)
PRINT, 'wflux_clay:       from ', wflux_clay,       ' to ', result_p(3)


r_min = MEDUSA_OXYGEN_FITFUN(t, result_p)
resrel = (r_min - r) / rerr


END
