!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef FN_THISFILE
#undef FN_THISFILE
#endif
#define FN_THISFILE "mod_uticommon.F90"
#ifndef __LINE__
#define __LINE__ 0
#endif
!=======================================================================
 MODULE MOD_UTICOMMON
!=======================================================================

IMPLICIT NONE


INTEGER, PARAMETER :: jp_lmaxpathname = 4095

INTEGER, PARAMETER :: jp_stderr = 0
INTEGER, PARAMETER :: jp_stdlog = 6
#ifdef DEBUG
INTEGER, PARAMETER :: jp_stddbg = 6
#endif

                                    ! Directory separator
                                    ! (please adjust to your OS).
CHARACTER(LEN=*), PARAMETER :: c_dirsep = '/'

CHARACTER(LEN=*), PARAMETER, PRIVATE :: cfn_thisfile = FN_THISFILE


CONTAINS


!-----------------------------------------------------------------------
 SUBROUTINE EXPAND_LIST(cl_ranges, il_items)
!-----------------------------------------------------------------------

IMPLICIT NONE

CHARACTER(LEN=*),   INTENT(IN) :: cl_ranges
INTEGER, DIMENSION(:), POINTER :: il_items

INTEGER :: i,  i_b,  i_e
INTEGER :: ii, ii_b, ii_e
INTEGER :: ib_item, ie_item
INTEGER :: n

CHARACTER(LEN=LEN(cl_ranges)):: cl_ranges_wk

INTEGER, DIMENSION(:), POINTER :: i_begin, ii_begin
INTEGER, DIMENSION(:), POINTER :: n_len, nn_len
INTEGER :: n_items, i_item
INTEGER :: n_tokens


IF (LEN_TRIM(cl_ranges) == 0) THEN
  ALLOCATE(il_items(0))
  RETURN
ENDIF


#ifdef DEBUG
WRITE(jp_stddbg, '("Initially <", A, ">")') TRIM(cl_ranges)
#endif
! Sanitize cl_ranges
!  - remove all SPC
ii = 0
cl_ranges_wk = ''
DO i = 1, LEN_TRIM(cl_ranges)
  IF (cl_ranges(i:i) /= ' ') THEN
    ii = ii + 1
    cl_ranges_wk(ii:ii) = cl_ranges(i:i)
  ENDIF
ENDDO

#ifdef DEBUG
WRITE(jp_stddbg, '("Sanitized <", A, ">")') TRIM(cl_ranges_wk)
#endif

NULLIFY(i_begin)
NULLIFY(n_len)

CALL DELIMIT_STRING_TOKENS(cl_ranges_wk, ',', i_begin, n_len)

#ifdef DEBUG
WRITE(jp_stddbg, '("Delimitation:")')
WRITE(jp_stddbg, '("  i_begin = ")', ADVANCE="NO")
WRITE(jp_stddbg, *) i_begin
WRITE(jp_stddbg, '("  n_len   = ")', ADVANCE="NO")
WRITE(jp_stddbg, *) n_len
#endif


n_items = 0

IF (ASSOCIATED(i_begin)) THEN
  n_tokens = SIZE(i_begin)
ELSE
  n_tokens = 0
ENDIF

DO i = 1, n_tokens

  i_b = i_begin(i)
  i_e = i_begin(i) + n_len(i) - 1

# ifdef DEBUG
  WRITE(jp_stddbg, '("Analysing part (", I0, ":", I0,") = <", A, ">")') &
                                    i_b, i_e, cl_ranges_wk(i_b:i_e)
# endif

  IF ((cl_ranges_wk(i_b:i_b) == '-') .OR. (cl_ranges_wk(i_e:i_e) == '-')) THEN
    WRITE(jp_stderr, '("Error in list specification:")')
    WRITE(jp_stderr, '("range parts must not start or end with a ""-"":")')
    WRITE(jp_stderr, '("the part """, A, """ does, unfortunately.")') cl_ranges_wk(i_b:i_e)
    WRITE(jp_stderr, '("Aborting!")')
    CALL ABORT_EXECUTION()
  ENDIF

  NULLIFY(ii_begin)
  NULLIFY(nn_len)

  CALL DELIMIT_STRING_TOKENS(cl_ranges_wk(i_b:i_e), '-', ii_begin, nn_len)

  IF (.NOT. ASSOCIATED(ii_begin)) THEN

    WRITE(jp_stderr, '("Something is strange here:")')
    WRITE(jp_stderr, '("we should actually never get here -- aborting!")')
    CALL ABORT_EXECUTION()

  ELSE

    SELECT CASE(SIZE(ii_begin))
    CASE(1)
      n_items = n_items + 1
    CASE(2)
      ii_b = i_b + ii_begin(1) - 1
      ii_e = i_b + ii_begin(1) - 1 + nn_len(1) - 1
      READ(cl_ranges_wk(ii_b:ii_e), *) ib_item
      ii_b = i_b + ii_begin(2) - 1
      ii_e = i_b + ii_begin(2) - 1 + nn_len(2) - 1
      READ(cl_ranges_wk(ii_b:ii_e), *) ie_item

      IF (ie_item < ib_item) THEN
        WRITE(jp_stderr, '("Error in list specification:")')
        WRITE(jp_stderr, '("""", A, """ is not allowed.")')            &
                                    TRIM(cl_ranges_wk(i_b:i_e))
        WRITE(jp_stderr, '("interval start must be lower than ' //     &
                                    'interval end -- aborting!")')
        CALL ABORT_EXECUTION()
      ENDIF

      n_items = n_items + ie_item - ib_item + 1

    CASE(3:)
      WRITE(jp_stderr, '("Error in list specification:")')
      WRITE(jp_stderr, '("""", A, """ is not allowed -- aborting!")')  &
                                    TRIM(cl_ranges_wk(i_b:i_e))
      CALL ABORT_EXECUTION()
    END SELECT

  ENDIF

  DEALLOCATE(ii_begin)
  DEALLOCATE(nn_len)

ENDDO


ALLOCATE(il_items(n_items))

i_item = 0

DO i = 1, SIZE(i_begin)

  i_b = i_begin(i)
  i_e = i_begin(i) + n_len(i) - 1

  NULLIFY(ii_begin)
  NULLIFY(nn_len)

  CALL DELIMIT_STRING_TOKENS(cl_ranges_wk(i_b:i_e), '-', ii_begin, nn_len)


  SELECT CASE(SIZE(ii_begin))
  CASE(1)
    i_item = i_item + 1
    READ(cl_ranges_wk(i_b:i_e),*) ib_item
    il_items(i_item) = ib_item
  CASE(2)
    ii_b = i_b + ii_begin(1) - 1
    ii_e = i_b + ii_begin(1) - 1 + nn_len(1) - 1
    READ(cl_ranges_wk(ii_b:ii_e), *) ib_item
    ii_b = i_b + ii_begin(2) - 1
    ii_e = i_b + ii_begin(2) - 1 + nn_len(2) - 1
    READ(cl_ranges_wk(ii_b:ii_e), *) ie_item

    DO ii = 0, ie_item - ib_item
      i_item = i_item + 1
      il_items(i_item) = ib_item + ii
    ENDDO
  END SELECT

  DEALLOCATE(ii_begin)
  DEALLOCATE(nn_len)

ENDDO


NULLIFY(ii_begin)
NULLIFY(nn_len)

DEALLOCATE(i_begin)
DEALLOCATE(n_len)

NULLIFY(i_begin)
NULLIFY(n_len)


!-----------------------------------------------------------------------
 END SUBROUTINE EXPAND_LIST
!-----------------------------------------------------------------------


!-----------------------------------------------------------------------
 SUBROUTINE CONDENSE_LIST(il_items, cl_ranges)
!-----------------------------------------------------------------------

IMPLICIT NONE

CHARACTER(LEN=*), INTENT(OUT) :: cl_ranges
INTEGER, DIMENSION(:)         :: il_items

CHARACTER(LEN=6) :: c_tmp
INTEGER :: i,n
LOGICAL l_rangeopen
INTEGER :: item_prev

IF (SIZE(il_items) == 0) THEN
  cl_ranges = ''
  RETURN
ENDIF

cl_ranges = ''
n=0

item_prev = il_items(1)
WRITE(cl_ranges, '(I0)') item_prev
n = LEN_TRIM(cl_ranges)
l_rangeopen = .FALSE.
DO i = 2, SIZE(il_items)
  IF (il_items(i) == (item_prev+1)) THEN
    IF (.NOT. l_rangeopen) THEN
      n = n+1
      cl_ranges(n:n) = '-'
      l_rangeopen = .TRUE.
    ENDIF
  ELSE
    IF (l_rangeopen) THEN
      WRITE(c_tmp, '(I0)') item_prev
      cl_ranges = cl_ranges(1:n) // TRIM(c_tmp)
      n = LEN_TRIM(cl_ranges)
      l_rangeopen = .FALSE.
    ENDIF
    WRITE(c_tmp, '(",",I0)') il_items(i)
    cl_ranges = cl_ranges(1:n) // TRIM(c_tmp)
    n = LEN_TRIM(cl_ranges)
  ENDIF      
  item_prev = il_items(i)
ENDDO

IF (l_rangeopen) THEN
  WRITE(c_tmp, '(I0)') item_prev
  cl_ranges = cl_ranges(1:n) // TRIM(c_tmp)
  l_rangeopen=.FALSE.
ENDIF
      
RETURN

!-----------------------------------------------------------------------
 END SUBROUTINE CONDENSE_LIST
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
 SUBROUTINE DELIMIT_STRING_TOKENS(c_in, c_separators, i_begin, n_len)
!-----------------------------------------------------------------------

CHARACTER(LEN=*), INTENT(IN)   :: c_in
CHARACTER(LEN=*), INTENT(IN)   :: c_separators
INTEGER, DIMENSION(:), POINTER :: i_begin
INTEGER, DIMENSION(:), POINTER :: n_len


INTEGER, PARAMETER :: jp_stderr = 0
CHARACTER(LEN=LEN(c_in)) :: c_tmp

INTEGER :: i, ii, i1, i2, i3, n_words

IF(LEN_TRIM(c_separators) == 0) THEN
  WRITE(jp_stderr, '("[DELIMIT_STRING_TOKENS]: No separators provided -- aborting")')
  CALL ABORT_EXECUTION()
ENDIF
    
c_tmp = ' '
n_words = 0

DO i = 1, LEN_TRIM(c_in)
  c_tmp(i:i) = ' '
  ii = INDEX(c_separators, c_in(i:i))
  IF(ii > 0) THEN
    IF (i > 1) THEN
      SELECT CASE(c_tmp(i-1:i-1))
      CASE(' ')
        CYCLE
      CASE('1')
        c_tmp(i-1:i-1) = '3'  ! one-letter word on previous character
        n_words = n_words + 1
      CASE('2')
        n_words = n_words + 1
      END SELECT
    ELSE
      CYCLE
    ENDIF  
  ELSE
    IF (i == 1) THEN
      c_tmp(i:i) = '1'
    ELSE
      SELECT CASE(c_tmp(i-1:i-1))
      CASE(' ')           ! SPC in pos=i-1
        c_tmp(i:i) = '1'  ! => new word starts at pos=i
      CASE('1')           ! new word has begun at pos=i-1
        c_tmp(i:i) = '2'  ! => provisionally end it at pos=i
      CASE('2')           ! word ended provisionally at pos=i-1
        c_tmp(i-1:i-1) = ' '
        c_tmp(i:i) = '2'  ! => report end to pos=i
      END SELECT
    ENDIF
  END IF
  IF (i == LEN_TRIM(c_in)) THEN
    SELECT CASE(c_tmp(i:i))
    CASE('1')
      c_tmp(i:i) = '3'  ! one-letter word on last character
      n_words = n_words + 1
    CASE('2')
      n_words = n_words + 1
    END SELECT
  ENDIF
ENDDO
    

IF(n_words > 0) THEN
  ALLOCATE(i_begin(n_words))
  ALLOCATE(n_len(n_words))

  ii = 1
  DO i = 1, n_words
    i1 = INDEX(c_tmp(ii:),'1')
    i3 = INDEX(c_tmp(ii:),'3')

    IF(i3 > 0) THEN
      IF(i1 > 0) THEN 
        IF(i1 < i3) THEN
          i_begin(i) = i1 + ii - 1
          i2 = INDEX(c_tmp(ii:),'2')
          n_len(i) = i2 - i1 + 1
          ii = ii + i2
        ELSE
          i_begin(i) = i3 + ii - 1
          n_len(i) = 1
          ii = ii + i3
        ENDIF
      ELSE
        i_begin(i) = i3 + ii - 1
        n_len(i) = 1
        ii = ii + i3
      ENDIF
    ELSE
      i_begin(i) = i1 + ii - 1
      i2 = INDEX(c_tmp(ii:),'2')
      n_len(i) = i2 - i1 + 1
      ii = ii + i2
    ENDIF
  ENDDO

ELSE

  NULLIFY(i_begin)
  NULLIFY(n_len)

ENDIF

RETURN

!-----------------------------------------------------------------------
 END SUBROUTINE DELIMIT_STRING_TOKENS
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
 LOGICAL FUNCTION TESTDIR(cdn)
!-----------------------------------------------------------------------

IMPLICIT NONE

CHARACTER(LEN=*), INTENT(IN) :: cdn

                              ! Try to create a test file
OPEN(UNIT=1, FILE=TRIM(cdn)//'/ggrmbl_zxdghdsfljkg.txt', STATUS="NEW", ERR=1)
CLOSE(UNIT=1, STATUS="DELETE")
TESTDIR = .TRUE.
RETURN

1 CONTINUE
TESTDIR = .FALSE.
RETURN

!-----------------------------------------------------------------------
 END FUNCTION TESTDIR
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
 SUBROUTINE ABORT_EXECUTION
!-----------------------------------------------------------------------

IMPLICIT NONE

CLOSE(jp_stderr)
CLOSE(jp_stdlog)
#ifdef DEBUG
CLOSE(jp_stddbg)
#endif

#ifdef HAS_NO_ABORT
WRITE(jp_stderr,'()')
WRITE(jp_stderr,'(A)') '[ABORT_EXECUTION] Aborting by STOP!'
STOP
#else
CALL ABORT()
#endif


!-----------------------------------------------------------------------
 END SUBROUTINE ABORT_EXECUTION
!-----------------------------------------------------------------------



!=======================================================================
 END MODULE MOD_UTICOMMON
!=======================================================================


