pro circugraph, datfilename, DIR=dirname, LINES=linestoskip
if not keyword_set(dirname) then dirname='../dat'
if not keyword_set(linestoskip) then linestoskip=11

resnames=['SNATL','SEATL','SANT','SEI-P','SNPAC', $
                  'TEATL',       'TEI-P',         $
                  'DATL', 'DANT', 'DI-P']

dummy=''
fluxesint=lonarr(10,10)
openr, unit, dirname+'/'+datfilename,/get_lun
for i=1,linestoskip do readf,unit,dummy
readf, unit, nvert, fvnet, fvmix
for i=1, nvert do begin
    readf, unit, n_from, n_to, netflux, mixflux
    fluxesint(n_from-1, n_to-1) = fvnet*netflux+fvmix*mixflux
    fluxesint(n_to-1, n_from-1) = fvmix*mixflux
endfor
readf, unit, nhorz, fhnet, fhmix
for i=1, nhorz do begin
    readf, unit, n_from, n_to, netflux, mixflux
    fluxesint(n_from-1, n_to-1) = fhnet*netflux+fhmix*mixflux
    fluxesint(n_to-1, n_from-1) = fhmix*mixflux
endfor
close,unit

fluxes=fluxesint/1000.
formats=strarr(10,10)
formats(*,*)='f3.1'
index=where(fluxes ge 10.0, n)
if n ne 0 then formats(index)='f4.1'
index=where(fluxes ge 100.0, n)
if n ne 0 then formats(index)='f5.1'


fluxin=fltarr(10)
fluxout=fltarr(10)
fluxio=fltarr(10)

for i=0,9 do fluxin(i)=total(fluxesint(*,i))/1000.
for i=0,9 do fluxout(i)=total(fluxesint(i,*))/1000.
for i=0,9 do fluxio(i)=(total(fluxesint(*,i))-total(fluxesint(i,*)))/1000.


openw,unit,'circugraph.tex'
printf,unit,'\documentclass[12pt,a4paper]{article}'
printf,unit,'\pagestyle{empty}'
printf,unit,'\usepackage{times}'
printf,unit,'\begin{document}'
printf,unit,'\begin{center}'
printf,unit,"{\Large \textbf{Water circulation summary for \texttt{"+datfilename+"}}\par}"
printf,unit,'\end{center}'
printf,unit,'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
printf,unit,'\begin{figure}[h]                                                           %'
printf,unit,'\mbox{}\hfill\mbox{\unitlength0.73mm                                        %'
printf,unit,'\begin{picture}(187,90)                                                     %'
printf,unit,'{\scriptsize                                                                %'
printf,unit,'%                                                                           %'
printf,unit,'%                                                                           %'
printf,unit,'% Bo{\^\i}tes                                                               %'
printf,unit,'%                                                                           %'
printf,unit,'\put(4,0){\framebox(66,45){DATL}}     % Atl prof                            %'
printf,unit,'\put(80,0){\framebox(20,45){DANT}}    % Antarct prof                        %'
printf,unit,'\put(110,0){\framebox(66,45){DI-P}}   % Indo-Pac prof                       %'
printf,unit,'\put(4,50){\framebox(16,30){SNATL}}   % Atl Nord superf                     %'
printf,unit,'\put(30,50){\framebox(40,15){TEATL}}  % Atl Equat thermocl                  %'
printf,unit,'\put(30,70){\framebox(40,10){SEATL}}  % Atl Equat superf                    %'
printf,unit,'\put(80,50){\framebox(20,30){SANT}}   % Antarct superf                      %'
printf,unit,'\put(110,50){\framebox(40,15){TEI-P}} % Indo-Pac Equat thermocl             %'
printf,unit,'\put(110,70){\framebox(40,10){SEI-P}} % Indo-Pac Equat superf               %'
printf,unit,'\put(160,50){\framebox(16,30){SNPAC}} % Pac Nord superf                     %'
printf,unit,'\put(3,-1){\dashbox(68,82){\ }}                                             %'
printf,unit,'\put(3,-2){\makebox(68,0)[t]{\large Atlantic}}                              %'
printf,unit,'\put(79,-1){\dashbox(22,82){\ }}                                            %'
printf,unit,'\put(79,-2){\makebox(22,0)[t]{\large Antarctic}}                            %'
printf,unit,'\put(109,-1){\dashbox(68,82){\ }}                                           %'
printf,unit,'\put(109,-2){\makebox(68,0)[t]{\large Indo-Pacific}}                        %'
printf,unit,'%                                                                           %'
printf,unit,'%                                                                           %'
printf,unit,'% Fleches                                                                   %'
printf,unit,'%                                                                           %'
printf,unit,'\put(68,23.5){\vector(1,0){14}}      % ATLp->ANTp      8 to  9              %'
printf,unit,fluxes(7,8),format="('\put(75,24.5){\makebox(0,0)[b]{',"+formats(7,8)+",'}}')"
printf,unit,'\put(82,21.5){\vector(-1,0){14}}     % ANTp->ATLp      9 to  8              %'
printf,unit,fluxes(8,7),format="('\put(75,20.5){\makebox(0,0)[t]{',"+formats(8,7)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(98,23.5){\vector(1,0){14}}      % ANTp->IPp       9 to 10              %'
printf,unit,fluxes(8,9),format="('\put(105,24.5){\makebox(0,0)[b]{',"+formats(8,9)+",'}}')"
printf,unit,'\put(112,21.5){\vector(-1,0){14}}    % IPp->ANTp      10 to  9              %'
printf,unit,fluxes(9,8),format="('\put(105,20.5){\makebox(0,0)[t]{',"+formats(9,8)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(68,58.5){\vector(1,0){14}}      % ATEth->ANTs     6 to  3              %'
printf,unit,fluxes(5,2),format="('\put(75,59.5){\makebox(0,0)[b]{',"+formats(5,2)+",'}}')"
printf,unit,'\put(82,56.5){\vector(-1,0){14}}     % ANTs->ATEth     3 to  6              %'
printf,unit,fluxes(2,5),format="('\put(75,55.5){\makebox(0,0)[t]{',"+formats(2,5)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(98,58.5){\vector(1,0){14}}      % ANTs->IPEth     3 to  7              %'
printf,unit,fluxes(2,6),format="('\put(105,59.5){\makebox(0,0)[b]{',"+formats(2,6)+",'}}')"
printf,unit,'\put(112,56.5){\vector(-1,0){14}}    % IPEth->ANTs     7 to  3              %'
printf,unit,fluxes(6,2),format="('\put(105,55.5){\makebox(0,0)[t]{',"+formats(6,2)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(68,76){\vector(1,0){14}}        % ATEs->ANTs      2 to  3              %'
printf,unit,fluxes(1,2),format="('\put(75,77){\makebox(0,0)[b]{',"+formats(1,2)+",'}}')"
printf,unit,'\put(82,74){\vector(-1,0){14}}       % ANTs->ATEs      3 to  2              %'
printf,unit,fluxes(2,1),format="('\put(75,73){\makebox(0,0)[t]{',"+formats(2,1)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(98,76){\vector(1,0){14}}        % ANTs->IPEs      3 to  4              %'
printf,unit,fluxes(2,3),format="('\put(105,77){\makebox(0,0)[b]{',"+formats(2,3)+",'}}')"
printf,unit,'\put(112,74){\vector(-1,0){14}}      % IPEs->ANTs      4 to  3              %'
printf,unit,fluxes(3,2),format="('\put(105,73){\makebox(0,0)[t]{',"+formats(3,2)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(18,76){\vector(1,0){14}}        % ATNs->ATEs      1 to  2              %'
printf,unit,fluxes(0,1),format="('\put(25,77){\makebox(0,0)[b]{',"+formats(0,1)+",'}}')"
printf,unit,'\put(32,74){\vector(-1,0){14}}       % ATEs->ATNs      2 to  1              %'
printf,unit,fluxes(1,0),format="('\put(25,73){\makebox(0,0)[t]{',"+formats(1,0)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(148,76){\vector(1,0){14}}       % IPEs->PANs      4 to  5              %'
printf,unit,fluxes(3,4),format="('\put(155,77){\makebox(0,0)[b]{',"+formats(3,4)+",'}}')"
printf,unit,'\put(162,74){\vector(-1,0){14}}      % PANs->IPEs      5 to  4              %'
printf,unit,fluxes(4,3),format="('\put(155,73){\makebox(0,0)[t]{',"+formats(4,3)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(174,76){\vector(1,0){10}}       % PANs->ATNs      5 to  1              %'
printf,unit,'\put(185.5,76){\circle{3}}                                                  %'
printf,unit,'\put(185.6,76.1){\makebox(0,0){a}}                                          %'
printf,unit,fluxes(4,0),format="('\put(180.5,77){\makebox(0,0)[b]{',"+formats(4,0)+",'}}')"
printf,unit,'\put(2,76){\vector(1,0){4}}                                                 %'
printf,unit,'\put(0.5,76){\circle{3}}                                                    %'
printf,unit,'\put(0.4,76.1){\makebox(0,0){a}}                                            %'
printf,unit,'%                                                                           %'
printf,unit,'\put(18,58.5){\vector(1,0){14}}      % ATNs->ATEth     1 to  6              %'
printf,unit,fluxes(0,5),format="('\put(25,59.5){\makebox(0,0)[b]{',"+formats(0,5)+",'}}')"
printf,unit,'\put(32,56.5){\vector(-1,0){14}}     % ATEth->ATNs     6 to  1              %'
printf,unit,fluxes(5,0),format="('\put(25,55.5){\makebox(0,0)[t]{',"+formats(5,0)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(148,58.5){\vector(1,0){14}}     % IPEth->PANs     7 to  5              %'
printf,unit,fluxes(6,4),format="('\put(155,59.5){\makebox(0,0)[b]{',"+formats(6,4)+",'}}')"
printf,unit,'\put(162,56.5){\vector(-1,0){14}}    % PANs->IPEth     5 to  7              %'
printf,unit,fluxes(4,6),format="('\put(155,55.5){\makebox(0,0)[t]{',"+formats(4,6)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(11,43){\vector(0,1){9}}         % ATLp->ATNs      8 to  1              %'
printf,unit,fluxes(7,0),format="('\put(10,47.5){\makebox(0,0)[r]{',"+formats(7,0)+",'}}')"
printf,unit,'\put(13,52){\vector(0,-1){9}}        % ATNs->ATLp      1 to  8              %'
printf,unit,fluxes(0,7),format="('\put(14,47.5){\makebox(0,0)[l]{',"+formats(0,7)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(49,43){\vector(0,1){9}}         % ATLp->ATEth     8 to  6              %'
printf,unit,fluxes(7,5),format="('\put(48,47.5){\makebox(0,0)[r]{',"+formats(8,9)+",'}}')"
printf,unit,'\put(51,52){\vector(0,-1){9}}        % ATEth->ATLp     6 to  8              %'
printf,unit,fluxes(5,7),format="('\put(52,47.5){\makebox(0,0)[l]{',"+formats(8,9)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(49,63){\vector(0,1){9}}         % ATEth->ATEs     6 to  2              %'
printf,unit,fluxes(5,1),format="('\put(48,67.5){\makebox(0,0)[r]{',"+formats(5,1)+",'}}')"
printf,unit,'\put(51,72){\vector(0,-1){9}}        % ATEs->ATEth     2 to  6              %'
printf,unit,fluxes(1,5),format="('\put(52,67.5){\makebox(0,0)[l]{',"+formats(1,5)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(89,43){\vector(0,1){9}}         % ANTp->ANTs      9 to  3              %'
printf,unit,fluxes(8,2),format="('\put(88,47.5){\makebox(0,0)[r]{',"+formats(8,2)+",'}}')"
printf,unit,'\put(91,52){\vector(0,-1){9}}        % ANTs->ANTp      3 to  9              %'
printf,unit,fluxes(2,8),format="('\put(92,47.5){\makebox(0,0)[l]{',"+formats(2,8)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(129,43){\vector(0,1){9}}        % IPp->IPEth     10 to  7              %'
printf,unit,fluxes(9,6),format="('\put(128,47.5){\makebox(0,0)[r]{',"+formats(9,6)+",'}}')"
printf,unit,'\put(131,52){\vector(0,-1){9}}       % IPEth->IPp      7 to 10              %'
printf,unit,fluxes(6,9),format="('\put(132,47.5){\makebox(0,0)[l]{',"+formats(6,9)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(129,63){\vector(0,1){9}}        % IPEth->IPEs     7 to  4              %'
printf,unit,fluxes(6,3),format="('\put(128,67.5){\makebox(0,0)[r]{',"+formats(6,3)+",'}}')"
printf,unit,'\put(131,72){\vector(0,-1){9}}       % IPEs->IPEth     4 to  7              %'
printf,unit,fluxes(3,6),format="('\put(132,67.5){\makebox(0,0)[l]{',"+formats(3,6)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'\put(167,43){\vector(0,1){9}}        % IPp->PANs      10 to  5              %'
printf,unit,fluxes(9,4),format="('\put(166,47.5){\makebox(0,0)[r]{',"+formats(9,4)+",'}}')"
printf,unit,'\put(169,52){\vector(0,-1){9}}       % PANs->IPp       5 to 10              %'
printf,unit,fluxes(4,9),format="('\put(170,47.5){\makebox(0,0)[l]{',"+formats(4,9)+",'}}')"
printf,unit,'%                                                                           %'
printf,unit,'}% \end scriptsize                                                          %'
printf,unit,'\end{picture}%                                                              %'
printf,unit,'}\hfill\mbox{}                                                              %'
printf,unit,'\vspace*{5mm}                                                               %'
printf,unit,'\end{figure}                                                                %'
printf,unit,'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
printf,unit,'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
printf,unit,'\begin{table}[h]'
printf,unit,'\begin{center}'
printf,unit,'\begin{tabular}{crrr}'
printf,unit,'\hline'
printf,unit,'Reservoir & \multicolumn{1}{c}{In} & \multicolumn{1}{c}{Out} & \multicolumn{1}{c}{In$-$Out} \\'
printf,unit,'\hline'
for i=0,9 do printf, unit, resnames(i), fluxin(i), fluxout(i), fluxio(i), format="(a6, 3(' & ', f7.3), '\\')"
printf,unit,'\hline'
printf,unit,'\end{tabular}'
printf,unit,'\end{center}'
printf,unit,'\end{table}'
printf,unit,'\end{document}'
close,unit
free_lun,unit

print, format="('Generating summary sheet',$)"
spawn, ['latex circugraph >& /dev/null']
print, ". Done."
print, 'Displaying summary sheet.'
print, "Type 'q' in Xdvi window to continue!"
spawn, ['xdvi circugraph >& /dev/null']

print,"Send to printer ('1' - yes, other - no) ?"
read, dummy
if dummy eq 1 then spawn, ['dvips circugraph']

return
end
