!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!DBL-safe
!=======================================================================
      SUBROUTINE PRIMIT(dxi, yi, n, sy)
!=======================================================================

      IMPLICIT NONE

!     Purpose:
!         Integrates the function y(x), defined by the vectors
!         dxi(1,...,n-1) and yi(0,...,n-1) such that
!         yi(i) = y|x=x_i, where x_i=x_{i-1}+dxi(i)) for i=1,..., n-1,
!         and x_0 arbitrary.
!
!     Result:
!         vector sy(i), i=0, ..., n-1 such that
!         sy(i) = Integral_{x=x_0}^{x=x_i} y(x) dx.
!
!     Uses trapezoidal rule to evaluate integral

      INTEGER n
      DOUBLE PRECISION dxi(1:n-1), yi(0:n-1), sy(0:n-1)


      INTEGER i


      sy(0) = 0.0D+00
                                    ! T_0_1 = dxi(1)*(yi(0)+yi(1))/2
                                    ! sy(1) = sy(0) + T_0_1

      sy(1) = dxi(1) * (yi(0)+yi(1))

      DO i = 2, n-2
                                    ! T_i-1_i = dxi(i)*(yi(i-1)+yi(i))/2
                                    ! sy(i) = sy(i-1) + T_i-1_i

        sy(i) = sy(i-1) + dxi(i)*(yi(i-1)+yi(i))

      ENDDO

                                    ! T_n-2_n-1 = dxi(n-1)*(yi(n-2)+yi(n-1))/2
                                    ! sy(n-1) = sy(n-2) + T_n-2_n-1 
      sy(n-1) = sy(n-2) + dxi(n-1)*(yi(n-2)+yi(n-1))

      sy(:) = sy(:)/2.0D+00

      RETURN

!=======================================================================
      END SUBROUTINE PRIMIT
!=======================================================================
