!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef DEBUG
#include <debug.h>
#endif

!=======================================================================
      MODULE MOD_TRANSPORT
!=======================================================================

!--------------
! Declarations
!--------------

      USE mod_basicdata_medusa
      USE mod_indexparam,           ONLY: nsolut
      USE mod_gridparam,            ONLY: idnt, idnb, idvs, idvb


      IMPLICIT NONE


      PRIVATE

      PUBLIC :: dcf_molion
      PUBLIC :: dcf_biotur, dcf_biointer
      !PUBLIC :: rcf_bioirr

      PUBLIC :: SETUP_TRANSPORT
      PUBLIC :: DYNVIS
      PUBLIC :: MDIFFC, BDIFFC, BIRRIC
      PUBLIC :: SWI_CONC,  DERIVFORM_SWI_CONC
      PUBLIC :: TRANSPORT, DERIVFORM_TRANSPORT
      PUBLIC :: NONLOCAL_TRANSPORT, DERIVFORM_NONLOCAL_TRANSPORT,
     &          NONLOCAL_TRANSPORT_TOTALS
      PUBLIC :: SPECIATE_WCFLX
      PUBLIC :: PROFIW, PROFIU



!-----------------------
! Variable declarations
!-----------------------

      DOUBLE PRECISION, SAVE, DIMENSION(nsolut)    ::     dcf_molion

      DOUBLE PRECISION, SAVE, DIMENSION(idvs:idvb) ::     dcf_biotur
      DOUBLE PRECISION, SAVE, DIMENSION(idvs:idvb) ::  dx_dcf_biotur
      DOUBLE PRECISION, SAVE, DIMENSION(idvs:idvb) ::     dcf_biointer
      DOUBLE PRECISION, SAVE, DIMENSION(idvs:idvb) ::  dx_dcf_biointer

      DOUBLE PRECISION, SAVE, DIMENSION(idnt:idnb) ::     rcf_bioirr


!- - - - - - - - - - - - - -  - - - - - - - -
! General (global) parameters and definitions
!- - - - - - - - - - - - - -- - - - - - - - -


      !- - - - - - - - - -
      ! Upwinding related
      !- - - - - - - - - -
                                    ! Numbering of the currently
                                    ! available upwinding options
                                    ! (DO NOT CHANGE!)
      INTEGER, PARAMETER :: jp_upw_full    = 0 ! full upwind (DEFAULT)
      INTEGER, PARAMETER :: jp_upw_expfit  = 1 ! exponential fitting


      !- - - - - - - - - - - -
      ! Biodiffusion related
      !- - - - - - - - - - - -
                                    ! Numbering of the currently
                                    ! available biodiffusion profile
                                    ! options (DO NOT CHANGE!)
      INTEGER, PARAMETER :: jp_bt_custom = -1 ! custom
      INTEGER, PARAMETER :: jp_bt_const  =  0 ! constant to Z, 0 below (DEFAULT)
      INTEGER, PARAMETER :: jp_bt_lin0z  =  1 ! linear decrease to zero in Z
      INTEGER, PARAMETER :: jp_bt_linxz  =  2 ! linear decrease
      INTEGER, PARAMETER :: jp_bt_quad0z =  3 ! quadratic decrease to zero in Z.
      INTEGER, PARAMETER :: jp_bt_expdec =  4 ! exponential decrease
                                                      ! D_B0*EXP(-z/jp_bt_expdec)
      INTEGER, PARAMETER :: jp_bt_gaussn =  5 ! Gaussian decrease
      INTEGER, PARAMETER :: jp_bt_erfc   =  6 ! Complementary Erro Function

                                    ! D_B0, the fundamental biodiffusion
                                    ! coefficient value
      DOUBLE PRECISION, PARAMETER
     &  :: dp_bt_dcf_0 = 0.15D+00*dp_cm2_p_yr

                                    ! Additional parameters and configuration
                                    ! (adjustable scales etc.) for specific
                                    ! D_B profiles.
      DOUBLE PRECISION, PARAMETER
     &  :: dp_bt_linxz_slope  = 1.0D+00
      DOUBLE PRECISION, PARAMETER
     &  :: dp_bt_expdec_scale = 0.10D+00    ! 10 cm
      DOUBLE PRECISION, PARAMETER
     &  :: dp_bt_gaussn_scale = 0.05D+00    !  5 cm

                                    ! with jselect_biodif_profile == 5 and
                                    ! da_bt_gaussn_scale == 5 cm:
                                    ! gives average of 0.15*dp_cm2_p_yr
      DOUBLE PRECISION, PARAMETER
     &  :: dp_bt_gaussn_db_0  = 0.34D+00*dp_cm2_p_yr


      DOUBLE PRECISION, PARAMETER
     &  :: dp_bt_erfc_halfd   = 0.20D+00    !  20 cm
      DOUBLE PRECISION, PARAMETER
     &  :: dp_bt_erfc_scale   = 0.04D+00    !  4 cm


      !- - - - - - - - - - - -
      ! Bioirrigation related
      !- - - - - - - - - - - -
                                    ! Numbering of the currently
                                    ! available bioirrigation profile
                                    ! options (DO NOT CHANGE!)
      INTEGER, PARAMETER :: jp_bi_custom = -1 ! custom
      INTEGER, PARAMETER :: jp_bi_none   =  0 ! No biorrigation
      INTEGER, PARAMETER :: jp_bi_expdec =  1 ! exponential decrease

                                    ! Additional parameters and configuration
                                    ! (adjustable scales etc.) for specific
                                    ! bioirrigation coefficient profiles.

                                    ! Van Cappellen and Wang (1996):
                                    !    alpha(z) = alpha_0*EXP(-z/alpha_1)
                                    ! with
                                    !  alpha_0 = 200 yr^-1
                                    !  alpha_1 = 0.28 cm!
      DOUBLE PRECISION, PARAMETER
     &  :: dp_bi_rcf_0        = 200.0D+00
      DOUBLE PRECISION, PARAMETER
     &  :: dp_bi_expdec_scale = 0.28D+00*dp_cm

                                    ! Alternatives:
                                    ! Katsev et al. (2007):
                                    !    alpha_irr(z) = alpha_irr^0*EXP(-z/tau_irr)
                                    ! with
                                    !  alpha_irr^0 = 240 yr^-1
                                    !  tau_irr     = 4 cm
!      DOUBLE PRECISION, PARAMETER
!     &  :: dp_bi_rcf_0        = 240.0D+00
!      DOUBLE PRECISION, PARAMETER
!     &  :: dp_bi_expdec_scale = 4.00D+00*dp_cm



      INTEGER, SAVE :: jselect_biodif_profile = jp_bt_const
      INTEGER, SAVE :: jselect_bioirr_profile = jp_bi_none
      INTEGER, SAVE :: jselect_upwinding      = jp_upw_full


      DOUBLE PRECISION, SAVE :: da_bt_dcf_0
      DOUBLE PRECISION, SAVE :: da_bt_linxz_slope
      DOUBLE PRECISION, SAVE :: da_bt_expdec_scale
      DOUBLE PRECISION, SAVE :: da_bt_gaussn_scale
      DOUBLE PRECISION, SAVE :: da_bt_erfc_halfd
      DOUBLE PRECISION, SAVE :: da_bt_erfc_scale

      DOUBLE PRECISION, SAVE :: da_bi_rcf_0
      DOUBLE PRECISION, SAVE :: da_bi_expdec_scale


#ifdef BIODIFFUSION_CUSTOM
#define BDIFFC_CUSTOM_DECLARATIONS
#include <bdiffc_custom.F>
#undef BDIFFC_CUSTOM_DECLARATIONS
#endif


#ifdef BIOIRRIGATION_CUSTOM
#define BIRRIC_CUSTOM_DECLARATIONS
#include <birric_custom.F>
#undef BIRRIC_CUSTOM_DECLARATIONS
#endif


      LOGICAL, SAVE :: l_setupdone = .FALSE.


      CONTAINS


!     SUBROUTINE SETUP_TRANSPORT
#include <transport/setup_transport.F>


!     DOUBLE PRECISION FUNCTION DYNVIS(d, tc, s)
#include <transport/dynvis.F>


!     SUBROUTINE MDIFFC(wdata)
#include <mdiffc.F>


!     SUBROUTINE BDIFFC(xzdn, xcompo, wconc, wfflx)
#include <transport/bdiffc.F>


#ifdef BIODIFFUSION_CUSTOM
!     SUBROUTINE BDIFFC_CUSTOM(xzdn, xcompo, wconc, wfflx)
!     SUBROUTINE BDIFFC_CUSTOM_SETUP(k_stage, iu_cfg)
#include <bdiffc_custom.F>
#endif


!     DOUBLE PRECISION FUNCTION DKAPPA_EXPONFIT(dmu)
#include <transport/dkappa_exponfit.F>


!     SUBROUTINE UPWIND_KAPPA_SOLIDS(adv, dfc, vxzdn, dkappa)
!     SUBROUTINE UPWIND_KAPPA_SOLUTES(adv, dfc, vxzdn, dkappa)
#include <transport/upwinding.F>


!     SUBROUTINE SWI_CONC(xnz, xnc, wconc, wfflx, xvw_tot, sconc)
#include <transport/swi_conc.F>


!     SUBROUTINE DERIVFORM_SWI_CONC(xnz, xnc, Deriv_sconc)
#include <transport/derivform_swi_conc.F>


!     SUBROUTINE TRANSPORT
!    &  (atime, xnz, inode, xnc, xvw_tot, xvu_tot, wconc, wfflx, yc,
!    &  flxval)
#include <transport/fluxes.F>


!     SUBROUTINE DERIVFORM_TRANSPORT
!    &  (atime, xzdn, tnode, xc, xvw_tot, xvu_tot,
!    &   Deriv_flxval)
#include <transport/df_fluxes.F>


!     SUBROUTINE SPECIATE_WCFLX(atime, xzdn, xc, xu, wconc, wcflx,
!    &      istatus)
#include <speciate_wcflx.F>


!     SUBROUTINE PROFIW(wfflx, xc, xzdn, xw, aw_bplus)
#include <transport/profiw.F>


!     SUBROUTINE PROFIU(xw, aw_bplus, xu)
#include <transport/profiu.F>


!     SUBROUTINE BIRRIC(xzdn, xc, wconc, wfflx)
#include <transport/birric.F>


#ifdef BIOIRRIGATION_CUSTOM
!     SUBROUTINE BIRRIC_CUSTOM(xzdn, xcompo, wconc, wfflx)
!     SUBROUTINE BIRRIC_CUSTOM_SETUP(k_stage, iu_cfg)
#include <birric_custom.F>
#endif


!     SUBROUTINE NONLOCAL_TRANSPORT
!    &  (krealm, xzdn, inode, xc, wconc, flxnonloc)
#include <transport/nonlocal_fluxes.F>


!     SUBROUTINE DERIVFORM_NONLOCAL_TRANSPORT
!    &  (krealm, xzdn, inode, xc, d_flxnonloc)
#include <transport/df_nonlocal_fluxes.F>


!     SUBROUTINE NONLOCAL_TRANSPORT_TOTALS
!    &  (xzdn, xc, wconc, flxnonloc_tot)
#include <transport/nonlocal_flux_totals.F>


!=======================================================================
      END MODULE MOD_TRANSPORT
!=======================================================================
