!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!DBL-safe
!=======================================================================
      MODULE MOD_SEAFLOOR_TEMP
!=======================================================================

      IMPLICIT NONE


      DOUBLE PRECISION, DIMENSION(:,:,:), ALLOCATABLE, SAVE ::
     &   solvsed_xc, solvsed_dx_xc

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   solvsed_ysolid
      
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   solvsed_bconc, solvsed_wcflx

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   solvsed_bfflx


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE SEAFLOOR_TEMP_SETUP(n_columns)
!-----------------------------------------------------------------------

      USE mod_indexparam, ONLY: ncompo, nsolut, nsolid
      USE mod_gridparam, ONLY: idnw, idnt, idnb


      IMPLICIT NONE

      INTEGER, INTENT(IN) :: n_columns


      ALLOCATE(solvsed_xc    (idnw:idnb, ncompo, n_columns))
      ALLOCATE(solvsed_dx_xc (idnw:idnb, ncompo, n_columns))

      ALLOCATE(solvsed_ysolid(           nsolid, n_columns))

      ALLOCATE(solvsed_bconc (           nsolut, n_columns))
      ALLOCATE(solvsed_wcflx (           nsolut, n_columns))

      ALLOCATE(solvsed_bfflx (           nsolid, n_columns))


!-----------------------------------------------------------------------
      END SUBROUTINE SEAFLOOR_TEMP_SETUP
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_SEAFLOOR_TEMP
!=======================================================================
