!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!===============================================================================
      MODULE MOD_SEAFLOOR_CENTRAL
!===============================================================================


      USE MOD_SEAFLOOR_WDATA


      IMPLICIT NONE


      PRIVATE

                                    ! General setup
                                    ! -------------

                                    ! We provide illegal initial values
                                    ! here to prevent illicit use

                                    ! - General data relevant to this
                                    !   particular instance of
                                    !   mod_seafloor_central only
      INTEGER, SAVE :: ngrid           = -1
      INTEGER, SAVE :: n_grid_seafloor = -1

      INTEGER, DIMENSION(:),   ALLOCATABLE, SAVE :: maskval_seafloor


#if (defined(MEDUSA_BASE2D) || defined(MEDUSA_BASE2DT2D))
#  ifdef MEDUSA_BASE2D
      INTEGER, SAVE :: nix             = -1
      INTEGER, SAVE :: njy             = -1


                                    ! Grid characteristics
                                    ! --------------------

                                    !  * allocations and initialisations:
                                    !    in SEAFLOOR_SETUP_COUPLED
                                    !     - COLUMN_IJ2N requires
                                    !       <icolumn_seafloor>
                                    !     - COLUMN_N2IJ requires
                                    !       <ix_seafloor> and <jy_seafloor>
                                    !     - COLUMN_N2XY requires
                                    !       <x_seafloor> and <y_seafloor>

      INTEGER, DIMENSION(:),    ALLOCATABLE, SAVE :: ix_seafloor
      INTEGER, DIMENSION(:),    ALLOCATABLE, SAVE :: jy_seafloor
      INTEGER, DIMENSION(:,:),  ALLOCATABLE, SAVE :: icolumn_seafloor
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE, SAVE :: x_seafloor
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE, SAVE :: y_seafloor

#  else

      INTEGER, SAVE :: nix             = -1
      INTEGER, SAVE :: njy             = -1
      INTEGER, SAVE :: nitx            = -1
      INTEGER, SAVE :: njty            = -1


                                    ! Grid characteristics
                                    ! --------------------

                                    !  * allocations and initialisations:
                                    !    in SEAFLOOR_SETUP_COUPLED
                                    !     - COLUMN_IJ_ITJT2N requires
                                    !       <icolumn_seafloor>
                                    !     - COLUMN_N2IJ_ITJT requires
                                    !       <ix_seafloor>, <jy_seafloor>
                                    !       <itx_seafloor> and <jty_seafloor>
                                    !     - COLUMN_N2XY requires
                                    !       <x_seafloor> and <y_seafloor>

      INTEGER, DIMENSION(:),    ALLOCATABLE, SAVE :: ix_seafloor
      INTEGER, DIMENSION(:),    ALLOCATABLE, SAVE :: jy_seafloor
      INTEGER, DIMENSION(:),    ALLOCATABLE, SAVE :: itx_seafloor
      INTEGER, DIMENSION(:),    ALLOCATABLE, SAVE :: jty_seafloor
      INTEGER, DIMENSION(:,:, :,:),
     &                          ALLOCATABLE, SAVE :: icolumn_seafloor
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE, SAVE :: x_seafloor
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE, SAVE :: y_seafloor
#  endif

#else

      INTEGER, SAVE :: nix             = -1


                                    ! Grid characteristics
                                    ! --------------------

                                    !  * allocations and initialisations:
                                    !    in SEAFLOOR_SETUP_COUPLED
                                    !     - COLUMN_I2N requires
                                    !       <icolumn_seafloor>
                                    !     - COLUMN_N2I requires
                                    !       <ix_seafloor>

      INTEGER, DIMENSION(:),    ALLOCATABLE, SAVE :: ix_seafloor
      INTEGER, DIMENSION(:),    ALLOCATABLE, SAVE :: icolumn_seafloor
#endif


                                    ! common variable declarations
! Geometries of columns
!----------------------

! Depth node distribution
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   reaclay_xzdn

! Depth vertex distribution
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   reaclay_xzdv

! Porosity distribution and porosity gradient
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   reaclay_xphi,  reaclay_xdphi,
     &   reaclay_xvphi, reaclay_xvdphi

! Porosity of the transition layers
      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE, SAVE ::
     &   tranlay_yphi


! Surface area
! ------------

      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE, SAVE ::
     &   seafloor_surf


! Geochemistry of columns
!------------------------

! * REACtion LAYer profiles (all conc)
      DOUBLE PRECISION, DIMENSION(:,:,:), ALLOCATABLE, SAVE ::
     &   reaclay_profiles

! * REACtion LAYer profiles (xwtot)
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   reaclay_xwtot

! * REACtion LAYer profiles (xutot)
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   reaclay_xutot

! * REACtion LAYer solutes' characteristic values
!   - bconc: bottom concentrations
!   - wcflx: Water-DBL/sediment interface solute (C) FLuXes
!   - wcflx_bi: Water-DBL/sediment interface solute (C) FLuXes,
!               part from bioirrigation
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   reaclay_bconc, reaclay_wcflx, reaclay_wcflx_bi

! * REACtion LAYer solids' characteristic values
!   - bfflx: Bottom exchange flux (burial  if bfflx>0;
!                                  erosion if bfflx<0 )
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   reaclay_bfflx

! * TRANsition LAYer solids contents
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   tranlay_solids


! Forcings
! --------

! * Top Depth below sea-level, temperature and salinity
!   and any other extra boundary data
      TYPE (WDATA_CONTAINER), DIMENSION(:), ALLOCATABLE, SAVE ::
     &   seafloor_wdata

! * Ocean/DBL-or-top-of-sediment Solute concentrations
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   seafloor_wsolutes

! * Top Solids' Fluxes
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   seafloor_wfflx


! Geochemical data
! ----------------

! * Geographically distributed Redfield ratios and OrgMatter_CNP molar masses

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   seafloor_omcnp_c, seafloor_omcnp_n, seafloor_omcnp_p,
     &   seafloor_omcnp_o, seafloor_omcnp_h, seafloor_omcnp_remin_o2

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   seafloor_omcnp_mol


                                    ! All is private here, except
                                    ! for the following:
      PUBLIC :: SEAFLOOR_SETUP,
     &          N_COLUMNS_USED,      COLUMN_N2MASKVAL,
     &          COLUMN_AREA4N,       SAVE_AREA4N,
     &          GET_BOUNDARY_CONDS,  SAVE_BOUNDARY_CONDS,
     &          GET_BOUNDARY_FLUXES, SAVE_BOUNDARY_FLUXES,
     &          GET_COLUMN,          SAVE_COLUMN,
     &          GET_MATERIALCHARAS,  SAVE_MATERIALCHARAS,
     &          GET_MILIEUCHARAS,    SAVE_MILIEUCHARAS


#if (defined(MEDUSA_BASE2D) || defined(MEDUSA_BASE2DT2D))
#  ifdef MEDUSA_BASE2D
                                    ! If the sediment columns are
                                    ! distributed on a 2D grid, the
                                    ! following are also public:
      PUBLIC :: IJ_COLUMNS_USED, COLUMN_N2IJ, COLUMN_IJ2N, COLUMN_N2XY
#  else
                                    ! If the sediment columns are
                                    ! distributed on a 2DT2D grid, the
                                    ! following are also public:
      PUBLIC :: IJ_ITJT_COLUMNS_USED, COLUMN_N2IJ_ITJT,
     &                              COLUMN_IJ_ITJT2N, COLUMN_N2XY
#  endif
#else
      PUBLIC :: I_COLUMNS_USED, COLUMN_N2I, COLUMN_I2N
#endif

! End of variable declarations

      CONTAINS


                                   ! Common interfacing routines
                                   ! ---------------------------

!     SUBROUTINE N_COLUMNS_USED(n_columns)
#include <base_common/n_columns_used.F>

!     SUBROUTINE COLUMN_N2MASKVAL(i_column, iflag, mval)
#include <base_common/column_n2maskval.F>


!     SUBROUTINE GET_COLUMN(i_column, iflag,
!    &           xzdn, xphi, xdphi, yphi, xc, ysolid, xw, xu)
#include <base_common/get_column.F>

!     SUBROUTINE SAVE_COLUMN(i_column, iflag,
!    &           xzdn, xphi, xdphi, yphi, xc, ysolid, xw, xu)
#include <base_common/save_column.F>


!     SUBROUTINE GET_BOUNDARY_CONDS(i_column, gbcflag,
!    &               wdbsl, wtmpdc, wsalin, wconc, wfflx)
#include <base_common/get_boundary_conds.F>

!     SUBROUTINE SAVE_BOUNDARY_CONDS(i_column, gbcflag,
!    &               wdbsl, wtmpdc, wsalin, wconc, wfflx)
#include <base_common/save_boundary_conds.F>


!     SUBROUTINE GET_BOUNDARY_FLUXES(i_column, gbfflag,
!    &           bconc, wcflx, wcflx_bi, bfflx)
#include <base_common/get_boundary_fluxes.F>

!     SUBROUTINE SAVE_BOUNDARY_FLUXES(i_column, iflag,
!    &           bconc, wcflx, wcflx_bi, bfflx)
#include <base_common/save_boundary_fluxes.F>


!     SUBROUTINE COLUMN_AREA4N(i_column, iflag, sfc_area)
#include <base_common/column_area4n.F>

!     SUBROUTINE SAVE_AREA4N(i_column, iflag, sfc_area)
#include <base_common/save_area4n.F>


!     SUBROUTINE GET_MILIEUCHARAS(i_column, iflag)
#include <base_common/get_milieucharas.F>

!     SUBROUTINE SAVE_MILIEUCHARAS(i_column, iflag)
#include <base_common/save_milieucharas.F>

                                    ! Link to the adequate version
                                    ! of get_materialcharas.F from var
                                    ! if necessary (e.g., dummy)
!     SUBROUTINE GET_MATERIALCHARAS(i_column, iflag)
#include <get_materialcharas.F>

                                    ! Link to the adequate version
                                    ! of save_materialcharas.F from var
                                    ! if necessary (e.g., dummy)
!     SUBROUTINE SAVE_MATERIALCHARAS(i_column, iflag)
#include <save_materialcharas.F>


#if (defined(MEDUSA_BASE2D) || defined(MEDUSA_BASE2DT2D))
#  ifdef MEDUSA_BASE2D
                                    ! 2D interfacing routines
                                    ! -----------------------

!     SUBROUTINE IJ_COLUMNS_USED(nix_columns, njy_columns)
#    include <base_2D/ij_columns_used.F>

!     SUBROUTINE COLUMN_N2IJ(i_column, iflag, ix, jy)
#    include <base_2D/column_n2ij.F>

!     SUBROUTINE COLUMN_N2XY(i_column, iflag, x, y)
#    include <base_2D/column_n2xy.F>

!     SUBROUTINE COLUMN_IJ2N(ix, jy, iflag, i_column)
#    include <base_2D/column_ij2n.F>


#  else
                                    ! 2DT2D interfacing routines
                                    ! --------------------------

!     SUBROUTINE IJ_ITJT_COLUMNS_USED(nix_columns, njy_columns,
!                                   nitx_columns, njty_columns)
#  include <base_2DT2D/ij_itjt_columns_used.F>

!     SUBROUTINE COLUMN_N2IJ(i_column, iflag, ix, jy, itx, jty)
#  include <base_2DT2D/column_n2ij_itjt.F>

!     SUBROUTINE COLUMN_N2XY(i_column, iflag, x, y)
#  include <base_2D/column_n2xy.F>

!     SUBROUTINE COLUMN_IJ_ITJT2N(ix, jy, itx, jty, iflag, i_column)
#  include <base_2DT2D/column_ij_itjt2n.F>
#  endif

#else
                                    ! 1D interfacing routines
                                    ! -----------------------

!     SUBROUTINE I_COLUMNS_USED(nix_columns)
#  include <base_1D/i_columns_used.F>

!     SUBROUTINE COLUMN_N2I(i_column, iflag, ix)
#  include <base_1D/column_n2i.F>

!     SUBROUTINE COLUMN_I2N(ix, iflag, i_column)
#  include <base_1D/column_i2n.F>

#endif



#if (defined(MEDUSA_BASE2DT2D) || defined(MEDUSA_BASE2D))
#  ifdef MEDUSA_BASE2D
                                    ! 2D seafloor setup subroutine
                                    ! ----------------------------
#    include <seafloor_setup_2D.F>
#  else
                                    ! 2DT2D seafloor setup subroutine
                                    ! -------------------------------
#    include <seafloor_setup_2DT2D.F>
#  endif
#else
                                    ! 1D seafloor setup subroutine
                                    ! ----------------------------
#  include <seafloor_setup_1D.F>
#endif


!===============================================================================
      END MODULE MOD_SEAFLOOR_CENTRAL
!===============================================================================
