!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      MODULE mod_medinterfaces
!=======================================================================

      IMPLICIT NONE


      INTERFACE
        SUBROUTINE PRIMIT(dxi, yi, n, sy)
        INTEGER n
        DOUBLE PRECISION dxi(1:n-1), yi(0:n-1), sy(0:n-1)
        END SUBROUTINE PRIMIT
      END INTERFACE


      INTERFACE
        SUBROUTINE STORE_NC_AUX(filename, title_string)
          IMPLICIT NONE
          CHARACTER(LEN=*) :: filename, title_string
          INTENT(IN)       :: filename, title_string
          OPTIONAL :: title_string
        END SUBROUTINE STORE_NC_AUX
      END INTERFACE


      INTERFACE
        SUBROUTINE MASS_BALANCES(total_xm_0, total_xm_1,
     &                         topflx_xm_01, botflx_xm_01,
     &                         total_rea_xm_01, n_columns)

        USE mod_indexparam
        IMPLICIT NONE
        INTEGER, INTENT(IN) :: n_columns
        DOUBLE PRECISION, DIMENSION(ncompo,n_columns), INTENT(IN) ::
     &    total_xm_0,      ! total masses at t=0
     &    total_xm_1,      ! total masses at t=1
     &    topflx_xm_01,    ! total top (input) flux during [t_0,t_1]
     &    botflx_xm_01,    ! total bottom (output) flux during [t_0,t_1]
     &    total_rea_xm_01  ! total reaction rate during [t_0,t_1]

        END SUBROUTINE MASS_BALANCES
      END INTERFACE


      INTERFACE
        SUBROUTINE ImplicitTimeStep(
     I            xzdn,
     I            wdbsl, wtmpdc, wsalin,
     I            atime, datime, wconc, wfflx,
     X            xco, ysolido, xwo, xuo,
     X            xcn, ysolidn, xwn, xun,
     O            bconc, wcflx, bfflx, itsflag)
        USE mod_gridparam, ONLY: idnw, idnt, idnb
        USE mod_indexparam, ONLY: nsolut, nsolid, ncompo
        IMPLICIT NONE
        DOUBLE PRECISION, DIMENSION(idnw:idnb) :: xzdn
        DOUBLE PRECISION :: wdbsl, wtmpdc, wsalin
        DOUBLE PRECISION, DIMENSION (nsolut) :: wconc
        DOUBLE PRECISION, DIMENSION (nsolid) :: wfflx
        DOUBLE PRECISION  :: atime, datime
        DOUBLE PRECISION,
     &    DIMENSION(idnw:idnb, ncompo)  :: xco, xcn
        DOUBLE PRECISION,
     &    DIMENSION(idnt:idnb)          :: xwo, xwn
        DOUBLE PRECISION,
     &    DIMENSION(idnw:idnb)          :: xuo, xun
        DOUBLE PRECISION, DIMENSION(nsolid) :: ysolido, ysolidn
        INTEGER :: itsflag
        DOUBLE PRECISION, DIMENSION(nsolut) :: bconc, wcflx
        DOUBLE PRECISION, DIMENSION(nsolid) :: bfflx

        INTENT(IN)    :: xzdn, wdbsl, wtmpdc, wsalin, atime, datime
        INTENT(IN)    :: wconc, wfflx
        INTENT(IN)    :: xco, ysolido, xwo, xuo
        INTENT(INOUT) :: xcn, ysolidn, xwn, xun
        INTENT(OUT)   :: itsflag
        INTENT(OUT)   :: bconc, wcflx, bfflx

        END SUBROUTINE ImplicitTimeStep
      END INTERFACE


      INTERFACE
        SUBROUTINE FVUPWIND_EQUATIONS(atimen, datime, xzdn, xzdv,
     &    wconc, wfflx, xco, yco, xcn, ycn, xwn, xun,
     &    jsolid_max,
     &    eqn_syst)
        USE mod_indexparam, ONLY: nsolut, nsolid, ncompo
        USE mod_gridparam, ONLY: idnw, idnt, idnb, idvw, idvb
        IMPLICIT NONE

        INTEGER, PARAMETER :: neqns_node=ncompo
        DOUBLE PRECISION :: atimen, datime
        DOUBLE PRECISION, DIMENSION(idnw:idnb) :: xzdn
        DOUBLE PRECISION, DIMENSION(idvw:idvb) :: xzdv
        DOUBLE PRECISION, DIMENSION(1:nsolut)  :: wconc
        DOUBLE PRECISION, DIMENSION(1:nsolid)  :: wfflx
        DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo) :: xco
        DOUBLE PRECISION, DIMENSION(nsolid) :: yco, ycn
        DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo) :: xcn
        DOUBLE PRECISION, DIMENSION(idnt:idnb) :: xwn
        DOUBLE PRECISION, DIMENSION(idnw:idnb) :: xun
        INTEGER, DIMENSION(idnt:idnb) :: jsolid_max

        DOUBLE PRECISION, DIMENSION(neqns_node,idnw:idnb) :: eqn_syst

        INTENT(IN) :: atimen, datime, xzdn, wconc, wfflx, xco,
     &                jsolid_max
        INTENT(INOUT) :: xcn, xwn, xun, eqn_syst
        END SUBROUTINE FVUPWIND_EQUATIONS
      END INTERFACE


      INTERFACE
        SUBROUTINE FVUPWIND_JACOBIAN(atimen, datime, xzdn, xzdv,
     &    wconc, wfflx,
     &    xco, yco, xcn, ycn, xwn, xun,
     &    jsolid_max, jcb_syst)

        USE mod_indexparam, ONLY: nsolut, nsolid, ncompo
        USE mod_gridparam, ONLY: idnw, idnt, idnb, idvw, idvb
        IMPLICIT NONE
        INTEGER, PARAMETER :: neqns_node=ncompo, nvars_node=ncompo
        DOUBLE PRECISION :: atimen, datime
        DOUBLE PRECISION, DIMENSION(idnw:idnb) ::         xzdn
        DOUBLE PRECISION, DIMENSION(idvw:idvb) ::         xzdv
        DOUBLE PRECISION, DIMENSION(nsolut)    ::         wconc
        DOUBLE PRECISION, DIMENSION(nsolid)    ::         wfflx
        DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo) :: xco, xcn
        DOUBLE PRECISION, DIMENSION(nsolid) ::            yco, ycn
        DOUBLE PRECISION, DIMENSION(idnt:idnb) ::         xwn
        DOUBLE PRECISION, DIMENSION(idnw:idnb) ::         xun
        INTEGER, DIMENSION(idnt:idnb) ::                  jsolid_max
        DOUBLE PRECISION, DIMENSION(neqns_node,
     &    nvars_node, idnw:idnb, -1:1) ::                 jcb_syst

        INTENT(IN)    :: atimen, datime, xzdn, wconc, wfflx, xco,
     &                   yco, ycn, jsolid_max
        INTENT(INOUT) :: xcn, xwn, xun
        INTENT(OUT)   :: jcb_syst
        END SUBROUTINE FVUPWIND_JACOBIAN
      END INTERFACE


      INTERFACE
        SUBROUTINE FVUPWIND_TRANLAY_RADIODECAY(datime, yo, yn, bfflx)
        USE MOD_INDEXPARAM,           ONLY: nsolid
        IMPLICIT NONE
        DOUBLE PRECISION,                    INTENT(IN)  :: datime
        DOUBLE PRECISION, DIMENSION(nsolid), INTENT(IN)  :: yo
        DOUBLE PRECISION, DIMENSION(nsolid), INTENT(OUT) :: yn
        DOUBLE PRECISION, DIMENSION(nsolid), INTENT(IN)  :: bfflx
        OPTIONAL :: bfflx
        END SUBROUTINE FVUPWIND_TRANLAY_RADIODECAY
      END INTERFACE

!=======================================================================
      END MODULE mod_medinterfaces
!=======================================================================
