!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_DEFINES_MEDUSA
!=======================================================================

      IMPLICIT NONE

! Characteristic index value for grid points not at the sea-floor
      INTEGER, PARAMETER ::  jp_is_not_at_seafloor_idx = -1

! Flag values for differentiating between the different parts
! (realms) of the sediment
      INTEGER, PARAMETER ::  jp_realm_difblay = 1
      INTEGER, PARAMETER ::  jp_realm_reaclay = 2
      INTEGER, PARAMETER ::  jp_realm_tranlay = 3
      INTEGER, PARAMETER ::  jp_realm_corelay = 4


! Flag values for specifying special actions
      INTEGER, PARAMETER ::  jp_req_create_file        = 1
      INTEGER, PARAMETER ::  jp_req_open_file          = 2
      INTEGER, PARAMETER ::  jp_req_close_file         = 3
      INTEGER, PARAMETER ::  jp_req_write_timerec      = 4
      INTEGER, PARAMETER ::  jp_req_read_timerec       = 5
      INTEGER, PARAMETER ::  jp_req_read_staticdata    = 6
      INTEGER, PARAMETER ::  jp_req_write_emptytimerec = 7

! Parameters for logical file units
      INTEGER, PARAMETER ::  jp_nounit = -1
      INTEGER, PARAMETER ::  jp_stderr =  0
      INTEGER, PARAMETER ::  jp_stdlog =  3
      INTEGER, PARAMETER ::  jp_stdout =  6

#ifdef DEBUG
      INTEGER, PARAMETER ::  jp_stddbg =  1
#else
      INTEGER, PARAMETER ::  jp_stddbg = -1
#endif

#ifdef DEBUG
      INTEGER, PARAMETER ::  jp_traceboundccond_log = 113
      INTEGER, PARAMETER ::  jp_tracexcwu_log       = 141
      INTEGER, PARAMETER ::  jp_tracexcpwpup_log    = 142
      INTEGER, PARAMETER ::  jp_trace_eqn_summary   = 151
      INTEGER, PARAMETER ::  jp_trace_eqn_detail    = 152
      INTEGER, PARAMETER ::  jp_trace_step          = 10
#endif


#ifdef MEDUSA_BASE2DT2D
      CHARACTER(LEN=*), PARAMETER :: cp_seafloor_gridtype = '2DT2D'
#else
#ifdef MEDUSA_BASE2D
      CHARACTER(LEN=*), PARAMETER :: cp_seafloor_gridtype = '2D'
#else
      CHARACTER(LEN=*), PARAMETER :: cp_seafloor_gridtype = '1D'
#endif
#endif


! From /usr/src/linux-headers-2.6.32-5-common/include/linux:
! #define PATH_MAX        4096  /* # chars in a path name including nul */
! (later: /usr/src/linux-headers-4.9.0-8-common/include/uapi/linux/limits.h)

      INTEGER, PARAMETER :: jp_lmaxpathname = 4095


      CONTAINS


      SUBROUTINE REPORT_COMPILE_OPTIONS(iunit)

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: iunit

      WRITE(iunit, '()')

      WRITE(iunit, '("This Medusa instance was compiled ' //
     &               'with the following explicit #defines:")')

      WRITE(iunit, '()')

#ifdef MEDUSA_BASE_2D
      WRITE(iunit, '(" -DMEDUSA_BASE_2D")')
#endif
#ifdef MEDUSA_BASE_2DT2D
      WRITE(iunit, '(" -DMEDUSA_BASE_2DT2D")')
#endif


#ifdef ALLOW_MPI
      WRITE(iunit, '(" -DALLOW_MPI")')
#endif


#ifdef GRID_CUSTOM
      WRITE(iunit, '(" -DGRID_CUSTOM")')
#endif

#ifdef BIODIFFUSION_CUSTO
      WRITE(iunit, '(" -DBIODIFFUSION_CUSTOM")')
#endif

#ifdef BIOIRRIGATION_CUSTOM
      WRITE(iunit, '(" -DBIOIRRIGATION_CUSTOM")')
#endif


#ifdef CALENDAR_360DAYS
      WRITE(iunit, '(" -DCALENDAR_360DAYS")')
#endif

#ifdef CALENDAR_365DAYS
      WRITE(iunit, '(" -DCALENDAR_365DAYS")')
#endif

#ifdef CALENDAR_365P25DAYS
      WRITE(iunit, '(" -DCALENDAR_365P25DAYS")')
#endif


#ifdef SOLVSED_NO_SVC_EQUATION
      WRITE(iunit, '(" -DSOLVSED_NO_SVC_EQUATION")')
#endif


c~ #ifdef ALLOW_SOLUTE_ADVECTION
c~       WRITE(iunit, '(" -DALLOW_SOLUTE_ADVECTION")')
c~ #endif

#ifdef PROFIW_NEGLECT_REACTION
      WRITE(iunit, '(" -DPROFIW_NEGLECT_REACTION")')
#endif

#ifdef SOLIDS_VOLUMELESS
      WRITE(iunit, '(" -DSOLIDS_VOLUMELESS")')
#endif

      WRITE(iunit, '()')


#ifdef DEBUG
      WRITE(iunit, '(" -DDEBUG")')

#include <debug.h>


#  ifdef DEBUG_MAIN
      WRITE(iunit, '(" -DDEBUG_MAIN")')
#    ifdef DEBUG_MAIN_ENTRY_EXIT
      WRITE(iunit, '(" -DDEBUG_MAIN_ENTRY_EXIT")')
#    endif
#    ifdef DEBUG_MAIN_INDICES
      WRITE(iunit, '(" -DDEBUG_MAIN_INDICES")')
#    endif
#  endif

#  ifdef DEBUG_BDIFFC
      WRITE(iunit, '(" -DDEBUG_BDIFFC")')
#    ifdef DEBUG_BDIFFC_ENTRY_EXIT
      WRITE(iunit, '(" -DDEBUG_BDIFFC_ENTRY_EXIT")')
#    endif
#    ifdef DEBUG_BDIFFC_BIODIFFUSION_INFOS
      WRITE(iunit, '(" -DDEBUG_BDIFFC_BIODIFFUSION_INFOS")')
#    endif
#  endif

#  ifdef DEBUG_BIRRIC
      WRITE(iunit, '(" -DDEBUG_BIRRIC")')
#    ifdef DEBUG_BIRRIC_ENTRY_EXIT
      WRITE(iunit, '(" -DDEBUG_BIRRIC_ENTRY_EXIT")')
#    endif
#  endif

#  ifdef DEBUG_PROFIW
      WRITE(iunit, '(" -DDEBUG_PROFIW")')
#  endif

#  ifdef DEBUG_DREA
      WRITE(iunit, '(" -DDEBUG_DREA")')
#    ifdef DEBUG_DREA_ENTRY_EXIT
      WRITE(iunit, '(" -DDEBUG_DREA_ENTRY_EXIT")')
#    endif
#  endif

#  ifdef DEBUG_SOLVSED
      WRITE(iunit, '(" -DDEBUG_SOLVSED")')
#    ifdef DEBUG_SOLVSED_EQN_SUMMARY
      WRITE(iunit, '(" -DDEBUG_SOLVSED_EQN_SUMMARY")')
#    endif
#    ifdef DEBUG_SOLVSED_EQN_DETAIL
      WRITE(iunit, '(" -DDEBUG_SOLVSED_EQN_DETAIL")')
#    endif
#    ifdef DEBUG_SOLVSED_ENTRY_EXIT
      WRITE(iunit, '(" -DDEBUG_SOLVSED_ENTRY_EXIT")')
#    endif
#    ifdef DEBUG_SOLVSED_BASICSTEP
      WRITE(iunit, '(" -DDEBUG_SOLVSED_BASICSTEP")')
#    endif
#    ifdef DEBUG_SOLVSED_JACOBIAN
      WRITE(iunit, '(" -DDEBUG_SOLVSED_JACOBIAN")')
#    endif
#    ifdef DEBUG_SOLVSED_TRACE
      WRITE(iunit, '(" -DDEBUG_SOLVSED_TRACE")')
#    endif
#    ifdef DEBUG_SOLVSED_TRACE_ALL
      WRITE(iunit, '(" -DDEBUG_SOLVSED_TRACE_ALL")')
#    endif
#    ifdef DEBUG_SOLVSED_SAVE_ANYWAY
      WRITE(iunit, '(" -DDEBUG_SOLVSED_SAVE_ANYWAY")')
#    endif
#    ifdef DEBUG_SOLVSED_CHECK_WCONC
      WRITE(iunit, '(" -DDEBUG_SOLVSED_CHECK_WCONC")')
#    endif
#    ifdef DEBUG_SOLVSED_ITERAT_II
      WRITE(iunit, '(" -DDEBUG_SOLVSED_ITERAT_II")')
#    endif
#    ifdef DEBUG_SOLVSED_ITERAT_NEWTONI
      WRITE(iunit, '(" -DDEBUG_SOLVSED_ITERAT_NEWTONI")')
#    endif
#    ifdef DEBUG_SOLVSED_ITERAT_OUTOFRANGE
      WRITE(iunit, '(" -DDEBUG_SOLVSED_ITERAT_OUTOFRANGE")')
#    endif
#  endif

#  ifdef DEBUG_REA
      WRITE(iunit, '(" -DDEBUG_REA")')
#    ifdef DEBUG_REA_ENTRY_EXIT
      WRITE(iunit, '(" -DDEBUG_REA_ENTRY_EXIT")')
#    endif
#    ifdef DEBUG_REA_REACTION_TERMS
      WRITE(iunit, '(" -DDEBUG_REA_REACTION_TERMS")')
#    endif
#  endif

#  ifdef DEBUG_C4D
#    ifdef DEBUG_C4D_PERMUTATIONS
      WRITE(iunit, '(" -DDEBUG_C4D_PERMUTATIONS")')
#    endif
#    ifdef DEBUG_C4D_UPPERTRIANGULAR
      WRITE(iunit, '(" -DDEBUG_C4D_UPPERTRIANGULAR")')
#    endif
#    ifdef DEBUG_C4D_VANDERMONDE
      WRITE(iunit, '(" -DDEBUG_C4D_VANDERMONDE")')
#    endif
#  endif

#  ifdef DEBUG_SEDCORE
      WRITE(iunit, '(" -DDEBUG_SEDCORE")')
#    ifdef DEBUG_SEDCORE_ENTRY_EXIT
      WRITE(iunit, '(" -DDEBUG_SEDCORE_ENTRY_EXIT")')
#    endif
#    ifdef DEBUG_SEDCORE_COLUMN
      WRITE(iunit, '(" -DDEBUG_SEDCORE_COLUMN")')
#    endif
#    ifdef DEBUG_SEDCORE_NCIN_TO_NCOUT
      WRITE(iunit, '(" -DDEBUG_SEDCORE_NCIN_TO_NCOUT")')
#    endif
#    ifdef DEBUG_SEDCORE_CLOSEFILE
      WRITE(iunit, '(" -DDEBUG_SEDCORE_CLOSEFILE")')
#    endif
#    ifdef DEBUG_SEDCORE_CORRECT4DECAY
      WRITE(iunit, '(" -DDEBUG_SEDCORE_CORRECT4DECAY")')
#    endif
#  endif

      WRITE(iunit, '()')
#endif


      END SUBROUTINE REPORT_COMPILE_OPTIONS


!=======================================================================
      END MODULE MOD_DEFINES_MEDUSA
!=======================================================================
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
