!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_BASICDATA_MEDUSA
!=======================================================================

      IMPLICIT NONE

!**************************** Physical units ***************************
! Physical units
! Default units are:
!  temperatures:  kelvin
!  time:          year
!  length:        meter (surface areas and volumes m^2 and m^3)
!  solids' mass:  kg
!  solutes' mass: mol

#ifndef CALENDAR_360DAYS
#ifndef CALENDAR_365DAYS
#ifndef CALENDAR_365P25DAYS
! Use default calendar with 365 days/year
#define CALENDAR_365DAYS
#endif
#endif
#endif

#ifdef CALENDAR_360DAYS
#ifdef CALENDAR_365DAYS
#undef CALENDAR_365DAYS
#endif
#ifdef CALENDAR_365P25DAYS
#undef CALENDAR_365P25DAYS
#endif
! Basis: 1 year = 360 days, 1 day = 24 hours, 1 hour = 3600 seconds
      DOUBLE PRECISION, PARAMETER :: dp_day       = 1.0D+00/360.0D+00   ! 1 day = 1/360 yr
      DOUBLE PRECISION, PARAMETER :: dp_sec       = 1.0D+00/3.1104D+07  ! 1 s = 1/(360*86400)
      DOUBLE PRECISION, PARAMETER :: dp_cm2_p_sec = 3.1104D+03          ! 1 cm^2/s = 3.1104D+03 m^2/yr
      DOUBLE PRECISION, PARAMETER :: dp_cm2_p_day = 3.60D-02            ! 1 cm^2/d = 360D-04 m^2/yr
#endif

#ifdef CALENDAR_365DAYS
#ifdef CALENDAR_365P25DAYS
#undef CALENDAR_365P25DAYS
#endif
! Basis: 1 yr = 365 days, 1 day = 24 hours, 1 hour = 3600 seconds
      DOUBLE PRECISION, PARAMETER :: dp_day       = 1.0D+00/365.0D+00   ! 1 day = 1/365 yr
      DOUBLE PRECISION, PARAMETER :: dp_sec       = 1.0D+00/3.1536D+07  ! 1 s = 1/(365*86400)
      DOUBLE PRECISION, PARAMETER :: dp_cm2_p_sec = 3.1536D+03          ! 1 cm^2/s = 3.1536D+03 m^2/yr
      DOUBLE PRECISION, PARAMETER :: dp_cm2_p_day = 3.65D-02            ! 1 cm^2/d = 365D-04 m^2/yr
#endif

#ifdef CALENDAR_365P25DAYS
! Basis: 1 yr = 365.25 days, 1 day = 24 hours, 1 hour = 3600 seconds
      DOUBLE PRECISION, PARAMETER :: dp_day       = 1.0D+00/365.25D+00  ! 1 day = 1/365.25 yr
      DOUBLE PRECISION, PARAMETER :: dp_sec       = 1.0D+00/3.15576D+07 ! 1 s = 1/(365.25*86400)
      DOUBLE PRECISION, PARAMETER :: dp_cm2_p_sec = 3.15576D+03         ! 1 cm^2/s = 3.15576D+03 m^2/yr
      DOUBLE PRECISION, PARAMETER :: dp_cm2_p_day = 3.6525D-02          ! 1 cm^2/d = 365.25D-04 m^2/yr
#endif


      DOUBLE PRECISION, PARAMETER :: dp_cm         = 1.0D-02       ! 1 cm = 1.D-02 m
      DOUBLE PRECISION, PARAMETER :: dp_cm_p_yr    = 1.0D-02       ! 1 cm/yr = 1.D-02 m/yr
      DOUBLE PRECISION, PARAMETER :: dp_cm2        = 1.0D-04       ! 1 cm^2 = 1.D-04 m^2
      DOUBLE PRECISION, PARAMETER :: dp_cm2_p_yr   = 1.0D-04       ! 1 cm^2/yr = 1.D-04 m^2/yr
      DOUBLE PRECISION, PARAMETER :: dp_cm2_p_kyr  = 1.0D-07       ! 1 cm^2/kyr = 1.D-07 m^2/yr

! Physical constants
      DOUBLE PRECISION, PARAMETER :: dp_zero_degc  = 273.15D+00    ! 0 deg C = 273.15 K
      DOUBLE PRECISION, PARAMETER :: dp_rgas       = 8.314510D+00  ! J/mol/K
      DOUBLE PRECISION, PARAMETER :: dp_rrgas      = 83.14510D+00  ! bar/cm3/mol/K
      DOUBLE PRECISION, PARAMETER :: dp_gearth     = 9.80665D+00   ! g = 9.80665 m/s^2
      DOUBLE PRECISION, PARAMETER :: dp_atm        = 101325.0D+00  ! 1 atm = 1013.25 hPa = 101325 Pa
      DOUBLE PRECISION, PARAMETER :: dp_molvol_stp =  dp_rgas      ! m3/mol @ 1atm and 273.15K
     &                                               *dp_zero_degc ! 1 J = 1 N * 1 m = 1 Pa * 1 m3
     &                                               /dp_atm

! Mathematical constants
      DOUBLE PRECISION, PARAMETER :: dp_pi = 3.14159265358979323846D+00
      DOUBLE PRECISION, PARAMETER :: dp_onedeg = dp_pi/180.0D+00


!************************** Material constants *************************

! Fundamental molar constants
! Source: M. Wieser (ed.). Atomic weights of the elements 2005.
!         (IUPAC Technical Report) Pure Appl. Chem., 78(11):2051–2066,
!         2006. doi:10.1351/pac200678112051

! Elemental molar weights [kg/mol]

      DOUBLE PRECISION, PARAMETER :: dp_mol_H  =  1.00794D-03     !  1
      DOUBLE PRECISION, PARAMETER :: dp_mol_B  =  10.811D-03      !  5
      DOUBLE PRECISION, PARAMETER :: dp_mol_C  =  12.0107D-03     !  6
      DOUBLE PRECISION, PARAMETER :: dp_mol_N  =  14.0067D-03     !  7
      DOUBLE PRECISION, PARAMETER :: dp_mol_O  =  15.9994D-03     !  8
      DOUBLE PRECISION, PARAMETER :: dp_mol_Na =  22.98976928D-03 ! 11
      DOUBLE PRECISION, PARAMETER :: dp_mol_Mg =  24.3050D-03     ! 12
      DOUBLE PRECISION, PARAMETER :: dp_mol_Al =  26.9815386D-03  ! 13
      DOUBLE PRECISION, PARAMETER :: dp_mol_Si =  28.0855D-03     ! 14
      DOUBLE PRECISION, PARAMETER :: dp_mol_P  =  30.973761D-03   ! from webelements.com
!     DOUBLE PRECISION, PARAMETER :: dp_mol_P  =  30.973762D-03   ! 15
      DOUBLE PRECISION, PARAMETER :: dp_mol_S  =  32.065D-03      ! 16
      DOUBLE PRECISION, PARAMETER :: dp_mol_K  =  39.0983D-03     ! 19
      DOUBLE PRECISION, PARAMETER :: dp_mol_Ca =  40.078D-03      ! 20
      DOUBLE PRECISION, PARAMETER :: dp_mol_Mn =  54.938045D-03   ! 25
      DOUBLE PRECISION, PARAMETER :: dp_mol_Fe =  55.845D-03      ! 26


! Isotopic characteristic data
! ============================

! Standard Ratios
! ---------------
!
!   - dp_rstd_Xx_Yy: Atomic ratio n(Xx)/n(Yy)


! Radioactive decay constants
! ---------------------------
!
!   - dp_tau_Xx = Half-life_of_Xx / LN(2)
!     To be used as: d[Xx]/dt = -[Xx]/dp_tau_Xx
!   - dp_lambda_Xx = Decay_Constant_of_Xx
!     To be used as: d[Xx]/dt = -dp_lambda_Xx*[Xx]


! Boron-11
! ---------
!
! Standard reference level (NIST SRM 951)
!     4.04362 +/- 0.00137            [1]
!
! Source:
! [1] Catanzaro et al. (1970) Standard Reference Materials: Boric Acid,
!     Isotopic and Assay Standard Reference Materials.
!     U.S. National Bureau of Standards, Spec. Pub. 260-17, 70 pp.

      DOUBLE PRECISION, PARAMETER :: dp_rstd_B11_B10 = 4.04362D+00


! Notice: other values cited in the literature (only to add confusion)
!
!     4.0436                         [2] referring to [1]
!     4.05003  +/- 0.00034 (2 sigma) [3] new measurements
!     4.04363                        [4] referring to [1]
!     4.04362  +/- 0.00137           [5] no reference
!     4.050898 +/- 0.000116          [6,7] no reference
!     4.0509   +/- 0.0010            [7] n=71
!     4.04367                        [8] referring to [1]
!
! [2] De Laeter et al. (2003) Atomic weights of elements: Review 2000.
!     Pure and Applied Chemistry 75(6):683--800
!     DOI:10.1351/pac200375060683
! [3] Ishikawa and Tera (1997) Source, composition and distribution of
!     the fluid in the Kurile mantle wedge: Constraints from across-arc
!     variations of B/Nb and B isotopes. Earth Planet. Sci. Lett.
!     152:123--138. [11B/10B in NIST SRM 951]
! [4] Foster et al. (2003) Interlaboratory comparison of boron isotope
!     analyses of boric acid, seawater and marine CaCO3 by MC-ICPMS
!     and NTIMS. Chem. Geol. 358:1--14.
! [5] Tirez et al. (2010) Boron isotope ratio (d11B) measurements in
!     Water Framework Directive monitoring programs: comparison between
!     double focusing sector field ICP and thermal ionization mass
!     spectrometry. J. Anal. At. Spectrom., 2010, 25, 964--974
! [6] Vogl (2013) Advances in Isotope Ratio Mass Spectrometry and
!     Required Isotope Reference Materials. Mass Spectrometry 2:S0020.
!     DOI:10.5702/massspectrometry.S0020
! [7] Rosner et al. (2011) Development and Validation of a Method to
!     Determine the Boron Isotopic Composition of Crop Plants.
!     Anal. Chem. 83(7):2562--2568. DOI:10.1021/ac102836h
! [8] Foster and Rae (2016) Reconstructing Ocean pH with Boron Isotopes
!     in Foraminifera. Annu. Rev. Earth Planet. Sci. 44:207--237.
!     DOI: 10.1146/annurev-earth-060115-012226


! Carbon-13
! ---------
!
! Standard reference level:
!     0.0112372 +/- 0.0000029

! Source:
!     Craig (1957) Isotopic standards for carbon and oxygen
!     and correction factors for mass-spectrometric analysis
!     of carbon dioxide. Geochim. Cosmochim. Acta 12(1/2):133--149.

      DOUBLE PRECISION, PARAMETER :: dp_rstd_C13_C12 = 0.0112372D+00


! Carbon-14
! ---------
!
! Half-life
!     5730 +/- 40 yr
!
! Source:
!     Godwin (1962). Half-life of radiocarbon. Nature, 195:984.
!
! This leads to  TAU_C14 = {Half-life}/ln(2) = 8266.64258429376 yr,
! commonly rounded to 8267 yr.
! Decay constant: LAMBDA_C14 = 1/TAU_C14 = 1.209680943D-4 yr^{-1}
! rounded to 1.2097D-4 according to "OCMIP-2 Abiotic-Howto"
! Source: Orr et al. (2000) URL: http://ocmip5.ipsl.jussieu.fr/OCMIP/phase2/
!     simulations/Abiotic/HOWTO-Abiotic.html.

      !DOUBLE PRECISION, PARAMETER :: dp_lambda_C14 = 1.2097D-04

! Revised Half-life
!     5700 +/- 30 yr
!
! Source:
!     G. Audi, O. Bersillon, J. Blachot, and A. H. Wapstra.
!     The NUBASE evaluation of nuclear and decay properties.
!     Nuclear Physics A, 729, (1), 3-128, 2003.
!
! This leads to  TAU_C14 = {Half-life}/ln(2) = 8223.36173307 yr,
! rounded to 8223 yr.
! Decay constant: LAMBDA_C14 = 1/TAU_C14 = 1.21604768519D-4 yr^{-1}
! rounded to 1.2160D-4

      DOUBLE PRECISION, PARAMETER :: dp_lambda_C14 = 1.2160D-04


! Contemporary standard reference level for C-14/C
! Source:
!     "OCMIP-2 Abiotic-Howto" (ibid.)
!
! Derivation:
!   - Standard activity = 95% of activity of oxalic acid reference
!     in 1950. (95% to "correct" back to late 19th century ("pre-industrial"))
!     * measured activity in 1950: 14.27 +/- 0.07 dpm/gC
!       Source: I. Karlén, I. U. Olsson, and P. Kallberg.
!           Absolute determination of the activity of two C14 dating
!           standards. Arkiv för Geofysik, 4(22):465-471, 1964.
!     * 95% of measured: 13.56 +/- 0.07 dpm/gC
!       Source: Karlén et al. (ibid)
!   - oxalic acid standard has delta13C of -19.2 permil PDB
!       Source: reported by Mook and van der Plicht,
!           Radiocarbon 41(3):227-239 (1999):
!       n13/n12 = 0.0112372*0.9808
!               = 0.01102144576
!   - mol_C = (n12*12 + n13*13)/(n12+n13)
!           = (12 + (n13/n12)*13)/(1 + (n13/n12))
!           = 12.0109012977
!
!   - with half-life = 5730 yr:
!     + dn14/dyr  = -n14/8267
!     + dn14/dmin = -n14/(8267*365.25*24*60)
!     + dn14/dmin = -13.56 => n14 = 13.56*8267*365.25*24*60
!                                 = 0.589603894992 x 10^-11
!     + n (= 1gC) = 1/(mol_C)*n_A = 6.022140857(74) x 10^23 / 12.0109012977
!                                 = 0.50138958832 x 10^23
!     + n14/n = 0.589603894992 x 10^-11 / (0.50138958832 x 10^23)
!             = 1.175939646 x 10^-12


      !DOUBLE PRECISION, PARAMETER :: dp_rstd_C14_C = 1.176D-12

!   - with half-life = 5700 yr
!     + decay constant = 8223.36173307
!     + dn14/dmin = -13.56 => n14 = 13.56*8223.36173307*365.25*24*60
!                                 = 0.58649160611 x 10^-11
!     + n14/n = 0.58649160611 x 10^-11 / (0.50138958832 x 10^23)
!             = 1.16973231949 x 10^-12
!
!   - Note slight inconsistency: dn14/dmin = -13.56 dpm/gC was derived
!     from measurements carried out ca. 1964, and corrected to 1950
!     using a half-life of 5730 yr.
!     Answer: including this correction makes the standard 14C/C ratio
!     change from 1.176 x 10^-12 to 1.17601065643 x 10^-12
!     (relative change < 10^-5)
!
! Additional refs.:
!   - n_A (Avogadro's constant): CODATA 2014

      DOUBLE PRECISION, PARAMETER :: dp_rstd_C14_C = 1.170D-12


! Oxygen-18
! ---------
!
! Standard reference level:
!     0.00200520 +/- 0.00000045
!
! Source:
!     Baertschi (1976) Absolute ${^18}$O content of standard
!     mean ocean water. Earth Planet. Sci. Lett. 31(3):341--344.
!     [later renamed Vienna Standard Mean Ocean Water -- VSMOW]

      DOUBLE PRECISION, PARAMETER :: dp_rstd_O18_O16 = 2005.20D-06



! Other physical data
! ===================

! Currently none.

!=======================================================================
      END MODULE MOD_BASICDATA_MEDUSA
!=======================================================================
