!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE UPWIND_KAPPA_SOLIDS(adv, dfc, vxzd, dkappa)
!-----------------------------------------------------------------------

      IMPLICIT NONE

      DOUBLE PRECISION, INTENT(IN)  :: adv  ! advection rate
      DOUBLE PRECISION, INTENT(IN)  :: dfc  ! diffusion coefficient
      DOUBLE PRECISION, INTENT(IN)  :: vxzd ! grid spacing

      DOUBLE PRECISION, INTENT(OUT) :: dkappa


!-----------------------
! Variable declarations
!-----------------------

!- - - - - - - - -
! Local variables
!- - - - - - - - -

      DOUBLE PRECISION :: dmu


      !---------------------------
      ! Upwinding parameter dkappa
      !---------------------------

      SELECT CASE(jselect_upwinding)

      CASE DEFAULT                  ! Full upwind

        IF     (adv < 0.0D+00) THEN
          dkappa = -1.0D+00
        ELSEIF (adv > 0.0D+00) THEN
          dkappa =  1.0D+00
        ELSE
          dkappa =  0.0D+00
        ENDIF


      CASE(jp_upw_expfit)           ! Exponential fitting

        IF (dfc > 0.0D+00) THEN
          dmu = adv*vxzd/dfc
          dkappa = DKAPPA_EXPONFIT(dmu)
        ELSE
          IF     (adv < 0.0D+00) THEN
            dkappa = -1.0D+00
          ELSEIF (adv > 0.0D+00) THEN
            dkappa =  1.0D+00
          ELSE
            dkappa =  0.0D+00
          ENDIF
        ENDIF

      END SELECT

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE UPWIND_KAPPA_SOLIDS
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE UPWIND_KAPPA_SOLUTES(adv, dfc, vxzd, dkappa)
!-----------------------------------------------------------------------

      USE mod_indexparam,      ONLY: nsolut

      IMPLICIT NONE

      DOUBLE PRECISION,                    INTENT(IN)  :: adv
      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(IN)  :: dfc
      DOUBLE PRECISION,                    INTENT(IN)  :: vxzd

      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(OUT) :: dkappa


!-----------------------
! Variable declarations
!-----------------------

!- - - - - - - - -
! Local variables
!- - - - - - - - -

      DOUBLE PRECISION :: dmu
      INTEGER          :: jsolut

!- - - - - - - - - - -
! End of declarations
!- - - - - - - - - - -

!----------------------------------------------------------------------
! Subroutine Start
!----------------------------------------------------------------------


      !----------------------------------------
      ! Upwinding parameters dkappa for solutes
      !----------------------------------------

      SELECT CASE(jselect_upwinding)

      CASE DEFAULT                  ! Full upwind

        IF     (adv < 0.0D+00) THEN
          dkappa(:) = -1.0D+00
        ELSEIF (adv > 0.0D+00) THEN
          dkappa(:) =  1.0D+00
        ELSE
          dkappa(:) =  0.0D+00
        ENDIF


      CASE(jp_upw_expfit)           ! Exponential fitting

        DO jsolut = 1, nsolut
          IF (dfc(jsolut) > 0.0D+00) THEN
            dmu = adv*vxzd/dfc(jsolut)
            dkappa(jsolut) = DKAPPA_EXPONFIT(dmu)
          ELSE
            IF     (adv < 0.0D+00) THEN
              dkappa(jsolut) = -1.0D+00
            ELSEIF (adv > 0.0D+00) THEN
              dkappa(jsolut) =  1.0D+00
            ELSE
              dkappa(jsolut) =  0.0D+00
            ENDIF
          ENDIF
        ENDDO


      END SELECT


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE UPWIND_KAPPA_SOLUTES
!-----------------------------------------------------------------------
