!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE SWI_CONC(xnz, xnc, wconc, sconc)
!-----------------------------------------------------------------------


      USE mod_gridparam,            ONLY: idnw, idnb, ndn_w2s,
     &                                    idvs, idvb,
     &                                    dp_swi_location
      USE mod_indexparam,           ONLY: ncompo, nsolid, nsolut,
     &                                    jf_to_io, jc_to_io
      USE mod_milieucharas,         ONLY: xvphi, xvtor2


      IMPLICIT NONE


      DOUBLE PRECISION, DIMENSION(idnw:idnb)         :: xnz
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo) :: xnc
      DOUBLE PRECISION, DIMENSION(nsolut)            :: wconc
      DOUBLE PRECISION, DIMENSION(nsolut)            :: sconc

      INTENT(IN)  :: xnz, xnc, wconc
      INTENT(OUT) :: sconc


      DOUBLE PRECISION, DIMENSION(nsolut) :: thetaswi
      INTEGER :: idntm1



      IF (ndn_w2s == 0) THEN

        sconc(:) = wconc(:)

      ELSE

        ! F_{x=0}^{-} = -D * (C_{x=0} - xc(idnt-1,:))/(-x_{idnt-1})
        !               + u_tot^{-} C^{upw}
        ! F_{x=0}^{+} = -\phi (D/\theta^2 + \beta*D_b)
        !                  * (xc(idnt,:) - C_{x=0})/x_{idnt}
        !               + u_tot^{+} \phi C^{upw}
        !
        ! Since u_tot^{-} = u_tot^{+} \phi,
        ! u^{-} C^{upw} = u_tot^{+} \phi C^{upw}
        ! and thus
        !     F_{x=0}^{-} = F_{x=0}^{+}
        ! <=>  (C_{x=0}  - xc(idnt-1,:))
        !     /(x_{idvs} - x_{idnt-1})
        !     = \phi (1/\theta^2 + \beta*D_b/D)
        !       * (xc(idnt,:) - C_{x=0})
        !        /(x_{idnt}   - x_{idvs})
        ! <=> C_{x=0} - xc(idnt,:) + xc(idnt,:) - xc(idnt-1,:)
        !     = \phi (1/\theta^2 + \beta*D_b/D)
        !            * (xc(idnt,:) - C_{x=0})
        !            * (x_{idvs} - x_{idnt-1})/(x_{idnt} - x_{idvs})
        ! <=> xc(idnt,:) - C_{x=0}
        !     =   (xc(idnt,:) - xc(idnt-1,:))
        !       / (  \phi (1/\theta^2 + \beta*D_b/D)
        !            * (x_{idvs}-x_{idnt-1})/(x_{idnt}-x_{idvs})
        !          + 1 )


        idntm1 = idnt - 1           ! to trick the compiler

        thetaswi(:) =
     &    1.0D+00
     &    / (  xvphi(idvs)
     &         * (  1.0D+00/xvtor2(idvs)
! The two lines below this comment block are currently commented out
! as we do not (yet) consider the effect of biodiffusion on the solutes.
! Once this would be changed, they must be uncommented.
!     &            + dcf_biointer(idvs)*dcf_biotur(idvs)
!     &                        / dcf_molion(:)
     &           )
     &         * ( (dp_swi_location - xnz(idntm1)    )
     &            /(      xnz(idnt) - dp_swi_location) )
     &       + 1.0D+00
     &      )

        sconc(:) =
     &    xnc(idnt, jc_to_io(:))
     &    - (xnc(idnt, jc_to_io(:)) - xnc(idntm1, jc_to_io(:)))
     &      * thetaswi(:)

      ENDIF


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE SWI_CONC
!-----------------------------------------------------------------------
