!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      SUBROUTINE PROFIW(wfflx, xnc, xnz, xvw_tot, aw_bplus)
!=======================================================================

#ifdef DEBUG
#ifdef DEBUG_PROFIW
      USE MOD_DEFINES_MEDUSA,       ONLY: jp_stddbg
#endif
#endif

      USE MOD_GRIDPARAM,            ONLY: idnw, idnt, idnb, idvs, idvb,
     &                                    dp_swi_location,
     &                                    thetatop, thetabot
      USE MOD_INDEXPARAM,           ONLY: nsolid, ncompo, jf_to_io
      USE MOD_MATERIALCHARAS,       ONLY: apsv, apsv_factor
      USE MOD_MILIEUCHARAS,         ONLY: xphi
#ifdef DEBUG
#ifdef DEBUG_PROFIW
      USE MOD_MILIEUCHARAS,         ONLY: xvphi
#endif
#endif

      USE MOD_RREAC,                ONLY: REACRATE
      USE MOD_DEFINES_MEDUSA,       ONLY: jp_realm_reaclay


      IMPLICIT NONE


!-----------------------
! Variable declarations
!-----------------------

!- - - - - - - - - - - - - -  - - - - - - - -
! General (global) parameters and definitions
!- - - - - - - - - - - - - -- - - - - - - - -

      ! None

!- - - - - - - - - - - - -  - - - - - - -
! Variables in subroutine call arguments
!- - - - - - - - - - - - -- - - - - - - -

      DOUBLE PRECISION, DIMENSION (nsolid)           :: wfflx
      DOUBLE PRECISION, DIMENSION (idnw:idnb,ncompo) :: xnc
      DOUBLE PRECISION, DIMENSION (idvs:idvb)        :: xvw_tot
      DOUBLE PRECISION, DIMENSION (idnw:idnb)        :: xnz
      DOUBLE PRECISION, OPTIONAL                     :: aw_bplus

      INTENT(IN)  :: wfflx, xnc, xnz
      INTENT(OUT) :: xvw_tot, aw_bplus

!- - - - - - - - -
! Local variables
!- - - - - - - - -

      DOUBLE PRECISION, DIMENSION (idnt:idnb)        :: xndw_tot
      DOUBLE PRECISION, DIMENSION(ncompo)            :: anc
      DOUBLE PRECISION                               :: anz
      DOUBLE PRECISION                               :: avz, avz_a
      DOUBLE PRECISION                               :: anphi
      DOUBLE PRECISION, DIMENSION (ncompo)           :: anrea

      INTEGER :: inode, inode_a, inode_b
      INTEGER :: ivrtx

!- - - - - - - - - - -
! End of declarations
!- - - - - - - - - - -

!----------------------------------------------------------------------
! Subroutine Start
!----------------------------------------------------------------------


! Calculate the total velocity profile (the volume averaged solid
! velocity profile) at vertex points xvw_tot(z) = w_tot(z)*(1-xphi(z))
! by integrating the relationship
! \partderiv{}{z} ( \varphi^s w - \eta D^{bt} \partderiv{\varphi^s}{z} )
!   = \sum_{i of solids} \frac{TotSedReacRate_{i}}{\rho_{i}}
! where
!  --  \varphi^s = 1- \varphi  => 1 - xphi
!  --  \varphi^s w             => xw
!  --  \eta                    => dcf_biointer
!  --  D^{bt}                  => dcf_biotur
!  --  \partderiv{\varphi^s}{z} = -\partderiv{\varphi}{z}
!                              => -xdphi
!  --  TotSedReacRate          => anrea [4th argument of REA]
!  --  1/\rho                  => apsv


#ifdef PROFIW_NEGLECT_REACTION

      xvw_tot(:) = SUM(wfflx(:)*apsv(:)*apsv_factor(:))

#else

      DO inode = idnt, idnb

         anz    =  xnz(inode)
         anphi  = xphi(inode)
         anc(:) =  xnc(inode,:)

         CALL REACRATE(jp_realm_reaclay, anz, anphi, anc, anrea)

         xndw_tot(inode) = SUM( anrea(jf_to_io(:))
     &                         *apsv(:)*apsv_factor(:))

      ENDDO


      IF (idnt == idnw) THEN
                                  ! If there is no DBL, replace xndw_tot at
                                  ! the top node by interpolation between
                                  ! the values at the two top-most nodes.
        xndw_tot(idnt) =   (1.0D+00-thetatop)*xndw_tot(idnt  )
     &                   +      thetatop     *xndw_tot(idnt+1)
      ENDIF

                                  ! Replace xndw_tot at the bottom node by
                                  ! interpolation between the values
                                  ! at the two bottom-most nodes
      xndw_tot(idnb) =        thetabot     *xndw_tot(idnb-1)
     &                 + (1.0D+00-thetabot)*xndw_tot(idnb  )


      ! Integrate xndw_tot, store results into xvw_tot

      xvw_tot(idvs) = SUM(wfflx(:)*apsv(:)*apsv_factor(:))

      avz_a = dp_swi_location

      DO ivrtx = idvs + 1, idvb - 1

                                  ! z_nodea < z_vrtx < z_nodeb where
                                  ! inode_a = ivrtx and inode_b = ivrtx + 1
                                  ! for idvs < ivrtx < idvb
        inode_a = ivrtx
        inode_b = ivrtx + 1

        avz = (xnz(inode_a) + xnz(inode_b))/2.0D+00

        xvw_tot(ivrtx) = xvw_tot(ivrtx-1)
     &                   + xndw_tot(inode_a) * (avz - avz_a)

        avz_a = avz

      ENDDO

      avz = xnz(idnb)

      xvw_tot(idvb) = xvw_tot(idvb-1)
     &                + xndw_tot(idnb) * (avz - avz_a)

#endif

      IF (PRESENT(aw_bplus)) aw_bplus = xvw_tot(idvb)

#ifdef DEBUG
#ifdef DEBUG_PROFIW
      WRITE(jp_stddbg, '("[PROFIW] debug: xw, w @ S")', ADVANCE="NO")
      WRITE(jp_stddbg, *) xvw_tot(idvs),
     &                    xvw_tot(idvs)/(1.0D+00 - xvphi(idvs))
      WRITE(jp_stddbg, '("                      @ B")', ADVANCE="NO")
      WRITE(jp_stddbg, *) xvw_tot(idvb),
     &                    xvw_tot(idvb)/(1.0D+00 - xvphi(idvb))
#endif
#endif

      RETURN

!=======================================================================
      END SUBROUTINE PROFIW
!=======================================================================
