!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      SUBROUTINE PROFIU(xwtot, aw_bplus, xutot)
!=======================================================================

!--------------
! Declarations
!--------------

      USE MOD_GRIDPARAM,            ONLY: idvw, idvs, idvb
      USE MOD_MILIEUCHARAS,         ONLY: xvphi

      IMPLICIT NONE


!-----------------------
! Variable declarations
!-----------------------

!- - - - - - - - - - - - - -  - - - - - - - -
! General (global) parameters and definitions
!- - - - - - - - - - - - - -- - - - - - - - -

      ! None

!- - - - - - - - - - - - -  - - - - - - -
! Variables in subroutine call arguments
!- - - - - - - - - - - - -- - - - - - - -

      DOUBLE PRECISION, INTENT(IN),  DIMENSION(idvs:idvb) :: xwtot
      DOUBLE PRECISION, INTENT(IN)                        :: aw_bplus
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(idvw:idvb) :: xutot

!- - - - - - - - - - -
! End of declarations
!- - - - - - - - - - -

!----------------------------------------------------------------------
! Subroutine Start
!----------------------------------------------------------------------

                                    ! Notice:
                                    !  - xutot(z) = u(z)*phi(z)
                                    !  - xwtot(z) = w(z)*(1-phi(z))

c~ #ifdef ALLOW_SOLUTE_ADVECTION
c~                                     ! Solute advection profile xu(z)
c~                                     ! under the assumption that no
c~                                     ! reactions take place below the
c~                                     ! REACLAY and that pure steady-state
c~                                     ! compaction takes place
c~          xutot(:) =  aw_bplus/(1.0D+00 - xvphi(idvb))*xvphi(idvb)
c~ #else
                                    ! Advection profile ... neglecting
                                    ! solute advection.
         xutot(:) =  0.0D+00
c~ #endif

      RETURN

!=======================================================================
      END SUBROUTINE PROFIU
!=======================================================================
