!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE NONLOCAL_TRANSPORT
     &  (krealm, xzdn, inode, xc, wconc, flxnonloc)
!-----------------------------------------------------------------------

! Returns non-local flux value at node <inode>
! Currently, only solute biorrigation fluxes are considered.


!-----------------------------------------------------------------------
! Modules used
!-----------------------------------------------------------------------

      USE mod_defines_medusa
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA
      USE mod_gridparam,            ONLY: idnw, idnt, idnz, idnb
      USE mod_indexparam,           ONLY: nsolut, nsolid, ncompo,
     &                                    jc_to_io, jf_to_io
      USE mod_milieucharas,         ONLY: xphi


!-----------------------------------------------------------------------
! Variable declarations
!-----------------------------------------------------------------------


      IMPLICIT NONE


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! General (global) parameters
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      ! None


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Variables in subroutine call arguments
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      INTEGER,          INTENT(IN)                        :: krealm
      DOUBLE PRECISION, INTENT(IN),  DIMENSION(idnw:idnb) :: xzdn
      INTEGER,          INTENT(IN)                        :: inode
      DOUBLE PRECISION, INTENT(IN),  DIMENSION(idnw:idnb, ncompo) :: xc
      DOUBLE PRECISION, INTENT(IN),  DIMENSION(nsolut)    :: wconc
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(ncompo)    :: flxnonloc


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Local variables
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      ! None


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! End of declarations
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

!-----------------------------------------------------------------------
! Subroutine Start
!-----------------------------------------------------------------------


      SELECT CASE(krealm)

      CASE (jp_realm_difblay)       ! In the DBL realm

        flxnonloc(:) = 0.0D+00


      CASE(jp_realm_reaclay)        ! In the REACLAY realm
                                    !  - solutes' biorrigation 
        flxnonloc(jc_to_io(:)) = xphi(inode)
     &                        * rcf_bioirr(inode)
     &                        * (wconc(:) - xc(inode, jc_to_io(:)))

                                    !  - solids: no non-local transport
        flxnonloc(jf_to_io(:)) = 0.0D+00


      CASE DEFAULT                  ! Elsewhere

        flxnonloc(:) = 0.0D+00


      END SELECT


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE NONLOCAL_TRANSPORT
!-----------------------------------------------------------------------
