!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      SUBROUTINE NONLOCAL_TRANSPORT_TOTALS
     &  (xzdn, xc, wconc, flxnonloc_tot)
!=======================================================================

! This subroutine returns the column-integrated non-local fluxes.
! The adequate parameters (bioirrigation coefficients etc.) must have
! initialized before calling.

      USE MOD_GRIDPARAM,            ONLY: idnw, idnt, idnb,
     &                                    thetatop, thetabot
      USE MOD_INDEXPARAM,           ONLY: nsolut, ncompo

      USE MOD_DEFINES_MEDUSA,       ONLY: jp_realm_reaclay


      IMPLICIT NONE


      DOUBLE PRECISION, INTENT(IN),  DIMENSION (idnw:idnb)
     &  :: xzdn
      DOUBLE PRECISION, INTENT(IN),  DIMENSION (idnw:idnb,ncompo)
     &  :: xc
      DOUBLE PRECISION, INTENT(IN),  DIMENSION (nsolut)
     &  :: wconc
      DOUBLE PRECISION, INTENT(OUT), DIMENSION (ncompo)
     &  :: flxnonloc_tot


      INTEGER, PARAMETER :: idntp1 = idnt + 1
      DOUBLE PRECISION, DIMENSION(ncompo)            :: afnl_na
      DOUBLE PRECISION, DIMENSION(ncompo)            :: afnl_nb


      INTEGER :: inode


      flxnonloc_tot(:) = 0.0D+00


      CALL NONLOCAL_TRANSPORT(jp_realm_reaclay, xzdn,   idnt,
     &                              xc, wconc, afnl_na)

      CALL NONLOCAL_TRANSPORT(jp_realm_reaclay, xzdn, idntp1,
     &                              xc, wconc, afnl_nb)

      flxnonloc_tot(:) = flxnonloc_tot(:)
     &  + (xzdn(idnt+1)-xzdn(idnt))/2.0D+00
     &    * ((1.0D+00-thetatop)*afnl_na(:) + thetatop*afnl_nb(:))

      IF ((idnb - idnt) > 1) THEN

        flxnonloc_tot(:) = flxnonloc_tot(:)
     &    + (xzdn(idnt+2)-xzdn(idnt))/2.0D+00 * afnl_nb(:)


        IF ((idnb - idnt) == 2) afnl_na(:) = afnl_nb(:)

        DO inode = idnt+2, idnb-1

          CALL NONLOCAL_TRANSPORT(jp_realm_reaclay, xzdn, inode,
     &                              xc, wconc, afnl_na)
          flxnonloc_tot(:) = flxnonloc_tot(:)
     &      + (xzdn(inode+1)-xzdn(inode-1))/2.0D+00 * afnl_na(:)

        ENDDO

        CALL NONLOCAL_TRANSPORT(jp_realm_reaclay, xzdn, idnb,
     &                              xc, wconc, afnl_nb)

      ENDIF

      flxnonloc_tot(:) =
     &  flxnonloc_tot(:)
     &  + (xzdn(idnb)-xzdn(idnb-1))/2.0D+00
     &    * (thetabot*afnl_na(:) + (1.0D+00-thetabot)*afnl_nb(:))


      RETURN


!=======================================================================
      END SUBROUTINE NONLOCAL_TRANSPORT_TOTALS
!=======================================================================
