!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      DOUBLE PRECISION FUNCTION dkappa_exponfit(dmu)
!-----------------------------------------------------------------------

      IMPLICIT NONE


      DOUBLE PRECISION, INTENT(IN) :: dmu

                                    ! Refs:
                                    !  http://oeis.org/A002431 (numerators)
                                    !  http://oeis.org/A036278 (denominators)

      DOUBLE PRECISION, DIMENSION(7), PARAMETER :: dp_a =
     &  (/ 1.0D+00/3.0D+00 , 1.0D+00/45.0D+00 , 1.0D+00/472.5D+00 , 
     &     1.0D+00/4725.0D+00 , 1.0D+00/46777.5D+00 , 
     &     1382.0D+00/638512875.0D+00, 4.0D+00/18243225.0D+00 /)

      DOUBLE PRECISION :: dmu_half, dmu_half_2

      INTEGER :: n, j

      dmu_half = dmu*0.5D+00

      IF (ABS(dmu) < (2.0D+00**(-24))) THEN
        dkappa_exponfit = dmu_half * dp_a(1)
        RETURN
      ENDIF

      SELECT CASE(EXPONENT(dmu))
      CASE(-2:)
        dkappa_exponfit = 1.0D+00/TANH(dmu_half) - 1.0D+00/dmu_half
        RETURN
      CASE(-3)
        n = 5
      CASE(-6:-4)
        n = 4
      CASE(-10:-7)
        n = 3
      CASE(-23:-11)
        n = 2
      CASE DEFAULT
        dkappa_exponfit = dmu_half * dp_a(1)
        RETURN
      END SELECT

      dmu_half_2 = dmu_half*dmu_half
      dkappa_exponfit = dp_a(n)

      DO j = n-1, 1, -1
        dkappa_exponfit = dp_a(j) - dmu_half_2 * dkappa_exponfit
      ENDDO

      dkappa_exponfit = dmu_half * dkappa_exponfit


      RETURN


!-----------------------------------------------------------------------
      END FUNCTION dkappa_exponfit
!-----------------------------------------------------------------------
