!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef BIOIRRIGATION_CUSTOM
#include <birric_custom.F>
#else
!-----------------------------------------------------------------------
      SUBROUTINE BIRRIC(xzdn, xcompo, wconc, wfflx)
!-----------------------------------------------------------------------

!--------------
! Declarations
!--------------

      USE mod_basicdata_medusa
      USE mod_gridparam
      USE mod_indexparam

#ifdef DEBUG
      USE mod_defines_medusa,       ONLY: jp_stddbg
#endif


      IMPLICIT NONE


!-----------------------
! Variable declarations
!-----------------------

!- - - - - - - - - - - - -  - - - - - - -
! Variables in subroutine call arguments
!- - - - - - - - - - - - -- - - - - - - -

      DOUBLE PRECISION, DIMENSION (idnw:idnb)           :: xzdn
      DOUBLE PRECISION, DIMENSION (idnw:idnb, ncompo)   :: xcompo
      DOUBLE PRECISION, DIMENSION (nsolut)              :: wconc
      DOUBLE PRECISION, DIMENSION (nsolid)              :: wfflx


!- - - - - - - - - - - - - -  - - - - - - - -
! General (global) parameters and definitions
!- - - - - - - - - - - - - -- - - - - - - - -

      ! None


!- - - - - - - - -
! Local variables
!- - - - - - - - -

      INTEGER :: i


!- - - - - - - - - - -
! End of declarations
!- - - - - - - - - - -

!----------------------------------------------------------------------
! Subroutine Start
!----------------------------------------------------------------------

#ifdef DEBUG
#ifdef DEBUG_BIRRIC
#ifdef DEBUG_BIRRIC_ENTRY_EXIT
      WRITE(jp_stddbg,*) '[BIRRIC]: Starting'
#endif
#endif
#endif


      IF (.NOT. l_setupdone) CALL SETUP_TRANSPORT


      !---------------------------------------------
      ! Bioirrigation coefficient and its derivative
      !---------------------------------------------

      SELECT CASE(jselect_bioirr_profile)

      CASE DEFAULT

        rcf_bioirr(idnt:idnz) = 0.0D+00


      CASE(jp_bi_expdec)

        DO i = idnt, idnz
          rcf_bioirr(i) = da_bi_rcf_0 * EXP(-xzdn(i)/da_bi_expdec_scale)
        ENDDO


#ifdef BIOIRRIGATION_CUSTOM
      CASE(jp_bi_custom)            ! Bioirrigation coefficient according
      !-----------------            ! to a custom profile

        CALL BIRRIC_CUSTOM(xzdn, xcompo, wconc, wfflx)
#endif

      END SELECT

      rcf_bioirr(idnz+1:idnb) = 0.0D+00


#ifdef DEBUG
#ifdef DEBUG_BIRRIC
#ifdef DEBUG_BIRRIC_ENTRY_EXIT
      WRITE(jp_stddbg,*) '[BIRRIC]: Exiting'
#endif
#endif
#endif


      RETURN      


!-----------------------------------------------------------------------
      END SUBROUTINE BIRRIC
!-----------------------------------------------------------------------
#endif
