!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE SAVE_COLUMN(i_column, iflag,
     &           xzdn, xzdv, xphi, xdphi, xvphi, xvdphi, yphi,
     &           xc, ysolid, xwtot, xutot)
!-----------------------------------------------------------------------

      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  n_grid_seafloor (read only)
      !  reaclay_xzdn (write)
      !  reaclay_xphi (write)
      !  reaclay_xdphi (write)
      !  reaclay_profiles (write)
      !  tranlay_solids (write)
      !  reaclay_xw (write)
      !  reaclay_xu (write)

      USE mod_gridparam,    ONLY: idnw, idnt, idnb, idvw, idvs, idvb,
     &                            jp_grid_dynamic, jp_grid_static_local,
     &                            jp_grid_static_global,
     &                            SELECTED_GRIDTYPE

      USE mod_milieucharas, ONLY: jp_phi_dynamic, jp_phi_static_local,
     &                            jp_phi_static_global,
     &                            SELECTED_PHITYPE

      USE mod_indexparam, ONLY: ncompo, nsolid, nsolut



      IMPLICIT NONE


      INTEGER,                      INTENT(IN)
     &  :: i_column
      INTEGER,                      INTENT(OUT)
     &  :: iflag
      DOUBLE PRECISION, DIMENSION(idnw:idnb),
     &                              INTENT(IN), OPTIONAL
     &  :: xzdn
      DOUBLE PRECISION, DIMENSION(idvw:idvb),
     &                              INTENT(IN), OPTIONAL
     &  :: xzdv
      DOUBLE PRECISION, DIMENSION(idnt:idnb),
     &                              INTENT(IN), OPTIONAL
     &  :: xphi, xdphi
      DOUBLE PRECISION, DIMENSION(idvs:idvb),
     &                              INTENT(IN), OPTIONAL
     &  :: xvphi, xvdphi
      DOUBLE PRECISION,             INTENT(IN), OPTIONAL
     &  :: yphi
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo),
     &                              INTENT(IN), OPTIONAL
     &  :: xc
      DOUBLE PRECISION, DIMENSION(           nsolid),
     &                              INTENT(IN), OPTIONAL
     &  :: ysolid
      DOUBLE PRECISION, DIMENSION(idvs:idvb),
     &                              INTENT(IN), OPTIONAL
     &  :: xwtot
      DOUBLE PRECISION, DIMENSION(idvw:idvb),
     &                              INTENT(IN), OPTIONAL
     &  :: xutot


      INTEGER :: igrid_column, iphi_column
      INTEGER :: iselect_grid, iselect_phi



      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN

        iselect_grid = SELECTED_GRIDTYPE()
        iselect_phi  = SELECTED_PHITYPE()

        SELECT CASE(iselect_grid)
        CASE(jp_grid_static_global)
          igrid_column = 1
        CASE DEFAULT
          igrid_column = i_column
        END SELECT

        SELECT CASE(iselect_phi)
        CASE(jp_phi_static_global)
          iphi_column = 1
        CASE DEFAULT
          iphi_column = i_column
        END SELECT


        IF (PRESENT(xzdn))   reaclay_xzdn(:,igrid_column)   = xzdn(:)

        IF (PRESENT(xzdv))   reaclay_xzdv(:,igrid_column)   = xzdv(:)

        IF (PRESENT(xphi))   reaclay_xphi(:,iphi_column)    = xphi(:)

        IF (PRESENT(xdphi))  reaclay_xdphi(:,iphi_column)   = xdphi(:)

        IF (PRESENT(xvphi))  reaclay_xvphi(:,iphi_column)   = xvphi(:)

        IF (PRESENT(xvdphi)) reaclay_xvdphi(:,iphi_column)  = xvdphi(:)

        IF (PRESENT(yphi))   tranlay_yphi(iphi_column)      = yphi

        IF (PRESENT(xc))     reaclay_profiles(:,:,i_column) = xc(:,:)

        IF (PRESENT(xwtot))  reaclay_xwtot(:,i_column)      = xwtot(:)

        IF (PRESENT(xutot))  reaclay_xutot(:,i_column)      = xutot(:)

        IF (PRESENT(ysolid)) tranlay_solids(:, i_column)    = ysolid(:)

        iflag = 0                   ! flag everything everything OK for now

      ELSE

        iflag = 1                   ! illegal i_column value

      ENDIF

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE SAVE_COLUMN
!-----------------------------------------------------------------------
