!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE SAVE_BOUNDARY_FLUXES(i_column, iflag,
     &           bconc, wcflx, wcflx_bi, bfflx)
!-----------------------------------------------------------------------

      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  n_grid_seafloor (read only)
      !  reaclay_bconc (write)
      !  reaclay_wcflx (write)
      !  reaclay_bfflx (write)


      USE mod_indexparam, ONLY: nsolut, nsolid
      

      IMPLICIT NONE


      INTEGER,                             INTENT(IN)
     &  :: i_column
      INTEGER,                             INTENT(OUT)
     &  :: iflag

      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(IN), OPTIONAL
     &  :: bconc
      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(IN), OPTIONAL
     &  :: wcflx
      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(IN), OPTIONAL
     &  :: wcflx_bi
      DOUBLE PRECISION, DIMENSION(nsolid), INTENT(IN), OPTIONAL
     &  :: bfflx


      IF ((i_column>=1) .AND. (i_column <= n_grid_seafloor)) THEN

        IF (PRESENT(bconc)) reaclay_bconc(:,i_column) = bconc(:)
        IF (PRESENT(wcflx)) reaclay_wcflx(:,i_column) = wcflx(:)
        IF (PRESENT(wcflx_bi))
     &                   reaclay_wcflx_bi(:,i_column) = wcflx_bi(:)
        IF (PRESENT(bfflx)) reaclay_bfflx(:,i_column) = bfflx(:)

        iflag = 0                   ! everything OK

      ELSE

        iflag = 1                   ! illegal i_column value

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE SAVE_BOUNDARY_FLUXES
!-----------------------------------------------------------------------
