!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE SAVE_BOUNDARY_CONDS(i_column, gbcflag,
     &                              wdata, wconc, wfflx)
!-----------------------------------------------------------------------


      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  n_grid_seafloor (write)
      !  seafloor_wdbsl (write)
      !  seafloor_wtmpc (write)
      !  seafloor_wsalin (write)
      !  seafloor_wsolutes (write)
      !  seafloor_wfflx (write)


      USE mod_indexparam
      

      IMPLICIT NONE

      INTEGER,                             INTENT(IN)
     &  :: i_column
      INTEGER,                             INTENT(OUT)
     &  :: gbcflag

      TYPE (WDATA_CONTAINER),              INTENT(IN), OPTIONAL
     &  :: wdata
      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(IN), OPTIONAL
     &  :: wconc
      DOUBLE PRECISION, DIMENSION(nsolid), INTENT(IN), OPTIONAL
     &  :: wfflx


      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN

        IF (PRESENT(wdata))  seafloor_wdata(i_column)       = wdata

        IF (PRESENT(wconc))  seafloor_wsolutes(:, i_column) = wconc(:)

        IF (PRESENT(wfflx))  seafloor_wfflx(:,i_column)     = wfflx(:)

        gbcflag = 0

      ELSE

        gbcflag = 1                 ! Flag illegal i_column value

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE SAVE_BOUNDARY_CONDS
!-----------------------------------------------------------------------
