!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE SAVE_AREA4N(i_column, iflag, sfc_area)
!-----------------------------------------------------------------------

      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  n_grid_seafloor (read only)
      !  seafloor_surf (write)


      IMPLICIT NONE

      INTEGER,          INTENT(IN)           :: i_column
      INTEGER,          INTENT(OUT)          :: iflag
      DOUBLE PRECISION, INTENT(IN), OPTIONAL :: sfc_area

      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN
        IF (PRESENT(sfc_area)) THEN
          seafloor_surf(i_column)  = sfc_area
          iflag = 0
        ENDIF
      ELSE
        iflag = 1 ! illegal i_column value
      ENDIF

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE SAVE_AREA4N
!-----------------------------------------------------------------------
