!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      SUBROUTINE GET_MILIEUCHARAS(i_column, iflag)
!=======================================================================

! This subroutine loads porosity data for column <i_column>
! into MOD_MILIEUCHARAS and updates tortuosity data.


      USE mod_milieucharas,   ONLY: jp_phi_dynamic, jp_phi_static_local,
     &                              jp_phi_static_global,
     &                              SELECTED_PHITYPE,
     &                              xphi, xdphi, xvphi, xvdphi, yphi,
     &                              TORTUOSITY_UPDATE


      IMPLICIT NONE

      INTEGER, INTENT(IN)  :: i_column
      INTEGER, INTENT(OUT) :: iflag


      INTEGER :: iphi_column, iselect_phi


      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN

        iselect_phi  = SELECTED_PHITYPE()

        SELECT CASE(iselect_phi)
        CASE(jp_phi_static_global)
          iphi_column = 1
        CASE DEFAULT
          iphi_column = i_column
        END SELECT

                                    ! REACLAY phi and z-derivative at nodes
        xphi   = reaclay_xphi (:, iphi_column)
        xdphi  = reaclay_xdphi(:, iphi_column)

                                    ! REACLAY phi and z-derivative at vertices
        xvphi  = reaclay_xvphi (:, iphi_column)
        xvdphi = reaclay_xvdphi(:, iphi_column)

                                    ! TRANLAY phi
        yphi   = tranlay_yphi     (iphi_column)


        CALL TORTUOSITY_UPDATE()

        iflag = 0                   ! No error if we get here.

      ELSE

        iflag = 1                   ! Error: illegal i_column value.

      ENDIF


      RETURN

!=======================================================================
      END SUBROUTINE GET_MILIEUCHARAS
!=======================================================================
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
