!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE GET_COLUMN(i_column, iflag,
     &           xzdn, xzdv, xphi, xdphi, xvphi, xvdphi, yphi,
     &           xc, ysolid, xwtot, xutot)
!-----------------------------------------------------------------------

      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  n_grid_seafloor (read only)
      !  reaclay_xzdn (read only)
      !  reaclay_xphi (read only)
      !  reaclay_xdphi (read only)
      !  reaclay_profiles (read only)
      !  tranlay_solids (read only)
      !  reaclay_xw (read only)
      !  reaclay_xu (read only)

      USE mod_gridparam,    ONLY: idnw, idnt, idnb, idvw, idvs, idvb,
     &                            jp_grid_dynamic, jp_grid_static_local,
     &                            jp_grid_static_global,
     &                            SELECTED_GRIDTYPE

      USE mod_milieucharas, ONLY: jp_phi_dynamic, jp_phi_static_local,
     &                            jp_phi_static_global,
     &                            SELECTED_PHITYPE

      USE mod_indexparam, ONLY: ncompo, nsolid, nsolut



      IMPLICIT NONE


      INTEGER,                      INTENT(IN)
     &  :: i_column
      INTEGER,                      INTENT(OUT)
     &  :: iflag
      DOUBLE PRECISION, DIMENSION(idnw:idnb),
     &                              INTENT(OUT), OPTIONAL
     &  :: xzdn
      DOUBLE PRECISION, DIMENSION(idvw:idvb),
     &                              INTENT(OUT), OPTIONAL
     &  :: xzdv
      DOUBLE PRECISION, DIMENSION(idnt:idnb),
     &                              INTENT(OUT), OPTIONAL
     &  :: xphi, xdphi
      DOUBLE PRECISION, DIMENSION(idvs:idvb),
     &                              INTENT(OUT), OPTIONAL
     &  :: xvphi, xvdphi
      DOUBLE PRECISION,             INTENT(OUT), OPTIONAL
     &  :: yphi
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo),
     &                              INTENT(OUT), OPTIONAL
     &  :: xc
      DOUBLE PRECISION, DIMENSION(           nsolid),
     &                              INTENT(OUT), OPTIONAL
     &  :: ysolid
      DOUBLE PRECISION, DIMENSION(idvs:idvb),
     &                              INTENT(OUT), OPTIONAL
     &  :: xwtot
      DOUBLE PRECISION, DIMENSION(idvw:idvb),
     &                              INTENT(OUT), OPTIONAL
     &  :: xutot


      INTEGER :: igrid_column, iphi_column
      INTEGER :: iselect_grid, iselect_phi



      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN

        iselect_grid = SELECTED_GRIDTYPE()
        iselect_phi  = SELECTED_PHITYPE()

        SELECT CASE(iselect_grid)
        CASE(jp_grid_static_global)
          igrid_column = 1
        CASE DEFAULT
          igrid_column = i_column
        END SELECT

        SELECT CASE(iselect_phi)
        CASE(jp_phi_static_global)
          iphi_column = 1
        CASE DEFAULT
          iphi_column = i_column
        END SELECT


        IF (PRESENT(xzdn))   xzdn(:)   = reaclay_xzdn(:,igrid_column)

        IF (PRESENT(xzdv))   xzdv(:)   = reaclay_xzdv(:,igrid_column)

        IF (PRESENT(xphi))   xphi(:)   = reaclay_xphi(:,iphi_column)

        IF (PRESENT(xdphi))  xdphi(:)  = reaclay_xdphi(:,iphi_column)

        IF (PRESENT(xvphi))  xvphi(:)  = reaclay_xvphi(:,iphi_column)

        IF (PRESENT(xvdphi)) xvdphi(:) = reaclay_xvdphi(:,iphi_column)

        IF (PRESENT(yphi))   yphi      = tranlay_yphi(iphi_column)

        IF (PRESENT(xc))     xc(:,:)   = reaclay_profiles(:,:,i_column)

        IF (PRESENT(ysolid)) ysolid(:) = tranlay_solids(:,i_column)

        IF (PRESENT(xwtot))  xwtot(:)  = reaclay_xwtot(:,i_column)

        IF (PRESENT(xutot))  xutot(:)  = reaclay_xutot(:,i_column)

        iflag = 0                   ! everything OK

      ELSE

        iflag = 1                   ! illegal i_column value

      ENDIF

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE GET_COLUMN
!-----------------------------------------------------------------------
