!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE GET_BOUNDARY_FLUXES(i_column, gbfflag,
     &           bconc, wcflx, wcflx_bi, bfflx)
!-----------------------------------------------------------------------

      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  n_grid_seafloor (read only)
      !  reaclay_bconc (read only)
      !  reaclay_wcflx (read only)
      !  reaclay_bfflx (read only)

      USE mod_indexparam, ONLY: nsolut, nsolid
      

      IMPLICIT NONE


      INTEGER,                             INTENT(IN)
     &  :: i_column
      INTEGER,                             INTENT(OUT)
     &  :: gbfflag

      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(OUT), OPTIONAL
     &  :: bconc
      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(OUT), OPTIONAL
     &  :: wcflx
      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(OUT), OPTIONAL
     &  :: wcflx_bi
      DOUBLE PRECISION, DIMENSION(nsolid), INTENT(OUT), OPTIONAL
     &  :: bfflx

      
      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN

        IF (PRESENT(bconc)) bconc(:) = reaclay_bconc(:,i_column)
        IF (PRESENT(wcflx)) wcflx(:) = reaclay_wcflx(:,i_column)
        IF (PRESENT(wcflx_bi))
     &                   wcflx_bi(:) = reaclay_wcflx_bi(:,i_column)
        IF (PRESENT(bfflx)) bfflx(:) = reaclay_bfflx(:,i_column)

        gbfflag = 0 ! everything OK

      ELSE

        gbfflag = 1 ! illegal i_column value

      ENDIF

      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE GET_BOUNDARY_FLUXES
!-----------------------------------------------------------------------
