!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE GET_BOUNDARY_CONDS(i_column, gbcflag,
     &                              wdata, wconc, wfflx)
!-----------------------------------------------------------------------


      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  - n_grid_seafloor   (read only)
      !  - seafloor_wdbsl    (read only)
      !  - seafloor_wtmpc    (read only)
      !  - seafloor_wsalin   (read only)
      !  - seafloor_wsolutes (read only)
      !  - seafloor_wfflx    (read only)


      USE mod_indexparam, ONLY: nsolid, nsolut

      IMPLICIT NONE

      INTEGER,                             INTENT(IN)
     &  :: i_column
      INTEGER,                             INTENT(OUT)
     &  :: gbcflag

      TYPE (WDATA_CONTAINER),              INTENT(OUT), OPTIONAL
     &  :: wdata
      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(OUT), OPTIONAL
     &  :: wconc
      DOUBLE PRECISION, DIMENSION(nsolid), INTENT(OUT), OPTIONAL
     &  :: wfflx


      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN

        IF (PRESENT(wdata))  wdata    = seafloor_wdata(i_column)

        IF (PRESENT(wconc))  wconc(:) = seafloor_wsolutes(:, i_column)

        IF (PRESENT(wfflx))  wfflx(:) = seafloor_wfflx(:,i_column)

        gbcflag = 0

      ELSE

        gbcflag = 1                 ! Flag illegal i_column value

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE GET_BOUNDARY_CONDS
!-----------------------------------------------------------------------
