!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE IJ_ITJT_COLUMNS_USED(nix_columns,  njy_columns,
     &                                nitx_columns, njty_columns)
!-----------------------------------------------------------------------

      USE mod_defines_medusa, ONLY: jp_stderr
      USE mod_execontrol_medusa, ONLY: ABORT_MEDUSA

      ! Uses from MOD_SEAFLOOR_CENTRAL
      ! nix (read only)
      ! njy (read only)
      ! nitx (read only)
      ! njty (read only)

      IMPLICIT NONE

      INTEGER, INTENT(OUT) :: nix_columns
      INTEGER, INTENT(OUT) :: njy_columns
      INTEGER, INTENT(OUT) :: nitx_columns
      INTEGER, INTENT(OUT) :: njty_columns


      IF (      (nix  == -1) .OR. (njy  == -1)
     &     .OR. (nitx == -1) .OR. (njty == -1)) THEN

        WRITE(jp_stderr,'("[[IJ_ITJT_COLUMNS_USED]] error: ", A)')
     &    'MOD_SEAFLOOR_CENTRAL not yet set up -- aborting!'
        CALL ABORT_MEDUSA()   

      ELSE

        nix_columns  = nix
        njy_columns  = njy

        nitx_columns = nitx
        njty_columns = njty

      ENDIF

      RETURN 

!-----------------------------------------------------------------------
      END SUBROUTINE IJ_ITJT_COLUMNS_USED
!-----------------------------------------------------------------------
