!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!-----------------------------------------------------------------------
      SUBROUTINE COLUMN_N2IJ_ITJT(i_column, iflag, ix, jy, itx, jty)
!-----------------------------------------------------------------------

      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  n_grid_seafloor (read only)
      !  ix_seafloor (read only)
      !  jy_seafloor (read only)


      IMPLICIT NONE

      INTEGER, INTENT(IN)  :: i_column
      INTEGER, INTENT(OUT) :: iflag
      INTEGER, INTENT(OUT) :: ix, jy, itx, jty


#ifdef ALLOW_MPI
      IF (n_grid_seafloor == 0) THEN
        ix  = -1
        jy  = -1
        itx = -1
        jty = -1
        iflag = -1                  ! Flag a warning
        RETURN
      ENDIF
#endif

      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN

        ix  = ix_seafloor(i_column)
        jy  = jy_seafloor(i_column)
        itx = itx_seafloor(i_column)
        jty = jty_seafloor(i_column)

        iflag = 0

      ELSE

        iflag = 1                   ! Flag illegal i_column value

      ENDIF

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE COLUMN_N2IJ_ITJT
!-----------------------------------------------------------------------


