!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


      !-----------------------------------------------------------------
      SUBROUTINE COLUMN_N2I(i_column, iflag, ix)
      !-----------------------------------------------------------------

      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  n_grid_seafloor (read only)
      !  ix_seafloor (read only)


      IMPLICIT NONE

      INTEGER :: i_column, iflag, ix, jy

      INTENT(IN)  :: i_column
      INTENT(OUT) :: iflag
      INTENT(OUT) :: ix

      IF ((i_column >= 1) .AND. (i_column <= n_grid_seafloor)) THEN
        ix = ix_seafloor(i_column)
        iflag = 0
      ELSE
        iflag = 1 ! illegal i_column value
      ENDIF

      RETURN

      !-----------------------------------------------------------------
      END SUBROUTINE COLUMN_N2I
      !-----------------------------------------------------------------


