!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


      !-----------------------------------------------------------------
      SUBROUTINE COLUMN_I2N(ix, iflag, i_column)
      !-----------------------------------------------------------------

      ! Uses the following variables from MOD_SEAFLOOR_CENTRAL
      !  nix (read only)
      !  icolumn_seafloor (read only)

      USE mod_defines_medusa, ONLY: jp_is_not_at_seafloor_idx


      IMPLICIT NONE


      INTEGER, INTENT(IN)  :: ix
      INTEGER, INTENT(OUT) :: iflag
      INTEGER, INTENT(OUT) :: i_column


      IF ((ix >= 1) .AND. (ix <= nix)) THEN

        i_column = icolumn_seafloor(ix)

        IF(i_column == jp_is_not_at_seafloor_idx) THEN
          iflag = -1 ! issue warning
        ELSE
          iflag = 0
        ENDIF

      ELSE

        iflag = 1      ! illegal ix input value

      ENDIF


      RETURN


      !-----------------------------------------------------------------
      END SUBROUTINE COLUMN_I2N
      !-----------------------------------------------------------------

