!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      SUBROUTINE SOLVSED_TRACE(i_column, i_request, iflag, xzdn,
     &                         wdatan, wconcn, wfflxn,
     &                         xco, xcn, xwo, xwn, xuo, xun)
!=======================================================================

      USE mod_defines_medusa
      USE mod_gridparam, ONLY: idnw, idnt, idnb
      USE mod_indexparam, ONLY: ncompo, nsolid, nsolut
      USE mod_seafloor_central
      USE mod_seafloor_wdata

      IMPLICIT NONE

      INTEGER, INTENT(IN) :: i_column, i_request
      INTEGER, INTENT(OUT) :: iflag
      DOUBLE PRECISION, INTENT(IN), DIMENSION(idnw:idnb) :: xzdn
      TYPE(wdata_container), INTENT(IN) :: wdatan
      DOUBLE PRECISION, INTENT(IN), DIMENSION(nsolut) :: wconcn
      DOUBLE PRECISION, INTENT(IN), DIMENSION(nsolid) :: wfflxn
      DOUBLE PRECISION, INTENT(IN), DIMENSION(idnw:idnb, ncompo) ::
     &  xco, xcn
      DOUBLE PRECISION, INTENT(IN), DIMENSION(idnt:idnb) :: xwo, xwn
      DOUBLE PRECISION, INTENT(IN), DIMENSION(idnw:idnb) :: xuo, xun


      DOUBLE PRECISION :: wdbsln, wtmpdcn, wsalinn

      INTEGER :: ilon, jlat
      INTEGER :: i,j

      CHARACTER(LEN=63) :: cs_fmt1
      CHARACTER(LEN=85) :: cs_fmt2
      CHARACTER(LEN=55) :: cs_fmt3
      CHARACTER(LEN=5)  :: cs_ncompo

      wdbsln  = wdatan%wdbsl
      wtmpdcn = wdatan%wtmpc
      wsalinn = wdatan%wsalin

#ifdef MEDUSA_BASE2D
      CALL COLUMN_N2IJ(i_column, iflag, ilon, jlat)
      IF (iflag /= 0) RETURN
#else
      ilon = -1
      jlat = i_column
#endif

! Set up format strings
      
      WRITE(cs_ncompo,'(I5)') ncompo

      cs_fmt1 = "('Column ', I4,' (',I2,',',I2,') '," //
     &          "F7.1, F7.2, F6.2," // cs_ncompo // "E10.3)"

      cs_fmt2 = "('Column ', I4,' (',I2,',',I2,') '," //
     &          "F8.5, 2(1X, E10.3, E10.3)," //
     &    cs_ncompo // "(1X, E10.3, E10.3))"

      cs_fmt3 = "(20x,F8.5, 2(1X, E10.3, E10.3)," //
     &         cs_ncompo // "(1X, E10.3, E10.3))"


      WRITE(jp_traceboundccond_log,cs_fmt1) i_column, ilon, jlat,
     &                     wdbsln, wtmpdcn, wsalinn,
     &                     wfflxn, wconcn

      DO i = idnt, idnb, jp_trace_step
        IF(i == idnt) THEN
          WRITE(jp_tracexcwu_log,cs_fmt2)
     &      i_column, ilon, jlat, xzdn(i),
     &      xwo(i), xwn(i), xuo(i), xun(i),
     &      (xco(i,j), xcn(i,j), j=1, ncompo)
        ELSE
          WRITE(jp_tracexcwu_log,cs_fmt3) xzdn(i),
     &      xwo(i), xwn(i),xuo(i), xun(i),
     &      (xco(i,j), xcn(i,j), j=1, ncompo)
        ENDIF
      ENDDO
      WRITE(jp_tracexcwu_log,    '("------ ----")')
      WRITE(jp_tracexcpwpup_log, '("------ ----")')

      END SUBROUTINE SOLVSED_TRACE
