!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!===================================================================================================
SUBROUTINE WRITE_CONEQ_ARRAY_CONSTRUCTOR(iu, fmtcon, c_items, n_items, n_leadspc)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN, ONLY : n_lmaxfixformlength


IMPLICIT NONE

INTEGER, INTENT(IN) :: iu
CHARACTER(LEN=*), INTENT(IN) :: fmtcon
INTEGER, INTENT(IN) :: n_items
CHARACTER(LEN=*), DIMENSION(n_items), INTENT(IN) :: c_items
INTEGER, INTENT(IN) :: n_leadspc

INTEGER :: nlead, i, ibeg, iend, nlen_item
 
CHARACTER(LEN=n_lmaxfixformlength) :: c_codeline
WRITE(c_codeline, fmtcon) ','

iend = LEN_TRIM(c_codeline) - 1

c_codeline = c_codeline(1:iend)     ! trick to discard the printed ','
                                    ! and to fill the rest of c_codeline with blanks

ibeg  = iend + n_leadspc + 1
nlead = ibeg  + 3
c_codeline(ibeg:nlead) = '= (/'

iend = nlead
ibeg = iend + 1

DO i = 1, n_items

  IF (i < n_items) THEN
    nlen_item = LEN_TRIM(c_items(i)) + 2  ! 2 = length of ' ' // ','
  ELSE
    nlen_item = LEN_TRIM(c_items(i)) + 4  ! 4 = length of ' ' // ' /)'
  ENDIF

  IF ((n_lmaxfixformlength - iend) < nlen_item) THEN
    WRITE(iu, '(A)') TRIM(c_codeline)
    c_codeline = c_codeline(1:nlead-4)    ! strip the '= (/'
    iend = nlead                    ! align on the '/' of '(/'
    ibeg = iend + 1
  ENDIF

  iend = iend + nlen_item
  IF (i < n_items) THEN
    c_codeline(ibeg:iend) = ' ' // TRIM(c_items(i)) // ','
  ELSE
    c_codeline(ibeg:iend) = ' ' // TRIM(c_items(i)) // ' /)'
  ENDIF

  ibeg = iend + 1

ENDDO

WRITE(iu, '(A)') TRIM(c_codeline)


RETURN

!===================================================================================================
END SUBROUTINE WRITE_CONEQ_ARRAY_CONSTRUCTOR
!===================================================================================================
