!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!===================================================================================================
SUBROUTINE WRITE_ARRAY_CONSTRUCTOR(iu, fmtcon, c_items, n_items, n_itemsperline)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN, ONLY : n_lmaxcodeline


IMPLICIT NONE

INTEGER, INTENT(IN) :: iu
CHARACTER(LEN=*), INTENT(IN) :: fmtcon
INTEGER, INTENT(IN) :: n_items
CHARACTER(LEN=*), DIMENSION(n_items), INTENT(IN) :: c_items
INTEGER, INTENT(IN) :: n_itemsperline
 
INTEGER :: i, j
 
CHARACTER(LEN=n_lmaxcodeline) :: c_codeline


WRITE(iu, '("(/ ")', ADVANCE='NO')
 ! put <n_itemsperline> items per line

DO i = 1, (n_items-1)/n_itemsperline
   WRITE(c_codeline,*) (TRIM(c_items(j)) // ", ", &
                        j=(i-1)*n_itemsperline+1, &
                        i*n_itemsperline)
   IF(i == 1) THEN
      WRITE(iu,'(A)') TRIM(c_codeline)
   ELSE
      WRITE(iu,fmtcon) TRIM(c_codeline)
   ENDIF
ENDDO

   ! n_items  last_written next
   ! 1       -            1
   ! 2       -            1
   ! 3       -            1
   ! 4       3            4
   ! 5       3            4
   ! 6       3
   ! 7       6
   ! 8       6
   ! 9       6
   !         = ((n_items-1)/3)*3       
   !                      = ((neqns-1)/3)*3+1

WRITE(c_codeline,*) (TRIM(c_items(j)) // ", ", &
                     j=((n_items-1)/n_itemsperline)*n_itemsperline+1, n_items-1) , &
                    TRIM(c_items(n_items)) // "  /)"
IF(n_items <= n_itemsperline) THEN
   WRITE(iu,'(A)') TRIM(c_codeline)
ELSE
   WRITE(iu,fmtcon) TRIM(c_codeline)
ENDIF

RETURN

!===================================================================================================
END SUBROUTINE WRITE_ARRAY_CONSTRUCTOR
!===================================================================================================
