!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
 MODULE MOD_XMLCOCOGEN
!=======================================================================

USE MODMXM_STKXE, ONLY: stack_xmlevents
USE MODMXM_STKMX, ONLY: stack_minixml

USE MOD_MEDUSA_COCOGEN, ONLY: p_maxlen_filename => n_lmaxfilename

IMPLICIT NONE

INTEGER, PARAMETER :: p_maxlen_eltname  = 31
INTEGER, PARAMETER :: p_maxlen_attname  = 31
INTEGER, PARAMETER :: p_maxlen_attcntt  = 1023


! Element-tag names in the µXML files
CHARACTER(LEN=*), PARAMETER :: cp_composition  = 'Composition'
CHARACTER(LEN=*), PARAMETER :: cp_solute       = 'Solute'
CHARACTER(LEN=*), PARAMETER :: cp_solutesystem = 'SoluteSystem'
CHARACTER(LEN=*), PARAMETER :: cp_solid        = 'Solid'
CHARACTER(LEN=*), PARAMETER :: cp_equilibria   = 'Equilibria'
CHARACTER(LEN=*), PARAMETER :: cp_equilibrium  = 'Equilibrium'
CHARACTER(LEN=*), PARAMETER :: cp_processes    = 'Processes'
CHARACTER(LEN=*), PARAMETER :: cp_process      = 'Process'
CHARACTER(LEN=*), PARAMETER :: cp_apiextensions = 'APIExtensions'
CHARACTER(LEN=*), PARAMETER :: cp_apiextension = 'APIExtension'

! Element attribute names in the µXML file
CHARACTER(LEN=*), PARAMETER :: cp_file         = 'file'
CHARACTER(LEN=*), PARAMETER :: cp_order        = 'order'

CHARACTER(LEN=*), PARAMETER :: cp_realms       = 'realms'
CHARACTER(LEN=*), PARAMETER :: cp_realmdifblay = 'dbl'
CHARACTER(LEN=*), PARAMETER :: cp_realmreaclay = 'reaclay'
CHARACTER(LEN=*), PARAMETER :: cp_realmtranlay = 'tranlay'
CHARACTER(LEN=*), PARAMETER :: cp_realmcorelay = 'corelay'

CHARACTER(LEN=*), PARAMETER :: cp_type         = 'type'
CHARACTER(LEN=*), PARAMETER :: cp_typenormal   = 'normal'
CHARACTER(LEN=*), PARAMETER :: cp_typeparamed  = 'parameterized'
CHARACTER(LEN=*), PARAMETER :: cp_typeignored  = 'ignored'
CHARACTER(LEN=*), PARAMETER :: cp_class        = 'class'
!                           :: cp_classsolute  ! defined in MOD_MEDUSA_COCOGEN
!                           :: cp_classsolsys  ! defined in MOD_MEDUSA_COCOGEN
!                           :: cp_classsolid   ! defined in MOD_MEDUSA_COCOGEN
!                           :: cp_classorgmcnp ! defined in MOD_MEDUSA_COCOGEN
CHARACTER(LEN=*), PARAMETER :: cp_extra        = 'extra'
CHARACTER(LEN=*), PARAMETER :: cp_extramud     = 'mud'
CHARACTER(LEN=*), PARAMETER :: cp_suffix       = 'suffix'
CHARACTER(LEN=*), PARAMETER :: cp_master       = 'master'

CHARACTER(LEN=*), PARAMETER :: cp_names        = 'Names'
CHARACTER(LEN=*), PARAMETER :: cp_namesgeneric = 'Generic'
CHARACTER(LEN=*), PARAMETER :: cp_nameslong    = 'Long'
CHARACTER(LEN=*), PARAMETER :: cp_namesshortid = 'ShortID'

CHARACTER(LEN=*), PARAMETER :: cp_phypro       = 'PhysicalProperties'
!                           :: cp_phyprodensit ! defined in MOD_MEDUSA_COCOGEN
!                           :: cp_phypromolwgt ! defined in MOD_MEDUSA_COCOGEN

CHARACTER(LEN=*), PARAMETER :: cp_checom       = 'ChemicalComposition'

CHARACTER(LEN=*), PARAMETER :: cp_cnspro       = 'ConservationProperties'

CHARACTER(LEN=*), PARAMETER :: cp_codebits     = 'CodeBits'
!                           :: cp_diffcoeff    ! defined in MOD_MEDUSA_COCOGEN
!                           :: cp_totconc      ! defined in MOD_MEDUSA_COCOGEN
CHARACTER(LEN=*), PARAMETER :: cp_units        = 'units'
CHARACTER(LEN=*), PARAMETER :: cp_fortran      = 'Fortran'
CHARACTER(LEN=*), PARAMETER :: cp_vartype      = 'vartype'

CHARACTER(LEN=*), PARAMETER :: cp_cherea       = 'ChemicalReaction'
CHARACTER(LEN=*), PARAMETER :: cp_chereareact  = 'Reactant'
CHARACTER(LEN=*), PARAMETER :: cp_chereaprod   = 'Product'
CHARACTER(LEN=*), PARAMETER :: cp_chereaname   = 'Name'
CHARACTER(LEN=*), PARAMETER :: cp_chereastoech = 'StoechCoeff'
CHARACTER(LEN=*), PARAMETER :: cp_id           = 'id'
CHARACTER(LEN=*), PARAMETER :: cp_wildcard     = 'wildcard'

CHARACTER(LEN=*), PARAMETER :: cp_ratelaw      = 'RateLaw'
CHARACTER(LEN=*), PARAMETER :: cp_ratelawrefid = 'reference_id'
CHARACTER(LEN=*), PARAMETER :: cp_ratelawsubr  = 'subr'
CHARACTER(LEN=*), PARAMETER :: cp_ratelawxref  = 'xref'
CHARACTER(LEN=*), PARAMETER :: cp_lawmassa     = 'LawOfMassAction'
CHARACTER(LEN=*), PARAMETER :: cp_lawmassasubr = 'subr'
!                           :: cp_soluprod     ! defined in MOD_MEDUSA_COCOGEN
!                           :: cp_satuconc     ! defined in MOD_MEDUSA_COCOGEN
CHARACTER(LEN=*), PARAMETER :: cp_concprodsp   = 'ConcProductSpecies'
CHARACTER(LEN=*), PARAMETER :: cp_concprodsp1  = 'ConcProductSpecies1'
CHARACTER(LEN=*), PARAMETER :: cp_concprodsp2  = 'ConcProductSpecies2'
CHARACTER(LEN=*), PARAMETER :: cp_concprodpar  = 'ConcProductParam'
CHARACTER(LEN=*), PARAMETER :: cp_proportional = 'Proportional'
CHARACTER(LEN=*), PARAMETER :: cp_monodconc    = 'MonodConc'

CHARACTER(LEN=*), PARAMETER :: cp_delimiters   = ' ,;'

CHARACTER(LEN=*), PARAMETER :: cp_notfound     = 'not_found'
CHARACTER(LEN=*), PARAMETER :: cp_notapplicable = 'N/A'
CHARACTER(LEN=*), PARAMETER :: cp_ignore       = 'ignore'

! µXML description File-name and Stack List (double-linked)
TYPE xfs_list
  CHARACTER(LEN=p_maxlen_filename) :: fname
  CHARACTER(LEN=p_maxlen_eltname)  :: c_type
  INTEGER                          :: i_order
  INTEGER                          :: i_system
  TYPE(stack_xmlevents), POINTER   :: xe
  TYPE(stack_minixml),   POINTER   :: mx
  TYPE(xfs_list),        POINTER   :: prev
  TYPE(xfs_list),        POINTER   :: next
END TYPE


CONTAINS

!-----------------------------------------------------------------------
 FUNCTION XFSL_createRoot() RESULT(xfs_list_root)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_list_root

NULLIFY(xfs_list_root)
ALLOCATE(xfs_list_root)
NULLIFY(xfs_list_root%prev)

CALL XFSL_initNode(xfs_list_root)

RETURN
!-----------------------------------------------------------------------
END FUNCTION XFSL_createRoot
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
 FUNCTION XFSL_addNode(xfs_list_node) RESULT(xfs_list_newnode)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_list_node
TYPE(xfs_list), POINTER :: xfs_list_newnode

IF (ASSOCIATED(xfs_list_node)) THEN
  IF (.NOT. ASSOCIATED(xfs_list_node%next)) THEN
    ALLOCATE(xfs_list_node%next)
    xfs_list_newnode      => xfs_list_node%next
    xfs_list_newnode%prev => xfs_list_node
    CALL XFSL_initNode(xfs_list_newnode)
  ELSE
    WRITE(*,*) '[XFSL_addNode] error: <xfs_list_node> has already a %next node -- Aborting!'
    CALL ABORT()

  ENDIF
ELSE
  WRITE(*,*) '[XFSL_addNode] error: <xfs_list_node> not yet ASSOCIATEd -- Aborting!'
  CALL ABORT()
ENDIF
  
RETURN

!-----------------------------------------------------------------------
END FUNCTION XFSL_addNode
!-----------------------------------------------------------------------


!-----------------------------------------------------------------------
 SUBROUTINE XFSL_initNode(xfs_list_node)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_list_node

IF (ASSOCIATED(xfs_list_node)) THEN
  xfs_list_node%fname    = '/dev/null'
  xfs_list_node%c_type   = 'Unknown'
  xfs_list_node%i_order  = -1
  xfs_list_node%i_system = -1
  NULLIFY(xfs_list_node%xe)
  NULLIFY(xfs_list_node%mx)
  NULLIFY(xfs_list_node%next)
ELSE
  WRITE(*,*) '[XFSL_initNode] error: <xfs_list_node> not yet ASSOCIATEd -- Aborting!'
  CALL ABORT()
ENDIF

RETURN
  
!-----------------------------------------------------------------------
END SUBROUTINE XFSL_initNode
!-----------------------------------------------------------------------


!-----------------------------------------------------------------------
 FUNCTION XFSL_deleteTailNode(xfs_tail_node) RESULT(xfs_newtail_node)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_tail_node
TYPE(xfs_list), POINTER :: xfs_newtail_node


NULLIFY(xfs_newtail_node)

IF (ASSOCIATED(xfs_tail_node)) THEN

  IF (.NOT. ASSOCIATED(xfs_tail_node%next)) THEN
                                    ! If <xfs_tail_node> is actually a tail node
    CALL XFSL_initNode(xfs_tail_node)       ! re-initialise the node
    
    IF (ASSOCIATED(xfs_tail_node%prev)) THEN
                                    ! If <xfs_tail_node> is not the root node,
      xfs_newtail_node => xfs_tail_node%prev! step back to the previous node
      NULLIFY(xfs_newtail_node%next)
      DEALLOCATE(xfs_tail_node)             ! and deallocate the old tail node.

    ELSE
                                    ! If <xfs_tail_node> is the root node,
      DEALLOCATE(xfs_tail_node)     ! deallocate it. xfs_newtail_node => NULL() already
    ENDIF

    RETURN
    
  ELSE

    WRITE(*,*) '[XFSL_deleteTailNode] error: <xfs_tail_node> is not a tail node -- Aborting!'
    CALL ABORT()

  ENDIF

ELSE

  WRITE(*,*) '[XFSL_deleteTailNode] error: <xfs_tail_node> not yet ASSOCIATEd -- Aborting!'
  CALL ABORT()

ENDIF
  
RETURN

!-----------------------------------------------------------------------
END FUNCTION XFSL_deleteTailNode
!-----------------------------------------------------------------------




!-----------------------------------------------------------------------
 SUBROUTINE XFSL_dumpList(xfs_list_node, iunit)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_list_node
INTEGER, INTENT(IN), OPTIONAL :: iunit
TYPE(xfs_list), POINTER :: xfs_work

IF (ASSOCIATED(xfs_list_node)) THEN

  xfs_work => xfs_list_node
  
  DO WHILE(ASSOCIATED(xfs_work))

    IF (PRESENT(iunit)) THEN
      WRITE(iunit, '(" %fname = <", A, ">")') TRIM(xfs_work%fname)
      WRITE(iunit, '(" %c_type = <", A, ">")') TRIM(xfs_work%c_type)
      WRITE(iunit, '(" %i_order = ", I0)') xfs_work%i_order
      WRITE(iunit, '(" %i_system = ", I0)') xfs_work%i_system
      IF (ASSOCIATED(xfs_work%xe)) THEN
        WRITE(iunit, '(" %xe is associated")')
      ELSE
        WRITE(iunit, '(" %xe => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%xe)) THEN
        WRITE(iunit, '(" %mx is associated")')
      ELSE
        WRITE(iunit, '(" %mx => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%prev)) THEN
        WRITE(iunit, '(" %prev is associated")')
      ELSE
        WRITE(iunit, '(" %prev => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%next)) THEN
        WRITE(iunit, '(" %next is associated")')
      ELSE
        WRITE(iunit, '(" %next => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%next)) THEN
        WRITE(iunit, '("#")')
      ENDIF

    ELSE
    
      WRITE(*, '(" %fname = <", A, ">")') TRIM(xfs_work%fname)
      WRITE(*, '(" %c_type = <", A, ">")') TRIM(xfs_work%c_type)
      WRITE(*, '(" %i_order = ", I0)') xfs_work%i_order
      WRITE(*, '(" %i_system = ", I0)') xfs_work%i_system
      IF (ASSOCIATED(xfs_work%xe)) THEN
        WRITE(*, '(" %xe is associated")')
      ELSE
        WRITE(*, '(" %xe => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%xe)) THEN
        WRITE(*, '(" %mx is associated")')
      ELSE
        WRITE(*, '(" %mx => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%prev)) THEN
        WRITE(*, '(" %prev is associated")')
      ELSE
        WRITE(*, '(" %prev => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%next)) THEN
        WRITE(*, '(" %next is associated")')
      ELSE
        WRITE(*, '(" %next => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%next)) THEN
        WRITE(*, '("#")')
      ENDIF
    ENDIF

    xfs_work => xfs_work%next

  ENDDO

ELSE

  IF (PRESENT(iunit)) THEN
    WRITE(iunit, '(" => NULL ")')
  ELSE
    WRITE(*, '(" => NULL ")')
  ENDIF

ENDIF

RETURN
  
!-----------------------------------------------------------------------
END SUBROUTINE XFSL_dumpList
!-----------------------------------------------------------------------


!===============================================================================
 END MODULE MOD_XMLCOCOGEN
!===============================================================================
