!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!============================================================
 MODULE MOD_MEDUSA_COCOGEN
!============================================================

IMPLICIT NONE

! Maximum length of component generic names
INTEGER, PARAMETER :: n_lmaxnamesgen  =  20

! Maximum length of component long names
INTEGER, PARAMETER :: n_lmaxnameslong =  30

! Maximum length of component type
! names
INTEGER, PARAMETER :: n_lmaxcomptyp   =  30

! Maximum length of component short
! IDs (labels, acronyms)
INTEGER, PARAMETER :: n_lmaxshortid   =  10

! Maximum length of component phase
! IDs
INTEGER, PARAMETER :: n_lmaxphasid    =   2

! Maximum length of parameter function
! expressions
INTEGER, PARAMETER :: n_lmaxparfct    =  31

! Maximum length of process names
! Process names will also be used to derive identifiers
! (e.g., subroutine names) with up to seven more
! characters pre- or appended.
INTEGER, PARAMETER :: n_lmaxprocname  =  31-7

! Maximum length of subroutine names [appears not to be used in XML version]
INTEGER, PARAMETER :: n_lmaxsubrname  =  20

! Maximum length of expressions
INTEGER, PARAMETER :: n_lmaxexpress   =  1023

! Maximum length of identifiers
INTEGER, PARAMETER :: n_lmaxidentif   =  31

! Maximum length of code lines
INTEGER, PARAMETER :: n_lmaxcodeline  = 132
INTEGER, PARAMETER :: n_lxxlcodeline  = 1023   ! for intermediate, non-regularized codelines
INTEGER, PARAMETER :: n_lmaxfixformlength = 72

! Maximum length of format strings (arbitrarily chosen)
INTEGER, PARAMETER :: n_lmaxformat    =  80

! Maximum length of file name (i.e., full name, incl. access path)
INTEGER, PARAMETER :: n_lmaxfilename  = 4095


! Commonly used format specifications
                                    ! ForMaT for empty lines
CHARACTER(LEN=*), PARAMETER :: fmt_ = '()'
                                    ! ForMaT for indenting by 0 columns
CHARACTER(LEN=*), PARAMETER :: fmt0 = '(A)'
                                    ! ForMaT for indenting by 6 columns
CHARACTER(LEN=*), PARAMETER :: fmt6 = '(6X,A)'
                                    ! ForMaT for indenting by 36 columns (1/2 line)
CHARACTER(LEN=*), PARAMETER :: fmtc = '(36X,A)'
                                    ! ForMaT for CONtinuation line
CHARACTER(LEN=*), PARAMETER :: fmtcon = '(5X,"&",A)'
                                    ! ForMaT for CONtinuation line,
                                    ! with extra INDentation token @, to be
                                    ! used with for EXPAND*TOKEN
CHARACTER(LEN=*), PARAMETER :: fmtconind = '(5X,"&", @ A)'
                                    ! ForMaT for Mid-Line Comments
CHARACTER(LEN=*), PARAMETER :: fmtmlc = '(36X,"!",1X, A)'

! Commonly used string parameters

CHARACTER(LEN=*), PARAMETER :: cp_classsolute       = 'BasicSolute'
CHARACTER(LEN=*), PARAMETER :: cp_classsolsys       = 'SoluteSystem'
CHARACTER(LEN=*), PARAMETER :: cp_classsolid        = 'BasicSolid'
CHARACTER(LEN=*), PARAMETER :: cp_classorgmcnp      = 'OrgMatter_CNP'
CHARACTER(LEN=*), PARAMETER :: cp_classsolidpt      = 'SolidProductionTime'
CHARACTER(LEN=*), PARAMETER :: cp_classsolidcolour  = 'SolidColour'

CHARACTER(LEN=*), PARAMETER :: cp_phyprodensit      = 'Density'
CHARACTER(LEN=*), PARAMETER :: cp_phypromolwgt      = 'MolWeight'

CHARACTER(LEN=*), PARAMETER :: cp_alkalinity        = 'Alkalinity'
CHARACTER(LEN=*), PARAMETER :: cp_shortid_alk       = 'alk'

CHARACTER(LEN=*), PARAMETER :: cp_prefix_modlib     = 'modlib_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_ic         = 'ic_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_if         = 'if_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_io         = 'io_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_ioc        = 'ioc_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_iof        = 'iof_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_ioo        = 'ioo_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_cct        = 'cct_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_wdata      = 'wdata_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_ksp        = 'ksp_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_ksat       = 'ksat_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_dsat       = 'dsat_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_ttcc       = 'ttcc_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_cctksp     = cp_prefix_cct // cp_prefix_ksp
CHARACTER(LEN=*), PARAMETER :: cp_prefix_cctksat    = cp_prefix_cct // cp_prefix_ksat
CHARACTER(LEN=*), PARAMETER :: cp_prefix_cctdsat    = cp_prefix_cct // cp_prefix_dsat
CHARACTER(LEN=*), PARAMETER :: cp_prefix_cctttcc    = cp_prefix_cct // cp_prefix_ttcc
CHARACTER(LEN=*), PARAMETER :: cp_prefix_id         = 'id_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_idksp      = cp_prefix_id  // cp_prefix_ksp
CHARACTER(LEN=*), PARAMETER :: cp_prefix_idksat     = cp_prefix_id  // cp_prefix_ksat
CHARACTER(LEN=*), PARAMETER :: cp_prefix_iddsat     = cp_prefix_id  // cp_prefix_dsat
CHARACTER(LEN=*), PARAMETER :: cp_prefix_idttcc     = cp_prefix_id  // cp_prefix_ttcc
CHARACTER(LEN=*), PARAMETER :: cp_prefix_idwdata    = cp_prefix_id  // cp_prefix_wdata
CHARACTER(LEN=*), PARAMETER :: cp_prefix_datamolwgt = 'dp_mol_'

CHARACTER(LEN=*), PARAMETER :: cp_varname_dcfmolion = 'dcf_molion'
CHARACTER(LEN=*), PARAMETER :: cp_totconc           = 'TotalConcentration'
CHARACTER(LEN=*), PARAMETER :: cp_soluprod          = 'SolubilityProduct'
CHARACTER(LEN=*), PARAMETER :: cp_satuconc          = 'SaturationConc'
CHARACTER(LEN=*), PARAMETER :: cp_degrsatu          = 'DegreeSaturation'
CHARACTER(LEN=*), PARAMETER :: cp_diffcoeff         = 'DiffCoeff'
CHARACTER(LEN=*), PARAMETER :: cp_bracket_varname   = '{varname}'
CHARACTER(LEN=*), PARAMETER :: cp_wdatamember       = 'WDataMember'

CHARACTER(LEN=*), PARAMETER :: cp_prefix_checom     = 'ChemicalComposition_'
CHARACTER(LEN=*), PARAMETER :: cp_cnp_paramname_c   = cp_prefix_checom // 'C'
CHARACTER(LEN=*), PARAMETER :: cp_cnp_paramname_n   = cp_prefix_checom // 'N'
CHARACTER(LEN=*), PARAMETER :: cp_cnp_paramname_p   = cp_prefix_checom // 'P'
CHARACTER(LEN=*), PARAMETER :: cp_cnp_paramname_o   = cp_prefix_checom // 'O'
CHARACTER(LEN=*), PARAMETER :: cp_cnp_paramname_h   = cp_prefix_checom // 'H'

CHARACTER(LEN=*), PARAMETER :: cp_ftntype_dbleprec  = 'DOUBLE PRECISION'
CHARACTER(LEN=*), PARAMETER :: cp_ftntype_integer   = 'INTEGER'

CHARACTER(LEN=*), PARAMETER :: cp_nml_seafloorinit  = 'nml_seafloor_init'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_solidpcent = 'solid_pcent_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_solidpt_yr = 'solid_year_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_porewmolm3 = 'porew_molm3_'

CHARACTER(LEN=*), PARAMETER :: cp_nml_medusascales  = 'nml_medusa_scales'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_scalekgm3  = 'scale_kgm3_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_scaleyear  = 'scale_year_'
CHARACTER(LEN=*), PARAMETER :: cp_prefix_scalemolm3 = 'scale_molm3_'

! Common information
CHARACTER(LEN=*), PARAMETER :: cp_dir_modlib        = 'lib'
CHARACTER(LEN=*), PARAMETER :: cp_dir_xmlfiles      = 'xml'

!============================================================
 END MODULE MOD_MEDUSA_COCOGEN
!============================================================
