!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!============================================================
 MODULE MOD_INTERFACES
!============================================================

IMPLICIT NONE

INTERFACE
  SUBROUTINE INIT_DATACHAINS(c_baselist, t_compo, t_solsys, t_process, t_equilib, t_apiext)
  USE MOD_CONFIGURE_TYPES
  CHARACTER(LEN=*), INTENT(IN) :: c_baselist
  TYPE(PROCESS), POINTER       :: t_process
  TYPE(COMPOINFO),   POINTER   :: t_compo
  TYPE(SYSTEMSINFO), POINTER   :: t_solsys
  TYPE(EQUILIB), POINTER       :: t_equilib
  TYPE(APIEXTENSION), POINTER  :: t_apiext
  END SUBROUTINE INIT_DATACHAINS
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MOD_SEAFLOOR_WDATA(t_apiext)
  USE MOD_CONFIGURE_TYPES
  TYPE(APIEXTENSION), INTENT(IN), TARGET :: t_apiext
  END SUBROUTINE CREATE_MOD_SEAFLOOR_WDATA
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_FLUX2DAE(equilib_chain, t_solsys_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(EQUILIB),     INTENT(IN), TARGET :: equilib_chain
  TYPE(SYSTEMSINFO), INTENT(IN), TARGET :: t_solsys_chain
  END SUBROUTINE CREATE_FLUX2DAE
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MOD_EQUILIBSUBR(equilib_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(EQUILIB), INTENT(IN), TARGET :: equilib_chain
  END SUBROUTINE CREATE_MOD_EQUILIBSUBR
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MOD_INDEXPARAM(t_compo_chain, t_equilib_chain, t_solsys_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO),   INTENT(IN), TARGET :: t_compo_chain
  TYPE(EQUILIB),     INTENT(IN), TARGET :: t_equilib_chain
  TYPE(SYSTEMSINFO), INTENT(IN), TARGET :: t_solsys_chain
  END SUBROUTINE CREATE_MOD_INDEXPARAM
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MOD_PROCESSSUBR(t_process_chain, t_compo_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(PROCESS), INTENT(IN), TARGET   :: t_process_chain
  TYPE(COMPOINFO), INTENT(IN), TARGET :: t_compo_chain
  END SUBROUTINE CREATE_MOD_PROCESSSUBR
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MDIFFC(t_compo_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO), INTENT(IN), TARGET  :: t_compo_chain
  END SUBROUTINE CREATE_MDIFFC
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MOD_MATERIALCHARAS(t_compo_chain, t_solsys_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO),   INTENT(IN), TARGET  :: t_compo_chain
  TYPE(SYSTEMSINFO), INTENT(IN), TARGET  :: t_solsys_chain
  END SUBROUTINE CREATE_MOD_MATERIALCHARAS
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_SEAFLOOR_SETUP(t_compo_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO),   INTENT(IN), TARGET  :: t_compo_chain
  END SUBROUTINE CREATE_SEAFLOOR_SETUP
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MOD_NETCDFPARAM(t_compo_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO),    INTENT(IN), TARGET  :: t_compo_chain
  END SUBROUTINE CREATE_MOD_NETCDFPARAM
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MOD_READ_NCFILES(t_compo_chain,t_apiext_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO),    INTENT(IN), TARGET  :: t_compo_chain
  TYPE(APIEXTENSION), INTENT(IN), TARGET  :: t_apiext_chain
  END SUBROUTINE CREATE_MOD_READ_NCFILES
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MOD_STORE_NCFILES(t_compo_chain,t_apiext_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO),    INTENT(IN), TARGET  :: t_compo_chain
  TYPE(APIEXTENSION), INTENT(IN), TARGET  :: t_apiext_chain
  END SUBROUTINE CREATE_MOD_STORE_NCFILES
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_SETCCT(t_compo_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO), INTENT(IN), TARGET  :: t_compo_chain
  END SUBROUTINE CREATE_SETCCT
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_SPECIES_H(t_compo_root)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO), TARGET, INTENT(IN) :: t_compo_root
  END SUBROUTINE CREATE_SPECIES_H
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_MASS_BALANCES(t_compo_chain, t_solsys_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO),   INTENT(IN), TARGET  :: t_compo_chain
  TYPE(SYSTEMSINFO), INTENT(IN), TARGET  :: t_solsys_chain
  END SUBROUTINE CREATE_MASS_BALANCES
END INTERFACE


INTERFACE
  SUBROUTINE CREATE_SUBR_SEAFLOOR_INIT(t_compo_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO), INTENT(IN), TARGET  :: t_compo_chain
  END SUBROUTINE CREATE_SUBR_SEAFLOOR_INIT
END INTERFACE

INTERFACE
  SUBROUTINE CREATE_SOLVSED_CODES(t_compo_chain)
  USE MOD_CONFIGURE_TYPES
  TYPE(COMPOINFO),   INTENT(IN), TARGET :: t_compo_chain
  END SUBROUTINE CREATE_SOLVSED_CODES
END INTERFACE

!============================================================
 END MODULE MOD_INTERFACES
!============================================================
